/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import fr.ifremer.tutti.ui.swing.launcher.ExitCode;
import fr.ifremer.tutti.ui.swing.launcher.JavaCommand;
import fr.ifremer.tutti.ui.swing.launcher.LauncherProperties;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class Launcher {
    public static final String APPLICATION_LANCHER_TITLE = "Tutti UI Launcher";
    public static final String APPLICATION_DIR = "tutti";
    public static final String DATA_DIR = "data";
    public static final String UPDATER_JAR = "updater.jar";
    public static final String UPDATER_LOGFILE = "updater.log";
    public static final String FULL_LAUNCH_MODE = "full";
    public static final String DEBUG_ARG = "--debug";
    private final Path basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
    private final List<String> arguments;
    private final Path javaCommand;
    private final boolean debugMode;

    public static void main(String ... args) {
        boolean windowsOs = System.getProperty("os.name").startsWith("Windows");
        String javaCommandFilename = windowsOs ? "java.exe" : "java";
        Launcher launcher = new Launcher(javaCommandFilename, args);
        launcher.execute();
    }

    public Launcher(String javaCommandFilename, String ... args) {
        this.javaCommand = this.basedir.resolve("jre").resolve("bin").resolve(javaCommandFilename);
        List<String> fullArguments = Arrays.asList(args);
        this.debugMode = fullArguments.remove(DEBUG_ARG);
        this.arguments = Collections.unmodifiableList(fullArguments);
    }

    public void execute() {
        try {
            ExitCode exitCode;
            do {
                if ((exitCode = this.executeUpdate()) == ExitCode.RUNTIME_UPDATE) {
                    System.exit(exitCode.getExitCode());
                }
                if (exitCode != ExitCode.NORMAL) {
                    throw new RuntimeException("Tutti Updater has encountered a problem, program stopped.\nPlease check updater.log");
                }
                exitCode = this.executeApplication();
                if (exitCode != ExitCode.DELETE_DB) continue;
                this.deleteDb();
            } while (exitCode.isRelaunch());
            if (exitCode != ExitCode.NORMAL) {
                throw new RuntimeException("exit code = " + (Object)((Object)exitCode));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), APPLICATION_LANCHER_TITLE, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitCode executeUpdate() throws Exception {
        Path updatePath = this.basedir.resolve(APPLICATION_DIR).resolve(UPDATER_JAR);
        Path updateExecPath = this.basedir.resolve(UPDATER_JAR);
        Files.copy(updatePath, updateExecPath, StandardCopyOption.REPLACE_EXISTING);
        Path logfile = this.basedir.resolve(UPDATER_LOGFILE);
        try {
            ExitCode exitCode;
            JavaCommand program = JavaCommand.create(this.javaCommand).setJarPath(updateExecPath).setLogFile(logfile);
            ExitCode exitCode2 = exitCode = program.execute();
            return exitCode2;
        }
        finally {
            Files.delete(updateExecPath);
        }
    }

    protected ExitCode executeApplication() throws Exception {
        LauncherProperties launcherProperties = new LauncherProperties(this.basedir);
        launcherProperties.load();
        JavaCommand program = JavaCommand.create(this.javaCommand).setDebug(this.debugMode).setInheritIO(true).addArguments(launcherProperties.getJavaOptions()).addArgument("-Dtutti.log.file=" + launcherProperties.getLogFile().toString()).setJarPath(launcherProperties.getJarFile()).addArguments("--launch-mode", FULL_LAUNCH_MODE).addArguments("--basedir", this.basedir.toString()).addArgument(this.arguments);
        ExitCode exitCode = program.execute();
        return exitCode;
    }

    protected void deleteDb() throws Exception {
        Path dataPath = this.basedir.resolve(DATA_DIR);
        Files.walkFileTree(dataPath.resolve("db"), new RecursiveDeleteFileVisitor());
        Files.walkFileTree(dataPath.resolve("dbcache"), new RecursiveDeleteFileVisitor());
        Files.walkFileTree(dataPath.resolve("meas_files"), new RecursiveDeleteFileVisitor());
    }

    private class RecursiveDeleteFileVisitor
    extends SimpleFileVisitor<Path> {
        private RecursiveDeleteFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

