/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterPropertiesHelper;
import fr.ifremer.isisfish.types.TimeStep;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.topia.TopiaContext;

public class MatrixSummaryRenderer
implements MatrixRenderer {
    protected static final String ABONDANCE_STRING = I18n.n((String)"matrixAbundance", (Object[])new Object[0]);
    protected static final String CAPTUREPARMETIER_STRING = I18n.n((String)"matrixCatchPerStrategyMetPerZoneMet", (Object[])new Object[0]);
    protected static final String REJETPARMETIER_STRING = I18n.n((String)"matrixDiscardsPerStrMetPerZonePop", (Object[])new Object[0]);
    protected SimulationStorage simulationStorage;
    protected ResultStorage resultStorage;
    protected TopiaContext topiaContext;
    protected Component cachedComponent;

    public MatrixSummaryRenderer(SimulationStorage simulationStorage, ResultStorage resultStorage, TopiaContext topiaContext) {
        this.resultStorage = resultStorage;
        this.simulationStorage = simulationStorage;
        this.topiaContext = topiaContext;
    }

    public Component getComponent(MatrixND matrix) {
        if (this.cachedComponent == null) {
            SimulationParameter sp = this.simulationStorage.getParameter();
            Properties prop = sp.toProperties();
            String params = SimulationParameterPropertiesHelper.toString(prop);
            StringBuilder resume = new StringBuilder(params);
            resume.append("\n");
            for (String name : this.resultStorage.getResultName()) {
                try {
                    MatrixND mat1;
                    if (name.startsWith(ABONDANCE_STRING)) {
                        mat1 = this.resultStorage.getMatrix(new TimeStep(0), name, this.topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.reduce();
                        resume.append(I18n.t((String)"isisfish.result.begin.simulation", (Object[])new Object[0])).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                        mat1 = this.resultStorage.getMatrix(this.resultStorage.getLastStep(), name, this.topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.reduce();
                        resume.append(I18n.t((String)"isisfish.result.end.simulation", (Object[])new Object[0])).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                        continue;
                    }
                    if (name.startsWith(REJETPARMETIER_STRING)) {
                        mat1 = this.resultStorage.getMatrix(name, this.topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.sumOverDim(2);
                        mat1 = mat1.sumOverDim(3);
                        mat1 = mat1.reduce();
                        resume.append(I18n.t((String)"isisfish.common.sum", (Object[])new Object[0])).append(" ").append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                        continue;
                    }
                    if (name.startsWith(CAPTUREPARMETIER_STRING)) continue;
                    mat1 = this.resultStorage.getMatrix(name, this.topiaContext);
                    mat1 = mat1.sumOverDim(0);
                    mat1 = mat1.sumOverDim(1);
                    mat1 = mat1.sumOverDim(2);
                    mat1 = mat1.reduce();
                    resume.append(I18n.t((String)"isisfish.common.sum", (Object[])new Object[0])).append(" ").append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                }
                catch (Exception eee) {
                    resume.append(I18n.t((String)"isisfish.error.no.matrix", (Object[])new Object[]{name})).append("\n");
                }
            }
            resume.append("\n\n");
            resume.append(this.simulationStorage.getInformation().toString());
            this.cachedComponent = new JScrollPane(new JTextArea(resume.toString()));
        }
        return this.cachedComponent;
    }

    public Icon getIcon() {
        return null;
    }

    public String getName() {
        return I18n.t((String)"isisfish.result.summary", (Object[])new Object[0]);
    }
}

