/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.interval;

import fr.ifremer.isisfish.ui.widget.interval.Interval;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class IntervalGraphic
extends JComponent
implements Observer {
    private static final long serialVersionUID = -6795996897731533693L;
    private static final int HANDLE_WITH = 5;
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final Cursor W_RESIZE_CURSOR = new Cursor(10);
    private static final Cursor E_RESIZE_CURSOR = new Cursor(11);
    private static final Cursor MOVE_CURSOR = new Cursor(13);
    private Color backColor = Color.BLUE;
    private Color foreColor = Color.YELLOW;
    private Color lineColor = Color.YELLOW.darker();
    protected Interval model;
    protected float coef;
    protected float delta;
    private boolean inDrag = false;
    private int cursorType = 1;
    private boolean enable = true;

    public IntervalGraphic(Interval m) {
        this.setModel(m);
        this.addMouseListener(new MouseClick());
        this.addMouseMotionListener(new MouseMove());
    }

    public void setModel(Interval m) {
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        this.model = m;
        this.model.addObserver(this);
        this.update(this.model, null);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enable = enable;
    }

    protected void redraw(Graphics g) {
        this.coef = (float)this.getSize().width / (float)(this.model.getMax() + 1);
        int width = this.getSize().width;
        int height = this.getSize().height;
        Image ImageBuffer = this.createImage(width, height);
        Graphics tmpg = ImageBuffer.getGraphics();
        tmpg.setColor(this.backColor);
        tmpg.fillRect(0, 0, width, height);
        tmpg.setColor(this.foreColor);
        Integer first = null;
        Integer last = null;
        Interval.IntervalIterator i = (Interval.IntervalIterator)this.model.iterator();
        while (i.hasNext()) {
            int val = i.nextInt();
            if (first == null) {
                first = val;
            }
            last = val;
            tmpg.setColor(this.foreColor);
            tmpg.fillRect(Math.round((float)val * this.coef), 0, Math.round(this.coef), height);
            tmpg.setColor(this.lineColor);
            tmpg.drawRect(Math.round((float)val * this.coef), 0, Math.round(this.coef), height);
        }
        if (first != null) {
            tmpg.setColor(this.lineColor);
            tmpg.fillRect(Math.round((float)first.intValue() * this.coef), 0, 5, height);
            tmpg.fillRect(Math.round((float)(last + 1) * this.coef) - 5, 0, 5, height);
        }
        g.drawImage(ImageBuffer, 0, 0, this.getSize().width, this.getSize().height, (img, infoflags, x, y, width1, height1) -> true);
    }

    @Override
    public void paint(Graphics g) {
        this.redraw(g);
    }

    @Override
    public void update(Graphics g) {
        this.redraw(g);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }

    class MouseClick
    extends MouseAdapter {
        MouseClick() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int mouseX = e.getX();
            if (IntervalGraphic.this.model.getFirst() <= IntervalGraphic.this.model.getLast()) {
                IntervalGraphic.this.inDrag = (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef - 5.0f < (float)mouseX && (float)mouseX < (float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef + 5.0f;
            } else if (IntervalGraphic.this.model.getFirst() > IntervalGraphic.this.model.getLast()) {
                boolean bl = IntervalGraphic.this.inDrag = 0 <= mouseX && (float)mouseX < (float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef + 5.0f || (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef - 5.0f < (float)mouseX && mouseX <= IntervalGraphic.this.getSize().width;
            }
            if (IntervalGraphic.this.inDrag) {
                IntervalGraphic.this.delta = (float)mouseX - (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            IntervalGraphic.this.inDrag = false;
        }
    }

    class MouseMove
    extends MouseMotionAdapter {
        MouseMove() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!IntervalGraphic.this.inDrag && IntervalGraphic.this.enable) {
                int x = e.getX();
                if ((float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef - 5.0f < (float)x && (float)x < (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef + 5.0f) {
                    IntervalGraphic.this.cursorType = 0;
                    IntervalGraphic.this.setCursor(W_RESIZE_CURSOR);
                } else if ((float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef - 5.0f < (float)x && (float)x < (float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef + 5.0f) {
                    IntervalGraphic.this.cursorType = 2;
                    IntervalGraphic.this.setCursor(E_RESIZE_CURSOR);
                    IntervalGraphic.this.delta = (float)x - (float)IntervalGraphic.this.model.getLast() * IntervalGraphic.this.coef;
                } else {
                    boolean bool;
                    boolean bl = bool = IntervalGraphic.this.model.getFirst() <= IntervalGraphic.this.model.getLast() && (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef + 5.0f < (float)x && (float)x < (float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef - 5.0f || IntervalGraphic.this.model.getFirst() > IntervalGraphic.this.model.getLast() && (0 <= x && (float)x < (float)(IntervalGraphic.this.model.getLast() + 1) * IntervalGraphic.this.coef - 5.0f || (float)IntervalGraphic.this.model.getFirst() * IntervalGraphic.this.coef + 5.0f < (float)x && x <= IntervalGraphic.this.getSize().width);
                    if (bool) {
                        IntervalGraphic.this.cursorType = 1;
                        IntervalGraphic.this.setCursor(MOVE_CURSOR);
                    } else {
                        IntervalGraphic.this.cursorType = 4;
                        IntervalGraphic.this.setCursor(DEFAULT_CURSOR);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (IntervalGraphic.this.inDrag && IntervalGraphic.this.enable) {
                int x = e.getX();
                switch (IntervalGraphic.this.cursorType) {
                    case 0: {
                        if (x < 0) {
                            x = 0;
                        }
                        if (x > IntervalGraphic.this.getSize().width) {
                            x = IntervalGraphic.this.getSize().width;
                        }
                        IntervalGraphic.this.model.setFirst(Math.round((float)x / IntervalGraphic.this.coef));
                        break;
                    }
                    case 1: {
                        int decal = Math.round(((float)x - IntervalGraphic.this.delta) / IntervalGraphic.this.coef) - IntervalGraphic.this.model.getFirst();
                        IntervalGraphic.this.model.move(decal);
                        break;
                    }
                    case 2: {
                        if (x < 0) {
                            x = 0;
                        }
                        if (x > IntervalGraphic.this.getSize().width) {
                            x = IntervalGraphic.this.getSize().width;
                        }
                        IntervalGraphic.this.model.setLast(Math.round(((float)x - IntervalGraphic.this.coef) / IntervalGraphic.this.coef));
                    }
                }
            }
        }
    }
}

