/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.spatial;

import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.map.DatabaseDataProvider;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.spatial.ChangeSpatialPreviewUI;
import fr.ifremer.isisfish.ui.input.spatial.SpatialChangeDataProvider;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class ChangeSpatialPreviewHandler {
    protected ChangeSpatialPreviewUI inputUI;
    protected Map<Zone, List<Cell>> zoneMap;
    protected Map<Port, Cell> portMap;
    protected List<Cell> cells;
    protected FisheryRegion oldFisheryRegion;
    protected FisheryRegion newFisheryRegion;

    public ChangeSpatialPreviewHandler(ChangeSpatialPreviewUI inputUI) {
        this.inputUI = inputUI;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public void setZoneMap(Map<Zone, List<Cell>> zoneMap) {
        this.zoneMap = zoneMap;
    }

    public void setPortMap(Map<Port, Cell> portMap) {
        this.portMap = portMap;
    }

    public void setNewFisheryRegion(FisheryRegion newFisheryRegion) {
        this.newFisheryRegion = newFisheryRegion;
    }

    public void setOldFisheryRegion(FisheryRegion oldFisheryRegion) {
        this.oldFisheryRegion = oldFisheryRegion;
    }

    public void completeSetup() {
        this.initMapClick();
        this.initMapProviders();
    }

    protected void initMapClick() {
        new OpenMapEvents(this.inputUI.currentZoneMap, (CoordMouseMode)new SelectMouseMode(true), 0){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                return false;
            }
        };
        new OpenMapEvents(this.inputUI.currentPortMap, (CoordMouseMode)new SelectMouseMode(true), 0){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                return false;
            }
        };
        new OpenMapEvents(this.inputUI.newZoneMap, (CoordMouseMode)new SelectMouseMode(false), 2){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                Zone selectedValue = (Zone)ChangeSpatialPreviewHandler.this.inputUI.currentZones.getSelectedItem();
                ChangeSpatialPreviewHandler.this.zoneMap.put(selectedValue, ChangeSpatialPreviewHandler.this.inputUI.newZoneMap.getSelectedCells());
                ChangeSpatialPreviewHandler.this.updateZoneCellDetails();
                return false;
            }
        };
        new OpenMapEvents(this.inputUI.newPortMap, (CoordMouseMode)new SelectMouseMode(false), 1){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                Port selectedValue = (Port)ChangeSpatialPreviewHandler.this.inputUI.currentPorts.getSelectedItem();
                List<Cell> selectedCells = ChangeSpatialPreviewHandler.this.inputUI.newPortMap.getSelectedCells();
                if (!selectedCells.isEmpty()) {
                    ChangeSpatialPreviewHandler.this.portMap.put(selectedValue, selectedCells.get(0));
                }
                ChangeSpatialPreviewHandler.this.updatePortCellDetails();
                return false;
            }
        };
    }

    protected void initMapProviders() {
        List<Zone> zones = this.oldFisheryRegion.getZone();
        List<Port> ports = this.oldFisheryRegion.getPort();
        this.inputUI.currentZones.setModel(new GenericComboModel<Zone>(zones));
        this.inputUI.currentZoneMap.setMapDataProvider(new DatabaseDataProvider(this.inputUI.currentZoneMap, this.oldFisheryRegion));
        this.inputUI.currentPorts.setModel(new GenericComboModel<Port>(ports));
        this.inputUI.currentPortMap.setMapDataProvider(new DatabaseDataProvider(this.inputUI.currentPortMap, this.oldFisheryRegion));
        SpatialChangeDataProvider spatialChangeDataProvider = new SpatialChangeDataProvider(this.newFisheryRegion, this.cells);
        this.inputUI.newZoneMap.setMapDataProvider(spatialChangeDataProvider);
        this.inputUI.newPortMap.setMapDataProvider(spatialChangeDataProvider);
    }

    public void currentZoneChanged() {
        Zone selectedValue = (Zone)this.inputUI.currentZones.getSelectedItem();
        this.inputUI.currentZoneMap.setSelectedCells(selectedValue.getCell());
        List<Cell> newCells = this.zoneMap.get(selectedValue);
        this.inputUI.newZoneMap.setSelectedCells(newCells);
        this.updateZoneCellDetails();
    }

    protected void updateZoneCellDetails() {
        Zone selectedValue = (Zone)this.inputUI.currentZones.getSelectedItem();
        if (selectedValue != null) {
            List<Cell> currentCells = selectedValue.getCell();
            this.inputUI.currentZoneCells.setText(this.cellToString(currentCells));
            List<Cell> newCells = this.zoneMap.get(selectedValue);
            this.inputUI.newZoneCells.setText(this.cellToString(newCells));
        }
    }

    protected String cellToString(List<Cell> cells) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Cell cell : cells) {
            strings.add(cell.getName());
        }
        return StringUtils.join(strings, (String)", ");
    }

    public void currentPortChanged() {
        Port selectedValue = (Port)this.inputUI.currentPorts.getSelectedItem();
        this.inputUI.currentPortMap.setSelectedCells(selectedValue.getCell());
        Cell newPort = this.portMap.get(selectedValue);
        this.inputUI.newPortMap.setSelectedCells(newPort);
        this.updatePortCellDetails();
    }

    protected void updatePortCellDetails() {
        Port selectedValue = (Port)this.inputUI.currentPorts.getSelectedItem();
        if (selectedValue != null) {
            Cell newPort;
            Cell cell = selectedValue.getCell();
            if (cell != null) {
                this.inputUI.currentPortCell.setText(cell.getName());
            }
            if ((newPort = this.portMap.get(selectedValue)) != null) {
                this.inputUI.newPortCell.setText(newPort.getName());
            }
        }
    }

    public void valid() {
        int response = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.changeSpatial.confirmvalidmessage", (Object[])new Object[0]), I18n.t((String)"isisfish.changeSpatial.confirmvalidtitle", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            this.swapPortAndZoneCells();
            this.oldFisheryRegion.getTopiaContext().commitTransaction();
            InputSaveVerifier inputSaveVerifier = this.inputUI.getContextValue(InputSaveVerifier.class);
            inputSaveVerifier.cancel();
            InputUI parentInputUI = this.inputUI.getContextValue(InputUI.class, "parent");
            parentInputUI.getHandler().loadRegion(this.oldFisheryRegion.getName());
            this.close();
        }
    }

    public void close() {
        this.inputUI.dispose();
    }

    protected void swapPortAndZoneCells() {
        Object newCell;
        CellDAO cellDAO = IsisFishDAOHelper.getCellDAO(this.oldFisheryRegion.getTopiaContext());
        this.oldFisheryRegion.setCellLengthLatitude(this.newFisheryRegion.getCellLengthLatitude());
        this.oldFisheryRegion.setCellLengthLongitude(this.newFisheryRegion.getCellLengthLongitude());
        this.oldFisheryRegion.setMaxLatitude(this.newFisheryRegion.getMaxLatitude());
        this.oldFisheryRegion.setMaxLongitude(this.newFisheryRegion.getMaxLongitude());
        this.oldFisheryRegion.setMinLatitude(this.newFisheryRegion.getMinLatitude());
        this.oldFisheryRegion.setMinLongitude(this.newFisheryRegion.getMinLongitude());
        this.oldFisheryRegion.update();
        List<Cell> currentCells = this.oldFisheryRegion.getCell();
        cellDAO.deleteAll(currentCells);
        for (Cell cell : this.cells) {
            cellDAO.create((TopiaEntity)cell);
        }
        for (Map.Entry entry : this.zoneMap.entrySet()) {
            Zone zone = (Zone)entry.getKey();
            newCell = (List)entry.getValue();
            zone.clearCell();
            zone.addAllCell((List<Cell>)newCell);
        }
        for (Map.Entry entry : this.portMap.entrySet()) {
            Port port = (Port)entry.getKey();
            newCell = (Cell)entry.getValue();
            port.setCell((Cell)newCell);
        }
    }
}

