/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;

public class Month
implements Cloneable,
Serializable,
Comparable<Month> {
    private static final long serialVersionUID = 1L;
    public static final Month JANUARY = new Month(0);
    public static final Month FEBRUARY = new Month(1);
    public static final Month MARCH = new Month(2);
    public static final Month APRIL = new Month(3);
    public static final Month MAY = new Month(4);
    public static final Month JUNE = new Month(5);
    public static final Month JULY = new Month(6);
    public static final Month AUGUST = new Month(7);
    public static final Month SEPTEMBER = new Month(8);
    public static final Month OCTOBER = new Month(9);
    public static final Month NOVEMBER = new Month(10);
    public static final Month DECEMBER = new Month(11);
    public static final Month[] MONTH = new Month[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
    public static final int[] NUMBERS_OF_DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int NUMBER_OF_MONTH = MONTH.length;
    public static final int MAX_MONTH_NUMBER = NUMBER_OF_MONTH - 1;
    protected int monthNumber = 0;

    public Month(int monthNumber) {
        this.setMonthNumber(monthNumber);
    }

    public int getMonthNumber() {
        return this.monthNumber;
    }

    public void setMonthNumber(int monthNumber) {
        this.monthNumber = monthNumber;
    }

    public Month next() {
        Month nextMonth = MONTH[(this.getMonthNumber() + 1) % NUMBER_OF_MONTH];
        return nextMonth;
    }

    public Month previous() {
        Month nextMonth = MONTH[(NUMBER_OF_MONTH + this.getMonthNumber() - 1) % NUMBER_OF_MONTH];
        return nextMonth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.monthNumber;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Month) {
            Month m = (Month)o;
            return this.getMonthNumber() == m.getMonthNumber();
        }
        return false;
    }

    public String toString() {
        switch (this.getMonthNumber()) {
            case 0: {
                return I18n.t((String)"isisfish.month.january", (Object[])new Object[0]);
            }
            case 1: {
                return I18n.t((String)"isisfish.month.february", (Object[])new Object[0]);
            }
            case 2: {
                return I18n.t((String)"isisfish.month.march", (Object[])new Object[0]);
            }
            case 3: {
                return I18n.t((String)"isisfish.month.april", (Object[])new Object[0]);
            }
            case 4: {
                return I18n.t((String)"isisfish.month.may", (Object[])new Object[0]);
            }
            case 5: {
                return I18n.t((String)"isisfish.month.june", (Object[])new Object[0]);
            }
            case 6: {
                return I18n.t((String)"isisfish.month.july", (Object[])new Object[0]);
            }
            case 7: {
                return I18n.t((String)"isisfish.month.august", (Object[])new Object[0]);
            }
            case 8: {
                return I18n.t((String)"isisfish.month.september", (Object[])new Object[0]);
            }
            case 9: {
                return I18n.t((String)"isisfish.month.october", (Object[])new Object[0]);
            }
            case 10: {
                return I18n.t((String)"isisfish.month.november", (Object[])new Object[0]);
            }
            case 11: {
                return I18n.t((String)"isisfish.month.december", (Object[])new Object[0]);
            }
        }
        return "" + this.getMonthNumber();
    }

    public boolean before(Month d) {
        return this.getMonthNumber() < d.getMonthNumber();
    }

    public boolean after(Month d) {
        return this.getMonthNumber() > d.getMonthNumber();
    }

    public boolean beforeOrEquals(Month d) {
        return this.getMonthNumber() <= d.getMonthNumber();
    }

    public boolean afterOrEquals(Month d) {
        return this.getMonthNumber() >= d.getMonthNumber();
    }

    @Override
    public int compareTo(Month d) {
        if (this.before(d)) {
            return -1;
        }
        if (this.after(d)) {
            return 1;
        }
        return 0;
    }

    public int getNumbersOfDays() {
        int result = NUMBERS_OF_DAYS[this.getMonthNumber()];
        return result;
    }

    public static List<Month> getMonths(Month first, Month last) {
        ArrayList<Month> result = new ArrayList<Month>();
        result.add(first);
        while (first.before(last)) {
            first = first.next();
            result.add(first);
        }
        return result;
    }
}

