/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.ui.keystore.PasswordManager;
import fr.ifremer.isisfish.util.IsisFileUtil;
import fr.ifremer.isisfish.util.ftp.ControlCopyStreamListener;
import fr.ifremer.isisfish.util.ftp.FtpManager;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import fr.ifremer.isisfish.util.ssh.SSHAgent;
import fr.ifremer.isisfish.util.ssh.SSHException;
import fr.ifremer.isisfish.util.ssh.SSHUserInfo;
import fr.ifremer.isisfish.util.ssh.SSHUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.io.CopyStreamListener;
import org.nuiton.i18n.I18n;
import org.nuiton.util.MD5InputStream;
import org.nuiton.util.StringUtil;
import org.nuiton.util.ZipUtil;

public class SSHSimulatorLauncher
implements SimulatorLauncher {
    protected static Log log = LogFactory.getLog(SSHSimulatorLauncher.class);
    protected Configuration freemarkerConfiguration;
    protected static final String QSUB_SCRIPT_TEMPLATE = "templates/ssh/qsub-script.ftl";
    protected static final String REMOTE_TEMP_DIR = "isis-temp-4";
    protected static final String SSH_TEMP_PATH = "$SCRATCH/eftp/isis-temp-4/";
    protected static final String FTP_TEMP_PATH = "/scratch/isis-temp-4/";
    protected static Session sshSession;

    public SSHSimulatorLauncher() {
        this.initFreemarker();
    }

    protected void initFreemarker() {
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_30);
        this.freemarkerConfiguration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(SSHSimulatorLauncher.class, "/");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
    }

    protected void message(SimulationControl control, String message) {
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
        if (control != null) {
            control.setText(message);
        }
    }

    @Override
    public int maxSimulationThread() {
        int maxSimulationThread = IsisFish.config.getSimulatorSshMaxThreads();
        if (maxSimulationThread <= 0) {
            maxSimulationThread = 1;
        }
        return maxSimulationThread;
    }

    @Override
    public int getCheckProgressionInterval() {
        int interval = IsisFish.config.getSimulatorSshControlCheckInterval();
        return interval;
    }

    public String toString() {
        return I18n.t((String)"isisfish.simulator.launcher.remote", (Object[])new Object[0]);
    }

    @Override
    public void simulationStopRequest(SimulationJob job) throws RemoteException {
        try {
            this.getSSHSession();
        }
        catch (JSchException e) {
            throw new RemoteException("Can't connect", e);
        }
        SimulationItem simulationItem = job.getItem();
        if (simulationItem.isStandaloneSimulation()) {
            try {
                this.sendStopSimulationRequest(sshSession, simulationItem.getControl().getId());
            }
            catch (SSHException e) {
                throw new RemoteException("Can't connect", e);
            }
        }
        if (simulationItem.isLastSimulation()) {
            String simulationid = simulationItem.getControl().getId();
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            try {
                this.sendStopSimulationRequest(sshSession, shortSimulationId);
            }
            catch (SSHException e) {
                throw new RemoteException("Can't connect", e);
            }
        }
    }

    @Override
    public void simulate(SimulationService simulationService, SimulationItem simulationItem) throws RemoteException {
        SimulationControl control = simulationItem.getControl();
        File simulationZip = simulationItem.getSimulationZip();
        String simulationPrescript = simulationItem.getGeneratedPrescriptContent();
        if (StringUtils.isBlank((CharSequence)IsisFish.config.getSimulatorSshUsername())) {
            throw new RemoteException("Username is empty");
        }
        try {
            String simulationid = control.getId();
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.connection", (Object[])new Object[0]));
            Session sshSession = this.getSSHSession();
            FTPClient ftp = this.getFtpClient();
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.upload", (Object[])new Object[0]));
            String simulationRemotePath = this.uploadSimulationIfNecessary(ftp, simulationItem, simulationid, simulationZip);
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.waitingstart", (Object[])new Object[0]));
            String simulationPreScriptPath = this.uploadPreScriptIfNecessary(ftp, control.getId(), simulationPrescript);
            String remoteResultZip = SSH_TEMP_PATH + this.getResultArchiveName(simulationid);
            this.startSimulation(sshSession, ftp, simulationItem, simulationid, simulationRemotePath, remoteResultZip, simulationPreScriptPath);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.simulation.remote.global", (Object[])new Object[0]));
            }
            throw new RemoteException(I18n.t((String)"isisfish.error.simulation.remote.global", (Object[])new Object[0]), e);
        }
    }

    @Override
    public SimulationStorage getSimulationStorage(SimulationService simulationService, SimulationControl control) throws RemoteException {
        String simulationId = control.getId();
        SimulationStorage simulationStorage = SimulationStorage.getSimulation(simulationId);
        return simulationStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateControl(SimulationService simulationService, SimulationControl control) throws RemoteException {
        block33: {
            FTPClient ftpClient;
            try {
                this.getSSHSession();
            }
            catch (JSchException e) {
                throw new RemoteException("Can't connect", e);
            }
            try {
                ftpClient = this.getFtpClient();
            }
            catch (IOException e) {
                throw new RemoteException("Can't connect", e);
            }
            try {
                SimulationControl simulationControl;
                File md5ControlFile = this.downloadResultsMD5File(ftpClient, control.getId());
                if (md5ControlFile != null) {
                    File resultArchiveFile;
                    control.setText(I18n.t((String)"isisfish.simulation.remote.message.downloadresults", (Object[])new Object[0]));
                    String md5sum = FileUtils.readFileToString((File)md5ControlFile, (Charset)StandardCharsets.UTF_8);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("MD5 Control file have been downloaded : " + md5ControlFile.getAbsolutePath()));
                    }
                    if ((resultArchiveFile = this.downloadResultsArchive(ftpClient, control, md5sum)) != null) {
                        ZipUtil.uncompressFiltred((File)resultArchiveFile, (File)SimulationStorage.getSimulationDirectory(), (String[])new String[0]);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Simulation imported : " + resultArchiveFile.getAbsolutePath()));
                        }
                        resultArchiveFile.delete();
                        simulationControl = control;
                        synchronized (simulationControl) {
                            SimulationStorage.readControl(control.getId(), control, "stop");
                        }
                        this.clearSimulationFiles(ftpClient, control);
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)"Simulation zip download failed");
                    }
                    md5ControlFile.delete();
                }
                try {
                    File infoFile = this.downloadSimulationInformationFile(ftpClient, control.getId());
                    if (infoFile == null) break block33;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Information have been downloaded : " + infoFile.getAbsolutePath()));
                    }
                    Properties infoProperties = new Properties();
                    try (FileInputStream isInfoFile = new FileInputStream(infoFile);){
                        infoProperties.load(isInfoFile);
                    }
                    if (!StringUtils.isEmpty((CharSequence)infoProperties.getProperty("exception"))) {
                        simulationControl = control;
                        synchronized (simulationControl) {
                            control.setStopSimulationRequest(true);
                        }
                    }
                    infoFile.delete();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n.t((String)"Remote information file doesn't exists %s", (Object[])new Object[]{e.getMessage()}));
                    }
                }
            }
            catch (ConnectException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't connect", (Throwable)e);
                }
                try {
                    FtpManager.getInstance().closeFtpClient();
                }
                catch (IOException e2) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)I18n.t((String)"Can't close ftp connection", (Object[])new Object[0]), (Throwable)e2);
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block33;
                log.error((Object)I18n.t((String)"Can't download file", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    protected synchronized Session getSSHSession() throws JSchException {
        if (sshSession == null || !sshSession.isConnected()) {
            sshSession = this.openSSHSession();
        }
        return sshSession;
    }

    protected Session openSSHSession() throws JSchException {
        SSHUserInfo ui;
        Session session;
        File sshKey;
        boolean sshKeyUsed;
        block14: {
            JSch jsch = new JSch();
            String host = IsisFish.config.getSimulatorSshServer();
            String username = IsisFish.config.getSimulatorSshUsername();
            int port = 22;
            if (host.contains(":")) {
                block13: {
                    String sPort = host.substring(host.indexOf(58) + 1);
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block13;
                        log.warn((Object)I18n.t((String)"isisfish.error.simulation.remote.wrongportvalue", (Object[])new Object[]{sPort}));
                    }
                }
                host = host.substring(0, host.indexOf(58));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"Try to log on %s@%s:%d", (Object[])new Object[]{username, host, port}));
            }
            sshKeyUsed = false;
            sshKey = IsisFish.config.getSSHPrivateKeyFilePath();
            if (sshKey.isFile() && sshKey.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Ssh key found '%s' will be used to connect to", (Object[])new Object[]{sshKey.getAbsoluteFile(), host}));
                }
                jsch.addIdentity(sshKey.getAbsolutePath());
                sshKeyUsed = true;
            } else if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"Can't read ssh key : %s", (Object[])new Object[]{sshKey}));
            }
            session = jsch.getSession(username, host, port);
            ui = new SSHUserInfo();
            if (sshKeyUsed) {
                try {
                    char[] passChars = SSHAgent.getAgent().getPassphrase(sshKey);
                    if (passChars != null) {
                        String passphrase = String.valueOf(passChars);
                        ui.setPassphrase(passphrase);
                    }
                }
                catch (InvalidPassphraseException e) {
                    if (!log.isWarnEnabled()) break block14;
                    log.warn((Object)"Can't key passphrase for key", (Throwable)e);
                }
            }
        }
        session.setUserInfo((UserInfo)ui);
        session.connect(20000);
        if (session.isConnected() && sshKeyUsed && ui.getPassword() != null) {
            this.putSshKeyOnRemoteServer(session, sshKey);
        }
        return session;
    }

    protected void closeSSHSession(Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected FTPClient getFtpClient() throws IOException {
        return this.openFtpClient();
    }

    protected FTPClient openFtpClient() throws IOException {
        String host = IsisFish.config.getSimulatorFtpServer();
        int port = 21;
        if (host.contains(":")) {
            block3: {
                String sPort = host.substring(host.indexOf(58) + 1);
                try {
                    port = Integer.parseInt(sPort);
                }
                catch (NumberFormatException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.simulation.remote.wrongportvalue", (Object[])new Object[]{sPort}));
                }
            }
            host = host.substring(0, host.indexOf(58));
        }
        String login = IsisFish.config.getSimulatorFtpLogin();
        String password = PasswordManager.getInstance().getPassword(String.format("%s@%s", login, host));
        FTPClient ftp = FtpManager.getInstance().getFtpClient(host, port, login, password);
        return ftp;
    }

    protected void closeFTPClient(FTPClient ftpClient) throws IOException {
        FtpManager.getInstance().closeFtpClient();
    }

    protected void putSshKeyOnRemoteServer(Session session, File sshKey) {
        block5: {
            File publicKey = new File(String.valueOf(sshKey.getAbsoluteFile()) + ".pub");
            String command = "test -d .ssh||mkdir .ssh;echo \"%s\" >> .ssh/authorized_keys";
            try {
                List contents = FileUtils.readLines((File)publicKey, (Charset)StandardCharsets.UTF_8);
                if (CollectionUtils.size((Object)contents) == 1) {
                    command = String.format(command, contents.get(0));
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Add key on remote authorized keys");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("command is : " + command));
                    }
                    SSHUtils.exec(session, command);
                }
            }
            catch (SSHException | IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)I18n.t((String)"Error while uploading public key to remote serveur authorized_keys", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    protected String uploadSimulationIfNecessary(FTPClient ftpClient, SimulationItem simulationItem, String simulationid, File simulationFile) throws IOException {
        String localSimulationZip;
        String remoteTemp = FTP_TEMP_PATH;
        if (!simulationItem.isStandaloneSimulationZip()) {
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            localSimulationZip = "simulation-" + shortSimulationId + "-preparation.zip";
            String remotePath = remoteTemp + (String)localSimulationZip;
            if (simulationItem.getSimulationNumber() == 0) {
                this.uploadSimulation(ftpClient, remoteTemp, remotePath, simulationFile);
            }
        } else {
            localSimulationZip = "simulation-" + simulationid + "-preparation.zip";
            String remotePath = remoteTemp + localSimulationZip;
            this.uploadSimulation(ftpClient, remoteTemp, remotePath, simulationFile);
        }
        return SSH_TEMP_PATH + localSimulationZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadSimulation(FTPClient ftpClient, String remoteDirectory, String remoteSimulationZipPath, File simulationFile) throws IOException {
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            ftpClient.makeDirectory(remoteDirectory);
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(simulationFile));){
                ftpClient.storeFile(remoteSimulationZipPath, (InputStream)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadResultsArchive(FTPClient ftpClient, SimulationControl simulationControl, String md5sum) throws IOException {
        String localMd5;
        File localFile = IsisFileUtil.createTempFile("simulation-results", ".zip");
        localFile.deleteOnExit();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Downloading results in " + localFile.getAbsolutePath()));
        }
        String simulationId = simulationControl.getId();
        String remoteFile = FTP_TEMP_PATH + this.getResultArchiveName(simulationId);
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            long size = FtpManager.getFileSize(ftpClient, remoteFile);
            ftpClient.setCopyStreamListener((CopyStreamListener)new ControlCopyStreamListener(simulationControl, size));
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
                ftpClient.retrieveFile(remoteFile, (OutputStream)out);
            }
            catch (IOException e) {
                localFile.delete();
                throw e;
            }
            finally {
                ftpClient.setCopyStreamListener(null);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)md5sum) && !(localMd5 = StringUtil.asHex((byte[])MD5InputStream.hash((InputStream)new BufferedInputStream(new FileInputStream(localFile))))).equals(md5sum)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Warning md5 checksum failed (got " + localMd5 + ", expected : " + md5sum + ")"));
            }
            localFile.delete();
            localFile = null;
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadResultsMD5File(FTPClient ftpClient, String simulationId) throws IOException {
        String remoteFile = FTP_TEMP_PATH + this.getResultArchiveName(simulationId) + ".md5";
        File localFile = IsisFileUtil.createTempFile(simulationId, ".md5");
        File resultFile = null;
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
                boolean result = ftpClient.retrieveFile(remoteFile, (OutputStream)out);
                if (result) {
                    resultFile = localFile;
                }
            }
            catch (IOException e) {
                localFile.delete();
                throw e;
            }
        }
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadSimulationInformationFile(FTPClient ftpClient, String simulationId) throws IOException {
        String remoteFile = "/scratch/isis-temp-4/simulation-" + simulationId + "information.txt";
        File localFile = IsisFileUtil.createTempFile(simulationId, ".md5");
        File resultFile = null;
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
                boolean result = ftpClient.retrieveFile(remoteFile, (OutputStream)out);
                if (result) {
                    resultFile = localFile;
                }
            }
            catch (IOException e) {
                localFile.delete();
                throw e;
            }
        }
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSimulationFiles(FTPClient ftpClient, SimulationControl control) throws IOException {
        control.setText(I18n.t((String)"isisfish.simulation.remote.message.deletingfiles", (Object[])new Object[0]));
        String simulationId = control.getId();
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            ftpClient.deleteFile("/scratch/isis-temp-4/simulation-" + simulationId + "-output.txt");
            ftpClient.deleteFile(FTP_TEMP_PATH + this.getResultArchiveName(simulationId));
            ftpClient.deleteFile("/scratch/isis-temp-4/simulation-" + simulationId + "-preparation.zip");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadSimulationScript(FTPClient ftpClient, String simulationid, String simulationScript) throws IOException {
        String remoteFileName = "simulation-" + simulationid + "-script.seq";
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(simulationScript.getBytes(StandardCharsets.UTF_8));){
                ftpClient.storeFile(FTP_TEMP_PATH + remoteFileName, (InputStream)is);
            }
        }
        return SSH_TEMP_PATH + remoteFileName;
    }

    protected String getResultArchiveName(String simulationId) {
        String remoteName = "simulation-" + simulationId + "-result.zip";
        return remoteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadPreScriptIfNecessary(FTPClient ftpClient, String simulationId, String simulationPreScript) throws IOException {
        if (StringUtils.isEmpty((CharSequence)simulationPreScript)) {
            return null;
        }
        String prescriptName = "simulation-" + simulationId + "-prescript.bsh";
        String remotePath = FTP_TEMP_PATH + prescriptName;
        FTPClient fTPClient = ftpClient;
        synchronized (fTPClient) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(simulationPreScript.getBytes(StandardCharsets.UTF_8));){
                ftpClient.storeFile(remotePath, (InputStream)is);
            }
        }
        return SSH_TEMP_PATH + prescriptName;
    }

    protected void startSimulation(Session session, FTPClient ftpClient, SimulationItem simulationItem, String simulationid, String simulationRemoteZipPath, String remoteResultZip, String simulationPreScriptPath) throws Exception {
        if (simulationItem.isStandaloneSimulation()) {
            String simulationPSBScript = this.getLaunchSimulationScriptContent(simulationid, simulationRemoteZipPath, true, remoteResultZip, simulationPreScriptPath, false);
            String scriptRemotePath = this.uploadSimulationScript(ftpClient, simulationid, simulationPSBScript);
            this.sendStartSimulationRequest(session, simulationid, scriptRemotePath, -1);
        } else if (simulationItem.isLastSimulation()) {
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last simulation start requested, send multijob start request for " + shortSimulationId));
            }
            boolean multipleSimulation = simulationItem.getSimulationNumber() > 0;
            String simulationPSBScript = this.getLaunchSimulationScriptContent(shortSimulationId, simulationRemoteZipPath, simulationItem.isStandaloneSimulationZip(), remoteResultZip, simulationPreScriptPath, multipleSimulation);
            String scriptRemotePath = this.uploadSimulationScript(ftpClient, shortSimulationId, simulationPSBScript);
            this.sendStartSimulationRequest(session, shortSimulationId, scriptRemotePath, simulationItem.getSimulationNumber());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Current simulation is not last simulation in pool, skip start");
        }
    }

    protected String getLaunchSimulationScriptContent(String simuationId, String simulationZip, boolean standaloneZip, String simulationResultZip, String preScriptPath, boolean multipleSimulationScript) throws IOException {
        String fileContent = this.getSimulationScriptLaunchContent(QSUB_SCRIPT_TEMPLATE, simuationId, simulationZip, standaloneZip, simulationResultZip, preScriptPath, multipleSimulationScript);
        return fileContent;
    }

    protected String getSimulationScriptLaunchContent(String templateName, String simuationId, String simulationZip, boolean standaloneZip, String simulationZipResult, String preScriptPath, boolean multipleSimulationScript) throws IOException {
        String scriptContent;
        String remotePreScript = preScriptPath;
        if (remotePreScript == null) {
            remotePreScript = "";
        }
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templateName);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("ISIS_INSTALL", IsisFish.config.getSimulatorSshIsisHome());
            root.put("ISIS_TEMP", SSH_TEMP_PATH);
            root.put("JAVA_BIN_PATH", IsisFish.config.getSimulatorSshJavaPath());
            root.put("JAVA_MEMORY", IsisFish.config.getSimulatorSshMaxMemory());
            root.put("SIMULATION_ID", simuationId);
            root.put("SIMULATION_ZIP", simulationZip);
            root.put("SIMULATION_STANDALONE_ZIP", standaloneZip);
            root.put("SIMULATION_RESULT_ZIP", simulationZipResult);
            root.put("SIMULATION_PRESCRIPT", remotePreScript);
            root.put("QSUB_MULTIPLE_JOB", multipleSimulationScript);
            StringWriter out = new StringWriter();
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            scriptContent = ((Object)out).toString();
        }
        catch (TemplateException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"Process template error", (Object[])new Object[0]), (Throwable)e);
            }
            throw new IOException(I18n.t((String)"Process template error", (Object[])new Object[0]), e);
        }
        return scriptContent;
    }

    protected void sendStartSimulationRequest(Session session, String simulationId, String scriptRemotePath, int lastSimulationNumber) throws SSHException {
        StringWriter output;
        int exit;
        Object command = "qsub";
        command = (String)command + " -o \"$SCRATCH/eftp/isis-temp-4/simulation-" + simulationId + "-pbs.out\"";
        command = (String)command + " -e \"$SCRATCH/eftp/isis-temp-4/simulation-" + simulationId + "-pbs.err\"";
        String qsubOptions = IsisFish.config.getSimulatorSshPbsQsubOptions();
        if (StringUtils.isNotEmpty((CharSequence)qsubOptions)) {
            command = (String)command + " " + qsubOptions;
        }
        if (lastSimulationNumber > 0) {
            command = (String)command + " -J 0-" + lastSimulationNumber;
        }
        String remoteFilenameId = "$SCRATCH/eftp/isis-temp-4/simulation-" + simulationId + "-pbs.id";
        command = (String)command + " \"" + scriptRemotePath + "\"|tee \"" + remoteFilenameId + "\"";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send qsub job starting command : " + (String)command));
        }
        if ((exit = SSHUtils.exec(session, (String)command, output = new StringWriter())) != 0) {
            throw new SSHException(I18n.t((String)"Command '%s' fail to execute", (Object[])new Object[]{command}));
        }
        String out = ((Object)output).toString();
        if (out.trim().matches("\\d+(\\[\\])?\\.\\w+") && log.isInfoEnabled()) {
            log.info((Object)("Job submitted with job id : " + out));
        }
    }

    protected void sendStopSimulationRequest(Session session, String simulationId) throws SSHException {
        String remoteFilenameId = "$SCRATCH/eftp/isis-temp-4/simulation-" + simulationId + "-pbs.id";
        String command = "qdel `cat \"" + remoteFilenameId + "\"`";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send stop request : " + command));
        }
        SSHUtils.exec(session, command);
    }
}

