/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.aspect.ComputeResultTrace;
import fr.ifremer.isisfish.simulator.SimulationContext;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.nuiton.profiling.Trace;

@Aspect
public class ComputeResultAspect {
    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        ComputeResultTrace result = context.getComputeResultTrace();
        return result;
    }

    @Before(value="execution(@fr.ifremer.isisfish.annotations.ComputeResult * scripts.*.*(..))")
    public void traceBeforeExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().enter(method);
    }

    @AfterThrowing(throwing="ex", pointcut="execution(@fr.ifremer.isisfish.annotations.ComputeResult * scripts.*.*(..))")
    public void traceAfterThrowingExecute(JoinPoint jp, Exception ex) {
        this.traceAfterExecute(jp);
    }

    @After(value="execution(@fr.ifremer.isisfish.annotations.ComputeResult * scripts.*.*(..))")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().exit(method);
    }
}

