<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<!--
  #%L
  IsisFish
  
  $Id: isis-fish-1.5_1.9.xsl 3124 2010-11-29 18:14:09Z chatellier $
  $HeadURL$
  %%
  Copyright (C) 1999 - 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 2 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-2.0.html>.
  #L%
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version et ajout de formules pr�existante -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">1.9</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>

  <!-- Add attribute price in ClassePopulation object and value it to 0 -->
  <xsl:template match="dbobject[@type='ClassePopulation']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">price</xsl:attribute>
            <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- Add attribute cost in Engin object and value it to 0 -->
  <xsl:template match="dbobject[@type='Engin']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:element name="attribute">
            <xsl:attribute name="name">cost</xsl:attribute>
            <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- remove attribute strategies in Region object -->
  <xsl:template match="attribute[(@name='strategies') and (../@type='Region')]">
  </xsl:template>

</xsl:stylesheet>
