<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<!--
  #%L
  IsisFish
  
  $Id: isis-fish-1.3.1_1.5.xsl 3124 2010-11-29 18:14:09Z chatellier $
  $HeadURL$
  %%
  Copyright (C) 1999 - 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 2 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-2.0.html>.
  #L%
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>




  <!-- les equations sont maintenant conserv� directement dans les objets -->
  <!-- Population.croissance -->
  <xsl:template match="attribute[((@name='croissance') and (../@type='Population')) or ((@name='inverseCroissance') and (../@type='Population')) or ((@name='equationReproduction') and (../@type='Population')) or ((@name='equation') and (../@type='Selectivite'))]">
    <xsl:copy>
      <xsl:apply-templates select="attribute::*"/>

      <xsl:variable name="id">
        <xsl:value-of select="text()"/>
      </xsl:variable>
      <xsl:value-of select="/descendant::attribute[(@name='equation') and (../@__id__=$id)]/text()"/>
    </xsl:copy>
  </xsl:template>



  <!-- changement de version et ajout de formules pr�existante -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">1.5</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
        <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073656709925#0.8006227935493408'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Von Bertalanffy"&gt;
# Mod�le de Von Bertalanffy
# param�tre � modifier
Linf = 0.0;
K = 0.0;
T0 = 0.0;

(Linf*(1.0-Exp((K*(age-T0)))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Von Bertalanffy</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073656824909#0.16536956353418875'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Von Bertalanffy"&gt;
# Mod�le de Von Bertalanffy
# param�tre � modifier
Linf = 0.0;
K = 0.0;
T0 = 0.0;

(T0+((1.0/K)*Ln((1.0-(longueur/Linf)))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Von Bertalanffy</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073657787384#0.2840732391087244'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Gompertz"&gt;
#Mod�le de Gompertz
# param�tres�� modifier
L0 = 0.0;
Lambda = 0.0;
K = 0.0;

(L0*Exp(((Lambda/K)*(1.0-Exp((-K*age))))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Gompertz</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073657838642#0.4157245134548563'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Gompertz"&gt;
#Mod�le de Gompertz
# param�tres�� modifier
L0 = 0.0;
Lambda = 0.0;
K = 0.0;

(-(1.0/K)*Ln((1.0-((K/Lambda)*Ln((longueur/L0))))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Gompertz</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073658043019#0.17367161278659238'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Richards"&gt;
#Mod�le de Richards
#param�tres � modifier
r = 0.0;
C0 = 0.0;
mu = 0.0;
# n &gt; 1
n = 1.1;

(((r**(1.0-n))+(C0*Exp((-mu*((n**(n/(n-1.0)))*(age/r))))))**(1.0/(1.0-n)))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Richards</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1073658188487#0.6619503031669575'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name="Mod�le de Richards"&gt;
#Mod�le de Richards
#param�tres � modifier
r = 0.0;
C0 = 0.0;
mu = 0.0;
# n &gt; 1
n = 1.1;
# age est d�fini uniquement si longueur&gt;r

-(r/((mu*(n**(n/(n-1.0))))*Ln((((1.0/C0)*(longueur**(1.0-n)))-(r**(1.0-n))))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Mod�le de Richards</attribute>
  </dbobject>
    <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074729931692#0.9570000725697745'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K!=0 Gamma!=0'&gt;#Mod�le de Schnute K!=0 Gamma!=0
# param�tres�� modifier
K = 1.0;
Gamma = 1.0;
y1 = 1.0;
y2 = 2.0;
t1 = 1.0;
t2 = 1.0;
#pour tester l'�quation
#longueur=10;

(t1-((1.0/K)*(Ln(((((Exp((-K*(t2-t1)))-1.0)**(1.0/Gamma))/((y2**Gamma)-(y1**Gamma)))*(longueur-(y1**Gamma))))**Gamma)))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K!=0 Gamma!=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074729028685#0.3259146274662742'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K!=0 Gamma!=0'&gt;#Mod�le de Schnute K!=0 Gamma!=0
# param�tres�� modifier
K = 1.0;
Gamma = 1.0;
y1 = 0.0;
y2 = 0.0;
t1 = 0.0;
t2 = 0.0;
#pour tester l'�quation
#age=3;
# erreur dans les parentheses
# (y1**Gamma+(y2**Gamma-y1**Gamma)*((1-Exp(-K*(age-t1))/(1-Exp(-K*(t2-t1))))**(1/Gamma)

1.0
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K!=0 Gamma!=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730196177#0.7489965944422079'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K!=0 Gamma=0'&gt;#Mod�le de Schnute K!=0 Gamma=0
# param�tres�� modifier
K = 1.0;
Gamma = 0.0;
y1 = 0.0;
y2 = 0.0;
t1 = 0.0;
t2 = 0.0;
#pour tester l'�quation
#age=3;
#erreur dans les parentheses
#y1*Exp(ln(y2/y1)*((1-Exp(-K*(age-t1))/(1-Exp(-K*(t2-t1)))

1.0
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K!=0 Gamma=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730310533#0.3621028946344731'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K!=0 Gamma=0'&gt;#Mod�le de Schnute K!=0 Gamma=0
# param�tres�� modifier
K = 1.0;
Gamma = 0.0;
y1 = 1.0;
y2 = 2.0;
t1 = 3.0;
t2 = 4.0;
#pour tester l'�quation
#longueur=3;

(t1-((1.0/K)*Ln((1.0-(((1.0-Exp((-K*(t2-t1))))/Ln((y2/y1)))*Ln((longueur/y1)))))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K!=0 Gamma=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730681687#0.5277536816858678'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K=0 Gamma=0'&gt;#Mod�le de Schnute K=0 Gamma=0
# param�tres�� modifier
K = 0.0;
Gamma = 0.0;
y1 = 1.0;
y2 = 2.0;
t1 = 3.0;
t2 = 4.0;
#pour tester l'�quation
#longueur = 3.0;

(t1+(((t2-t1)/Ln((y2/y1)))*Ln((longueur/y1))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K=0 Gamma=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730643195#0.8365677142633519'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K=0 Gamma=0'&gt;#Mod�le de Schnute K=0 Gamma=0
# param�tres�� modifier
K = 0.0;
Gamma = 0.0;
y1 = 1.0;
y2 = 2.0;
t1 = 3.0;
t2 = 4.0;
#pour tester l'�quation
#age = 3.0;

(y1*Exp((Ln((y2/y1))*((age-t1)/(t2-t1)))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K=0 Gamma=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730591103#0.44588422256872773'>
    <attribute name='categorie'>Croissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K=0 Gamma!=0'&gt;#Mod�le de Schnute K=0 Gamma!=0
# param�tres�� modifier
K = 0.0;
Gamma = 1.0;
y1 = 1.0;
y2 = 2.0;
t1 = 3.0;
t2 = 4.0;
#pour tester l'�quation
#age = 3.0;

(((y1**Gamma)+(((y2**Gamma)-(y1**Gamma))*((age-t1)/(t2-t1))))**(1.0/Gamma))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K=0 Gamma!=0</attribute>
  </dbobject>
  <dbobject type ='Formule' __id__='fr.ifremer.db.FormuleFactory#1074730520361#0.9952806739499448'>
    <attribute name='categorie'>InverseCroissance</attribute>
    <attribute name='equation'>&lt;equation name='Schnute K=0 Gamma!=0'&gt;#Mod�le de Schnute K=0 Gamma!=0
# param�tres�� modifier
K = 0.0;
Gamma = 1.0;
y1 = 1.0;
y2 = 2.0;
t1 = 3.0;
t2 = 4.0;
#pour tester l'�quation
#longueur = 3.0;

(t1+(((t2-t1)/((y2**Gamma)-(y1**Gamma)))*((longueur**(1.0/Gamma))-(y1**Gamma))))
&lt;/equation&gt;</attribute>
    <attribute name='nom'>Schnute K=0 Gamma!=0</attribute>
  </dbobject>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
