/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationFilterDialog.java 3393 2011-06-14 17:43:37Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator.filter;

import fr.ifremer.isisfish.simulator.SimulationProperties;
import fr.ifremer.isisfish.ui.widget.filter.FilterDialog;
import fr.ifremer.isisfish.ui.widget.filter.FilterModel;

public class SimulationFilterDialog extends SimulationFilterDialogUI implements FilterDialog<SimulationProperties, String> {

    private static final long serialVersionUID = -3855836958371282956L;

    public SimulationFilterDialog(FilterModel<SimulationProperties, String> model, String title, String okLibelle) {
        super();
        this.model = model;
        setTitle(title);
        getOk().setText(okLibelle);
        applyDataBinding("reset.enabled");
        refreshResult();
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Fonctionnement du filtre de simulation</h3>" +
                "Les crit\u00E8res de type texte (simulationName,simulatorName,...) utilise des expresions rationnelles." +
                "<br/> La liste des r\u00E9sultats se met automatiquement \u00E0 jour lors de votre saisie." +
                "<h3>Les expressions rationnelles</h3>" +
                "Une expression rationnelle est un motif de recherche sur une chaine de caract\u00E8res."+
                "" +
                "Voici quelques caract\u00E8res utilisables dans les E.R : " +
                "<ul>" +
                "<li><b>'.'</b> : un joker, qui repr\u00E9sente un caract\u00E8re unique quelconque.</li>\n" +
                "<li><b>'^'</b> et<b> '$'</b> : repr\u00E9sentent respectivement un d\u00E9but et une fin de ligne.</li>" +
                "<li><b>'*'</b> sp\u00E9cifie un nombre quelque conque du caract\u00E8re pr\u00E9c\u00E9dent</li>" +
                "<li><b>'+'</b> sp\u00E9cifie un nombre strictement positif d'occurrence sup\u00E9rieur \u00E0 0 du caract\u00E8re pr\u00E9c\u00E9dent  ( x+ = xx*)</li>" +
                "<li><b>'|'</b> sp\u00E9cifie une alternative, par exemple ^(a|b).+ repr\u00E9sente l'ensemble des mots commencant par <code>a</code> ou <code>b</code>.</li>" +
                "</ul>" +
                "<br/>" +
                " Pour plus de renseignement sur les expressions rationnelles, reportez vous au lien suivant :" +
                "<ul>" +
                "<li><a href='http://java.sun.com/javase/6/docs/api/java/util/regex/Pattern.html'>Les expression rationnelles en Java</a></li>" +
                "</ul>");
        doc.setText(sb.toString());
        doc.setCaretPosition(0);
        pack();
    }

    // ----------------- Add this code since jaxx compilator don't generate
    // some code for binding, bug ? TODO Fix me
    @SuppressWarnings({"unchecked"})
    public void applyDataBinding(String $binding) {
        if ($binding.equals("reset.enabled")) {
            if (comboResult != null) {
                $bindingSources.put("comboResult", comboResult);
                this.comboResult.addItemListener((java.awt.event.ItemListener) jaxx.runtime.JAXXUtil.getEventListener(java.awt.event.ItemListener.class, this, "$pr$u10"));
            }
            processDataBinding($binding);
        } else super.applyDataBinding($binding);
    }

    public void removeDataBinding(String $binding) {
        if ($binding.equals("reset.enabled")) {
            if (comboResult != null) {
                ((jaxx.runtime.swing.JAXXComboBox) $bindingSources.remove("comboResult")).removeItemListener((java.awt.event.ItemListener) jaxx.runtime.JAXXUtil.getEventListener(java.awt.event.ItemListener.class, this, "$pr$u10"));
            }
        } else super.removeDataBinding($binding);
    }

    @SuppressWarnings({"unchecked"})
    public void processDataBinding(String $dest, boolean $force) {
        if (!$dest.equals("reset.enabled")) {
            super.processDataBinding($dest, $force);
            return;
        }
        if (!$force && $activeBindings.contains($dest)) return;
        $activeBindings.add($dest);
        try {
            reset.setEnabled(((canReset())));
        }
        finally {
            $activeBindings.remove($dest);
        }
    }

    private java.beans.PropertyChangeListener $DataSource410 = new jaxx.runtime.DataBindingListener(this, "reset.enabled");

    @SuppressWarnings({"UnusedDeclaration"})
    public void $pr$u10(java.awt.event.ItemEvent event) {
        $DataSource410.propertyChange(null);
    }
}
