/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.SimulationUI;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SimulUI extends SimulationUI {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PARAMS_UI_REGION_STORAGE = "paramsUI.regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1UPW8TQRAdG+zE+TCBiBAgSCGJBBScCR9VECQKRDgyEMVEinDD2re2NzrvLrt7yaVB/AR+AvQ0SHRUiIKaggbxFxCioEXMnj8ul5zluPBJ++a9eTO7M+9/QUYruLxDgsBRPjesRZ31le3tp9UdWjMPqK4pJo1Q0P6l0pCuwKjbO9cG5islSy906IVV0ZKCU36AvVSCEW32PaqblBoDl+KMmtaFcg9eCqSvuqo9U0mqb//8Tr9xX79LAwQS3eWxlNlBrKiSkyVIM9fAGcy0Swoe4Q20oRhvoN9xe7bqEa2fkBZ9Ca9gqARZSRSKGZg7fsmhRsgPpIH8Qpm1fI8YJvhW8YaBq3XlsLqiLYpfzXSd6abjM0e3w4RyQsJWUcpQJYsaVeHuPyPVKnU3CKcGzlmvgaP30LqzHiERZRiNk5beKhq4NjDhRifWcsd6EqNS0XJYnFW5PlilG35EKaspD61cGVx7GBmnD9NACmWOV8vDTmxcIq+o9j2z2hSsRq1QYaDQZowRl5sg7i7hNdv0bpcXBwquHOLEJXMLeI1FXhf4RC7EnnT7ljuoPEpYtAfzCcDNfsCtfsDtfsCdLqDgYswcTrITTXI0aqkKZJSPxwamK0eHfxOh9thPHxp7Kxii/6Ymv3/6+XGtO+spzH02MfTAqsIZlEpIqgyzqU+1B903zCs8JnKpAjlNPdxz4R6bSTBW7sBoDvOdtnTH0p1HRDdRIjP04/OXqRffTkB6DUY8Qdw1YuOLkDNNfGRN4bmBvL8cOhrbG8b/CevNwLiiDdwBZQwmDWxV/q5LDJmtMu7i/d4LsBczCb3oGarmvv6dLH9YPtiP833Do55knkOWcY9xGm6/zmJL3HajUlPfFdECS1ppKfudkFL+BzqcxDJLBgAA";
    private static final Log log = LogFactory.getLog(SimulUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdvancedParamsUI advancedParamsUI;
    protected ExportUI exportUI;
    protected ParamsUI paramsUI;
    protected PreScriptsUI preScriptUI;
    protected ResultChoiceUI resultChoiceUI;
    protected SensUI sensUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimulUI $SimulationUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
        public void refresh() {
            paramsUI.refresh();
            preScriptUI.refresh();
            sensUI.refresh();
            exportUI.refresh();
            resultChoiceUI.refresh();
            advancedParamsUI.refresh();
        }
       
        /**
         * Refresh all simulation launch UI.
         */
        @Override
        protected void regionStorageChanged() {
        
        }
        
        @Override
        public void selectParametersTab() {
            bodyTabbedPane.setSelectedIndex(0);
        }
    
        @Override
        public void setEnabledPrescriptTab(boolean selected) {
            bodyTabbedPane.setEnabledAt(1, selected);
            if (selected) {
                bodyTabbedPane.setSelectedIndex(1);
            }
        }
        
        @Override
        public void setEnabledSimulationPlanTab(boolean selected) {
            bodyTabbedPane.setEnabledAt(2, selected);
            if (selected) {
                bodyTabbedPane.setSelectedIndex(2);
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimulUI() {
        $initialize();
    }

    public SimulUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public ExportUI getExportUI() {
        return exportUI;
    }

    public ParamsUI getParamsUI() {
        return paramsUI;
    }

    public PreScriptsUI getPreScriptUI() {
        return preScriptUI;
    }

    public ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public SensUI getSensUI() {
        return sensUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBodyTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        bodyTabbedPane.add(paramsUI);
        bodyTabbedPane.add(preScriptUI);
        bodyTabbedPane.add(sensUI);
        bodyTabbedPane.add(exportUI);
        bodyTabbedPane.add(resultChoiceUI);
        bodyTabbedPane.add(advancedParamsUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 0));
        bodyTabbedPane.setTitleAt(0, _("isisfish.params.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 1));
        bodyTabbedPane.setTitleAt(1, _("isisfish.preScript.title"));
        bodyTabbedPane.setEnabledAt(1, false);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 2));
        bodyTabbedPane.setTitleAt(2, _("isisfish.sens.title"));
        bodyTabbedPane.setEnabledAt(2, false);
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 3));
        bodyTabbedPane.setTitleAt(3, _("isisfish.export.title"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 4));
        bodyTabbedPane.setTitleAt(4, _("isisfish.resultChoice.title"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 5));
        bodyTabbedPane.setTitleAt(5, _("isisfish.advancedParameters.title"));
    }

    protected void createAdvancedParamsUI() {
        $objectMap.put("advancedParamsUI", advancedParamsUI = new AdvancedParamsUI(this));
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    @Override
    protected void createBodyTabbedPane() {
        super.createBodyTabbedPane();
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createExportUI() {
        $objectMap.put("exportUI", exportUI = new ExportUI(this));
        
        exportUI.setName("exportUI");
    }

    protected void createParamsUI() {
        $objectMap.put("paramsUI", paramsUI = new ParamsUI(this));
        
        paramsUI.setName("paramsUI");
    }

    protected void createPreScriptUI() {
        $objectMap.put("preScriptUI", preScriptUI = new PreScriptsUI(this));
        
        preScriptUI.setName("preScriptUI");
    }

    protected void createResultChoiceUI() {
        $objectMap.put("resultChoiceUI", resultChoiceUI = new ResultChoiceUI(this));
        
        resultChoiceUI.setName("resultChoiceUI");
    }

    protected void createSensUI() {
        $objectMap.put("sensUI", sensUI = new SensUI(this));
        
        sensUI.setName("sensUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBodyTabbedPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$SimulationUI0", $SimulationUI0);
        createParamsUI();
        createPreScriptUI();
        createSensUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.params.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setEnabled(false);
        $TabInfo1.setTitle(_("isisfish.preScript.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setEnabled(false);
        $TabInfo2.setTitle(_("isisfish.sens.title"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("isisfish.export.title"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("isisfish.resultChoice.title"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("isisfish.advancedParameters.title"));
        // inline creation of $SimulationUI0
        setName("$SimulationUI0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PARAMS_UI_REGION_STORAGE, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                paramsUI.setRegionStorage(getRegionStorage());
            }
        });
    }

}