/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.models.common.StringListModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ExportUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdO3GM8wEhVkKAgJLghuZMnygEAhaxHEAxSFHcsPat443Wt8vuHDkaxE/gJ0BPg0RHhSioKWgQfwEhClrE7J0/YjhEXNxaO/PevHkz+/ob5KyBlUMWRZ4JAxRd7lVv7O3dax7yFt7itmWERmUg+WWykG3AlD+4twhXGjUHL/fg5S3V1SrgwTH0Wg0mLT6V3HY4R4RLo4iWteX6ILwW6dD0WQei0lhf/viefeE/f5UFiDSpG6dWlv+HGnYyXoOs8BHmqNITVpYsOCAZRgQHpHfG3W1JZu1d1uWP4RnkazChmSEyhNWTtxxzxPhII+RLD1hT8msIV9vGE23Du5xOK2xb2I4XCs+KbigZMXi3I60MPtzWOsZPIMyUqvWWUVLeZ4HjOOdERp49Is3esZBLLwxQ81JYrDvahHGro5TlCGdH0DVKcoDpAa5Qqt4MEVVAlYojucl1r4qBiyOe0zS94TSHdmcakDMhXSMsNv5egF0KJaNf/GP0jjCO/loofn739W2lP+8xqj2fmnpsXWkO2ijNDQpX+kwy7BCFLO8wvdaAguWSdj3e5aUUYfVemMRRvdg0z8G9O8x2iCKX//L+w8KjT2OQrcCkVMyvMJe/DQXsGHJBST/S1zdjRdNHp+g767QhTLe4lLs88LkheXB63WfIlpsi8MnljYisWEqxYqCnWfj4s1h/s9m3I0Pyzv8zfWhJbh8mRCBFwOMH0Nvt1IWf0paHvhrucNpWZ9w5q3treiH+Xk7rdyZxWqhgR/lxiZUodMdqrN79K52YbBx5RC9xbj1pZZkhPd1miHwjnbNInL8B1tgRhu8EAAA=";
    private static final Log log = LogFactory.getLog(ExportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JList listSimulExportChoose;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ExportUI $Table0 = this;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            refresh();
        }
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
        
        public void refresh() {
    
            // FIXME listen for export modification here
    
            // fill export
            setListSimulExportChooseModel();
        }
    
        protected void setListSimulExportChooseModel() {
            java.util.List<String> availableExports = getSimulAction().getExportNames();
            java.util.List<String> userExports = getSimulAction().getSimulationParameter().getExportNames();
            // userExports = intersection(userExports,availableExports)
            userExports.retainAll(availableExports);
    
            StringListModel exportModel = new StringListModel(availableExports);
            listSimulExportChoose.setModel(exportModel);
            
            for (String userExport : userExports) {
                int index = availableExports.indexOf(userExport);
                listSimulExportChoose.addSelectionInterval(index, index);
            }
        }
    
        protected void saveSimulationExports(ListSelectionEvent event) {
            // Set exports (this can save empty list (not a big deal))
            Object[] values = listSimulExportChoose.getSelectedValues();
            java.util.List<String> exportNames = new LinkedList<String>();
            for (Object o : values) {
                exportNames.add((String) o);
            }
            getSimulAction().getSimulationParameter().setExportNames(exportNames);
            
            if (log.isDebugEnabled()) {
                log.debug("Set exports in simulation : " + exportNames);
            }
        }
        
        protected void saveConfigExports() {
            // Set exports (this can save empty list (not a big deal))
            Object[] values = listSimulExportChoose.getSelectedValues();
            java.util.List<String> exportNames = new LinkedList<String>();
            for (Object o : values) {
                exportNames.add((String) o);
            }
            getSimulAction().getSimulationParameter().setExportNames(exportNames);
            
            getSimulAction().saveExport();
            setInfoText(_("isisfish.export.saved"));
        }
        
        protected void setInfoText(String txt) {
            // TODO remove getParentContainer use
            WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
            root.setStatusMessage(txt);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ExportUI() {
        $initialize();
    }

    public ExportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveConfigExports();
    }

    public void doValueChanged__on__listSimulExportChoose(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveSimulationExports(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getListSimulExportChoose() {
        return listSimulExportChoose;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createListSimulExportChoose() {
        $objectMap.put("listSimulExportChoose", listSimulExportChoose = new JList());
        
        listSimulExportChoose.setName("listSimulExportChoose");
        listSimulExportChoose.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listSimulExportChoose"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listSimulExportChoose);
        
        // apply 2 property setters
        listSimulExportChoose.setCellRenderer(new fr.ifremer.isisfish.ui.models.export.ExportNameListRenderer());
        listSimulExportChoose.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListSimulExportChoose();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.common.saveNextSimulation"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}