/*
 * #%L
 * IsisFish
 * 
 * $Id: FactorTreeModel.java 3194 2011-03-22 14:57:49Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.sensitivity.model;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;

/**
 * Cette classe gere l'affichage d'une liste de facteurs dans l'arbre.
 * 
 * @author chatellier
 * @version $Revision: 3194 $
 * 
 * Last update : $Date: 2008-06-13 11:05:57 +0200 (ven., 13 juin 2008)
 * $ By : $Author: chatellier $
 */
public class FactorTreeModel implements TreeModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 593284613450915826L;

    /** Tree model root. */
    protected Factor rootFactor;
    
    /** Tree model listeners. */
    protected Collection<TreeModelListener> modelListeners;

    /**
     * Constructor.
     * 
     * @param rootFactor root factor (typically, a {@link FactorGroup})
     */
    public FactorTreeModel(Factor rootFactor) {
        this.rootFactor = rootFactor;
        modelListeners = new ArrayList<TreeModelListener>();
    }

    /*
     * @see javax.swing.tree.TreeModel#getChild(java.lang.Object, int)
     */
    @Override
    public Object getChild(Object parent, int index) {

        Object value = null;

        if (parent instanceof FactorGroup) {
            FactorGroup factorGroup = (FactorGroup)parent;
            value = factorGroup.get(index);
        }

        return value;
    }

    /*
     * @see javax.swing.tree.TreeModel#getChildCount(java.lang.Object)
     */
    @Override
    public int getChildCount(Object parent) {

        int childCount = 0;

        if (parent instanceof FactorGroup) {
            FactorGroup factorGroup = (FactorGroup)parent;
            childCount = factorGroup.size();
        }

        return childCount;
    }

    /*
     * @see javax.swing.tree.TreeModel#getIndexOfChild(java.lang.Object, java.lang.Object)
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {

        int childIndex = -1;

        if (parent instanceof FactorGroup) {
            FactorGroup factorGroup = (FactorGroup)parent;
            childIndex = factorGroup.indexOf(child);
        }

        return childIndex;
    }

    /*
     * @see javax.swing.tree.DefaultTreeModel#isLeaf(java.lang.Object)
     */
    @Override
    public boolean isLeaf(Object node) {
        return getChildCount(node) == 0;
    }

    /*
     * @see javax.swing.tree.TreeModel#addTreeModelListener(javax.swing.event.TreeModelListener)
     */
    @Override
    public void addTreeModelListener(TreeModelListener l) {
        modelListeners.add(l);
    }

    /*
     * @see javax.swing.tree.TreeModel#getRoot()
     */
    @Override
    public Object getRoot() {
        return rootFactor;
    }

    /*
     * @see javax.swing.tree.TreeModel#removeTreeModelListener(javax.swing.event.TreeModelListener)
     */
    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        modelListeners.remove(l);
    }

    /*
     * @see javax.swing.tree.TreeModel#valueForPathChanged(javax.swing.tree.TreePath, java.lang.Object)
     */
    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new IsisFishRuntimeException("Not implemented");
    }

}
