/*
 * #%L
 * IsisFish
 * 
 * $Id: BackupAction.java 3393 2011-06-14 17:43:37Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2005 - 2010 Ifremer, Code Lutin, Cedric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.ui.util.IsisAction;

/**
 * Make a backup directory containing a set a specific files.
 *
 * @author bpoussin
 * @version $Revision: 3393 $
 * 
 * Last update : $Date: 2011-06-14 19:43:37 +0200 (Tue, 14 Jun 2011) $
 * By : $Author: chatellier $
 * 
 * @deprecated C'est pas evident de faire des Actions swing avec jaxx
 */
public class BackupAction extends IsisAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7574218899996427656L;

    /** log. */
    private static Log log = LogFactory.getLog(BackupAction.class);

    /** Source root directory. */
    protected File src;

    /** Backup root directory. */
    protected File dst;

    /** List of relative path of files to backup. */
    protected List<String> paths;

    /**
     * Constructor.
     * 
     * @param src source root directory
     * @param dst backup root directory
     * @param paths list of relative path of files to backup
     */
    public BackupAction(File src, File dst, List<String> paths) {
        super();
        this.src = src;
        this.dst = dst;
        this.paths = paths;
    }

    @Override
    protected boolean prepare() {
        return src != null && dst != null && paths != null && src.exists()
                && !paths.isEmpty();
    }

    @Override
    protected void perform(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Backup directory is : " + dst);
        }
        String suffix = "_"
                + IsisFish.config.getBackupSessionDirectory().getName();
        try {
            for (String path : paths) {
                backup(new File(src, path), path, suffix);
            }
        } catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't backup scripts", ex);
        }
    }

    /**
     * Copy a single file to destination directory.
     * 
     * @param src file to copy
     * @param path path of file to copy
     * @param suffix file suffix
     * @throws IOException if copy fail
     */
    protected void backup(File src, String path, String suffix)
            throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            File dst = new File(this.dst, path);
            dst.mkdirs();
        } else {
            int extension = path.lastIndexOf(".");
            if (extension != -1) {
                path = path.substring(0, extension) + suffix + "."
                        + path.substring(extension + 1);
            } else {
                path += suffix;
            }
            File dst = new File(this.dst, path);
            if (!dst.getParentFile().exists()) {
                dst.getParentFile().mkdirs();
            }
            if (log.isInfoEnabled()) {
                log.info("Copying " + src.getName() + " to " + dst);
            }
            FileUtil.copy(src, dst);
        }
    }

}
