/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.script;

import fr.ifremer.isisfish.ui.script.model.ScriptTree;
import fr.ifremer.isisfish.ui.script.model.ScriptTreeModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.editor.Editor;
import static org.nuiton.i18n.I18n._;

public class ScriptUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILE_SELECTED = "fileSelected";
    public static final String PROPERTY_JAVA_FILE_SELECTED = "javaFileSelected";
    public static final String PROPERTY_SCRIPT_ACTION = "scriptAction";
    public static final String PROPERTY_SINGLE_FILE_SELECTED = "singleFileSelected";
    public static final String PROPERTY_TEXT_SELECTED = "textSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_SCRIPT_CHECK_ENABLED = "buttonScriptCheck.enabled";
    public static final String BINDING_BUTTON_SCRIPT_COMMIT_ENABLED = "buttonScriptCommit.enabled";
    public static final String BINDING_BUTTON_SCRIPT_COPY_ENABLED = "buttonScriptCopy.enabled";
    public static final String BINDING_BUTTON_SCRIPT_CUT_ENABLED = "buttonScriptCut.enabled";
    public static final String BINDING_BUTTON_SCRIPT_EVAL_ENABLED = "buttonScriptEval.enabled";
    public static final String BINDING_BUTTON_SCRIPT_PASTE_ENABLED = "buttonScriptPaste.enabled";
    public static final String BINDING_BUTTON_SCRIPT_SAVE_ENABLED = "buttonScriptSave.enabled";
    public static final String BINDING_MI_CHECK_SYNTAX_ENABLED = "miCheckSyntax.enabled";
    public static final String BINDING_MI_COMMIT_VCS_ENABLED = "miCommitVCS.enabled";
    public static final String BINDING_MI_COPY_ENABLED = "miCopy.enabled";
    public static final String BINDING_MI_CUT_ENABLED = "miCut.enabled";
    public static final String BINDING_MI_DELETE_ENABLED = "miDelete.enabled";
    public static final String BINDING_MI_DIFF_VCS_ENABLED = "miDiffVCS.enabled";
    public static final String BINDING_MI_EVALUATE_ENABLED = "miEvaluate.enabled";
    public static final String BINDING_MI_EXPORT_ENABLED = "miExport.enabled";
    public static final String BINDING_MI_PASTE_ENABLED = "miPaste.enabled";
    public static final String BINDING_MI_SAVE_ENABLED = "miSave.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ScriptUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea actionLogArea;
    protected JPanel buttonBar;
    protected JButton buttonScriptCheck;
    protected JButton buttonScriptCommit;
    protected JButton buttonScriptCopy;
    protected JButton buttonScriptCut;
    protected JButton buttonScriptEval;
    protected JButton buttonScriptExport;
    protected JButton buttonScriptNew;
    protected JButton buttonScriptPaste;
    protected JButton buttonScriptSave;
    protected Editor editor;
    protected Boolean fileSelected;
    protected Boolean javaFileSelected;
    protected JMenuItem miCheckAllSyntax;
    protected JMenuItem miCheckSyntax;
    protected JMenuItem miCommitVCS;
    protected JMenuItem miCopy;
    protected JMenuItem miCut;
    protected JMenuItem miDelete;
    protected JMenuItem miDeleteVCS;
    protected JMenuItem miDiffVCS;
    protected JMenuItem miEvaluate;
    protected JMenuItem miExport;
    protected JMenuItem miGenerateJavadoc;
    protected JMenuItem miImport;
    protected JMenuItem miNewEquationModel;
    protected JMenuItem miNewExport;
    protected JMenuItem miNewRule;
    protected JMenuItem miNewSImulationPlan;
    protected JMenuItem miNewScript;
    protected JMenuItem miNewSensitivity;
    protected JMenuItem miNewSensitivityExport;
    protected JMenuItem miNewSimulator;
    protected JMenuItem miPaste;
    protected JMenuItem miSave;
    protected JMenuItem miShowJavadoc;
    protected JMenuItem miUpdateVCS;
    protected ScriptAction scriptAction;
    protected JMenuBar scriptMenuBar;
    protected JMenu scriptNewMenu;
    protected ScriptTree scriptTree;
    protected ScriptTreeModel scriptTreeModel;
    protected JMenu scriptTxtCode;
    protected JMenu scriptTxtEdit;
    protected JMenu scriptTxtFile;
    protected JMenu scriptTxtVCS;
    protected JComboBox scriptTypeChoice;
    protected Boolean singleFileSelected;
    protected Boolean textSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ScriptUI $JPanel0 = this;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private JSeparator $JSeparator3;
    private JPanel $JPanel1;
    private JSplitPane $JSplitPane0;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane1;
    private JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
                getScriptAction().postInit();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ScriptUI() {
        $initialize();
    }

    public ScriptUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ScriptUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ScriptUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonScriptCheck(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().checkScript();
    }

    public void doActionPerformed__on__buttonScriptCommit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().commitScript();
    }

    public void doActionPerformed__on__buttonScriptCopy(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().copy();
    }

    public void doActionPerformed__on__buttonScriptCut(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().cut();
    }

    public void doActionPerformed__on__buttonScriptEval(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().evaluateScript();
    }

    public void doActionPerformed__on__buttonScriptExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().exportScript();
    }

    public void doActionPerformed__on__buttonScriptNew(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript();
    }

    public void doActionPerformed__on__buttonScriptPaste(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().paste();
    }

    public void doActionPerformed__on__buttonScriptSave(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().saveScript();
    }

    public void doActionPerformed__on__miCheckAllSyntax(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        new SwingWorker<Void, Void>(){public Void doInBackground(){getScriptAction().checkAllScripts();return null;}}.execute();
    }

    public void doActionPerformed__on__miCheckSyntax(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().checkScript();
    }

    public void doActionPerformed__on__miCommitVCS(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().commitScript();
    }

    public void doActionPerformed__on__miCopy(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().copy();
    }

    public void doActionPerformed__on__miCut(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().cut();
    }

    public void doActionPerformed__on__miDelete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().deleteScript(false);
    }

    public void doActionPerformed__on__miDeleteVCS(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().deleteScript(true);
    }

    public void doActionPerformed__on__miDiffVCS(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().diffScript();
    }

    public void doActionPerformed__on__miEvaluate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().evaluateScript();
    }

    public void doActionPerformed__on__miExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().exportScript();
    }

    public void doActionPerformed__on__miGenerateJavadoc(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().generateScriptJavadoc();
    }

    public void doActionPerformed__on__miImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().importScript();
    }

    public void doActionPerformed__on__miNewEquationModel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Formule);
    }

    public void doActionPerformed__on__miNewExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Export);
    }

    public void doActionPerformed__on__miNewRule(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Rule);
    }

    public void doActionPerformed__on__miNewSImulationPlan(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.SimulationPlan);
    }

    public void doActionPerformed__on__miNewScript(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Script);
    }

    public void doActionPerformed__on__miNewSensitivity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Sensitivity);
    }

    public void doActionPerformed__on__miNewSensitivityExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.SensitivityExport);
    }

    public void doActionPerformed__on__miNewSimulator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().newScript(ScriptAction.ScriptMapping.Simulator);
    }

    public void doActionPerformed__on__miPaste(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().paste();
    }

    public void doActionPerformed__on__miSave(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().saveScript();
    }

    public void doActionPerformed__on__miShowJavadoc(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().showScriptJavadoc();
    }

    public void doActionPerformed__on__miUpdateVCS(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getScriptAction().updateScript();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getActionLogArea() {
        return actionLogArea;
    }

    public JPanel getButtonBar() {
        return buttonBar;
    }

    public JButton getButtonScriptCheck() {
        return buttonScriptCheck;
    }

    public JButton getButtonScriptCommit() {
        return buttonScriptCommit;
    }

    public JButton getButtonScriptCopy() {
        return buttonScriptCopy;
    }

    public JButton getButtonScriptCut() {
        return buttonScriptCut;
    }

    public JButton getButtonScriptEval() {
        return buttonScriptEval;
    }

    public JButton getButtonScriptExport() {
        return buttonScriptExport;
    }

    public JButton getButtonScriptNew() {
        return buttonScriptNew;
    }

    public JButton getButtonScriptPaste() {
        return buttonScriptPaste;
    }

    public JButton getButtonScriptSave() {
        return buttonScriptSave;
    }

    public Editor getEditor() {
        return editor;
    }

    public Boolean getFileSelected() {
        return fileSelected;
    }

    public Boolean getJavaFileSelected() {
        return javaFileSelected;
    }

    public JMenuItem getMiCheckAllSyntax() {
        return miCheckAllSyntax;
    }

    public JMenuItem getMiCheckSyntax() {
        return miCheckSyntax;
    }

    public JMenuItem getMiCommitVCS() {
        return miCommitVCS;
    }

    public JMenuItem getMiCopy() {
        return miCopy;
    }

    public JMenuItem getMiCut() {
        return miCut;
    }

    public JMenuItem getMiDelete() {
        return miDelete;
    }

    public JMenuItem getMiDeleteVCS() {
        return miDeleteVCS;
    }

    public JMenuItem getMiDiffVCS() {
        return miDiffVCS;
    }

    public JMenuItem getMiEvaluate() {
        return miEvaluate;
    }

    public JMenuItem getMiExport() {
        return miExport;
    }

    public JMenuItem getMiGenerateJavadoc() {
        return miGenerateJavadoc;
    }

    public JMenuItem getMiImport() {
        return miImport;
    }

    public JMenuItem getMiNewEquationModel() {
        return miNewEquationModel;
    }

    public JMenuItem getMiNewExport() {
        return miNewExport;
    }

    public JMenuItem getMiNewRule() {
        return miNewRule;
    }

    public JMenuItem getMiNewSImulationPlan() {
        return miNewSImulationPlan;
    }

    public JMenuItem getMiNewScript() {
        return miNewScript;
    }

    public JMenuItem getMiNewSensitivity() {
        return miNewSensitivity;
    }

    public JMenuItem getMiNewSensitivityExport() {
        return miNewSensitivityExport;
    }

    public JMenuItem getMiNewSimulator() {
        return miNewSimulator;
    }

    public JMenuItem getMiPaste() {
        return miPaste;
    }

    public JMenuItem getMiSave() {
        return miSave;
    }

    public JMenuItem getMiShowJavadoc() {
        return miShowJavadoc;
    }

    public JMenuItem getMiUpdateVCS() {
        return miUpdateVCS;
    }

    public ScriptAction getScriptAction() {
        return scriptAction;
    }

    public JMenuBar getScriptMenuBar() {
        return scriptMenuBar;
    }

    public JMenu getScriptNewMenu() {
        return scriptNewMenu;
    }

    public ScriptTree getScriptTree() {
        return scriptTree;
    }

    public ScriptTreeModel getScriptTreeModel() {
        return scriptTreeModel;
    }

    public JMenu getScriptTxtCode() {
        return scriptTxtCode;
    }

    public JMenu getScriptTxtEdit() {
        return scriptTxtEdit;
    }

    public JMenu getScriptTxtFile() {
        return scriptTxtFile;
    }

    public JMenu getScriptTxtVCS() {
        return scriptTxtVCS;
    }

    public JComboBox getScriptTypeChoice() {
        return scriptTypeChoice;
    }

    public Boolean getSingleFileSelected() {
        return singleFileSelected;
    }

    public Boolean getTextSelected() {
        return textSelected;
    }

    public Boolean isFileSelected() {
        return fileSelected !=null && fileSelected;
    }

    public Boolean isJavaFileSelected() {
        return javaFileSelected !=null && javaFileSelected;
    }

    public Boolean isSingleFileSelected() {
        return singleFileSelected !=null && singleFileSelected;
    }

    public Boolean isTextSelected() {
        return textSelected !=null && textSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFileSelected(Boolean fileSelected) {
        Boolean oldValue = this.fileSelected;
        this.fileSelected = fileSelected;
        firePropertyChange(PROPERTY_FILE_SELECTED, oldValue, fileSelected);
    }

    public void setJavaFileSelected(Boolean javaFileSelected) {
        Boolean oldValue = this.javaFileSelected;
        this.javaFileSelected = javaFileSelected;
        firePropertyChange(PROPERTY_JAVA_FILE_SELECTED, oldValue, javaFileSelected);
    }

    public void setScriptAction(ScriptAction scriptAction) {
        ScriptAction oldValue = this.scriptAction;
        this.scriptAction = scriptAction;
        firePropertyChange(PROPERTY_SCRIPT_ACTION, oldValue, scriptAction);
    }

    public void setSingleFileSelected(Boolean singleFileSelected) {
        Boolean oldValue = this.singleFileSelected;
        this.singleFileSelected = singleFileSelected;
        firePropertyChange(PROPERTY_SINGLE_FILE_SELECTED, oldValue, singleFileSelected);
    }

    public void setTextSelected(Boolean textSelected) {
        Boolean oldValue = this.textSelected;
        this.textSelected = textSelected;
        firePropertyChange(PROPERTY_TEXT_SELECTED, oldValue, textSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected JSeparator get$JSeparator3() {
        return $JSeparator3;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToButtonBar() {
        if (!allComponentsCreated) {
            return;
        }
        buttonBar.add(scriptTypeChoice);
        buttonBar.add(buttonScriptNew);
        buttonBar.add(buttonScriptSave);
        buttonBar.add(buttonScriptExport);
        buttonBar.add(buttonScriptCommit);
        buttonBar.add(buttonScriptCut);
        buttonBar.add(buttonScriptCopy);
        buttonBar.add(buttonScriptPaste);
        buttonBar.add(buttonScriptCheck);
        buttonBar.add(buttonScriptEval);
    }

    protected void addChildrenToScriptMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        scriptMenuBar.add(scriptTxtFile);
        scriptMenuBar.add(scriptTxtEdit);
        scriptMenuBar.add(scriptTxtVCS);
        scriptMenuBar.add(scriptTxtCode);
    }

    protected void addChildrenToScriptNewMenu() {
        if (!allComponentsCreated) {
            return;
        }
        scriptNewMenu.add(miNewScript);
        scriptNewMenu.add(miNewSimulator);
        scriptNewMenu.add(miNewExport);
        scriptNewMenu.add(miNewRule);
        scriptNewMenu.add(miNewSImulationPlan);
        scriptNewMenu.add(miNewSensitivity);
        scriptNewMenu.add(miNewSensitivityExport);
        scriptNewMenu.add(miNewEquationModel);
    }

    protected void addChildrenToScriptTxtCode() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtCode.add(miCheckSyntax);
        scriptTxtCode.add(miCheckAllSyntax);
        scriptTxtCode.add(miEvaluate);
        scriptTxtCode.add($JSeparator3);
        scriptTxtCode.add(miGenerateJavadoc);
        scriptTxtCode.add(miShowJavadoc);
    }

    protected void addChildrenToScriptTxtEdit() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtEdit.add(miCut);
        scriptTxtEdit.add(miCopy);
        scriptTxtEdit.add(miPaste);
    }

    protected void addChildrenToScriptTxtFile() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtFile.add(scriptNewMenu);
        scriptTxtFile.add(miSave);
        scriptTxtFile.add($JSeparator0);
        scriptTxtFile.add(miImport);
        scriptTxtFile.add(miExport);
        scriptTxtFile.add($JSeparator1);
        scriptTxtFile.add(miDelete);
    }

    protected void addChildrenToScriptTxtVCS() {
        if (!allComponentsCreated) {
            return;
        }
        scriptTxtVCS.add(miCommitVCS);
        scriptTxtVCS.add(miDiffVCS);
        scriptTxtVCS.add(miUpdateVCS);
        scriptTxtVCS.add($JSeparator2);
        scriptTxtVCS.add(miDeleteVCS);
    }

    protected void createActionLogArea() {
        $objectMap.put("actionLogArea", actionLogArea = new JTextArea());
        
        actionLogArea.setName("actionLogArea");
        actionLogArea.setColumns(15);
        actionLogArea.setLineWrap(true);
        actionLogArea.setWrapStyleWord(true);
        actionLogArea.setEditable(false);
    }

    protected void createButtonBar() {
        $objectMap.put("buttonBar", buttonBar = new JPanel());
        
        buttonBar.setName("buttonBar");
        buttonBar.setLayout(new GridLayout());
    }

    protected void createButtonScriptCheck() {
        $objectMap.put("buttonScriptCheck", buttonScriptCheck = new JButton());
        
        buttonScriptCheck.setName("buttonScriptCheck");
        buttonScriptCheck.setText(_("isisfish.script.check"));
        buttonScriptCheck.setToolTipText(_("isisfish.script.check.tooltip"));
        buttonScriptCheck.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptCheck"));
    }

    protected void createButtonScriptCommit() {
        $objectMap.put("buttonScriptCommit", buttonScriptCommit = new JButton());
        
        buttonScriptCommit.setName("buttonScriptCommit");
        buttonScriptCommit.setText(_("isisfish.script.commit"));
        buttonScriptCommit.setToolTipText(_("isisfish.script.commit.tooltip"));
        buttonScriptCommit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptCommit"));
    }

    protected void createButtonScriptCopy() {
        $objectMap.put("buttonScriptCopy", buttonScriptCopy = new JButton());
        
        buttonScriptCopy.setName("buttonScriptCopy");
        buttonScriptCopy.setText(_("isisfish.script.copy"));
        buttonScriptCopy.setToolTipText(_("isisfish.script.copy.tooltip"));
        buttonScriptCopy.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptCopy"));
    }

    protected void createButtonScriptCut() {
        $objectMap.put("buttonScriptCut", buttonScriptCut = new JButton());
        
        buttonScriptCut.setName("buttonScriptCut");
        buttonScriptCut.setText(_("isisfish.script.cut"));
        buttonScriptCut.setToolTipText(_("isisfish.script.cut.tooltip"));
        buttonScriptCut.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptCut"));
    }

    protected void createButtonScriptEval() {
        $objectMap.put("buttonScriptEval", buttonScriptEval = new JButton());
        
        buttonScriptEval.setName("buttonScriptEval");
        buttonScriptEval.setText(_("isisfish.script.evaluate"));
        buttonScriptEval.setToolTipText(_("isisfish.script.evaluate.tooltip"));
        buttonScriptEval.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptEval"));
    }

    protected void createButtonScriptExport() {
        $objectMap.put("buttonScriptExport", buttonScriptExport = new JButton());
        
        buttonScriptExport.setName("buttonScriptExport");
        buttonScriptExport.setEnabled(false);
        buttonScriptExport.setText(_("isisfish.script.export"));
        buttonScriptExport.setToolTipText(_("isisfish.script.export.tooltip"));
        buttonScriptExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptExport"));
    }

    protected void createButtonScriptNew() {
        $objectMap.put("buttonScriptNew", buttonScriptNew = new JButton());
        
        buttonScriptNew.setName("buttonScriptNew");
        buttonScriptNew.setText(_("isisfish.script.new"));
        buttonScriptNew.setToolTipText(_("isisfish.script.new.tooltip"));
        buttonScriptNew.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptNew"));
    }

    protected void createButtonScriptPaste() {
        $objectMap.put("buttonScriptPaste", buttonScriptPaste = new JButton());
        
        buttonScriptPaste.setName("buttonScriptPaste");
        buttonScriptPaste.setText(_("isisfish.script.paste"));
        buttonScriptPaste.setToolTipText(_("isisfish.script.paste.tooltip"));
        buttonScriptPaste.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptPaste"));
    }

    protected void createButtonScriptSave() {
        $objectMap.put("buttonScriptSave", buttonScriptSave = new JButton());
        
        buttonScriptSave.setName("buttonScriptSave");
        buttonScriptSave.setText(_("isisfish.script.save"));
        buttonScriptSave.setToolTipText(_("isisfish.script.save.tooltip"));
        buttonScriptSave.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonScriptSave"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new Editor());
        
        editor.setName("editor");
    }

    protected void createFileSelected() {
        $objectMap.put("fileSelected", fileSelected = false);
    }

    protected void createJavaFileSelected() {
        $objectMap.put("javaFileSelected", javaFileSelected = false);
    }

    protected void createMiCheckAllSyntax() {
        $objectMap.put("miCheckAllSyntax", miCheckAllSyntax = new JMenuItem());
        
        miCheckAllSyntax.setName("miCheckAllSyntax");
        miCheckAllSyntax.setText(_("isisfish.script.menu.checkAllSyntax"));
        miCheckAllSyntax.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miCheckAllSyntax"));
    }

    protected void createMiCheckSyntax() {
        $objectMap.put("miCheckSyntax", miCheckSyntax = new JMenuItem());
        
        miCheckSyntax.setName("miCheckSyntax");
        miCheckSyntax.setText(_("isisfish.script.menu.checkSyntax"));
        miCheckSyntax.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miCheckSyntax"));
    }

    protected void createMiCommitVCS() {
        $objectMap.put("miCommitVCS", miCommitVCS = new JMenuItem());
        
        miCommitVCS.setName("miCommitVCS");
        miCommitVCS.setText(_("isisfish.script.menu.commit"));
        miCommitVCS.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miCommitVCS"));
    }

    protected void createMiCopy() {
        $objectMap.put("miCopy", miCopy = new JMenuItem());
        
        miCopy.setName("miCopy");
        miCopy.setText(_("isisfish.script.menu.copy"));
        miCopy.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miCopy"));
    }

    protected void createMiCut() {
        $objectMap.put("miCut", miCut = new JMenuItem());
        
        miCut.setName("miCut");
        miCut.setText(_("isisfish.script.menu.cut"));
        miCut.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miCut"));
    }

    protected void createMiDelete() {
        $objectMap.put("miDelete", miDelete = new JMenuItem());
        
        miDelete.setName("miDelete");
        miDelete.setText(_("isisfish.script.menu.deleteLocaly"));
        miDelete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miDelete"));
    }

    protected void createMiDeleteVCS() {
        $objectMap.put("miDeleteVCS", miDeleteVCS = new JMenuItem());
        
        miDeleteVCS.setName("miDeleteVCS");
        miDeleteVCS.setText(_("isisfish.script.menu.deleteLocalyServer"));
        miDeleteVCS.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miDeleteVCS"));
    }

    protected void createMiDiffVCS() {
        $objectMap.put("miDiffVCS", miDiffVCS = new JMenuItem());
        
        miDiffVCS.setName("miDiffVCS");
        miDiffVCS.setAccelerator(null);
        miDiffVCS.setText(_("isisfish.script.menu.diff"));
        miDiffVCS.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miDiffVCS"));
    }

    protected void createMiEvaluate() {
        $objectMap.put("miEvaluate", miEvaluate = new JMenuItem());
        
        miEvaluate.setName("miEvaluate");
        miEvaluate.setText(_("isisfish.script.menu.evaluate"));
        miEvaluate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miEvaluate"));
    }

    protected void createMiExport() {
        $objectMap.put("miExport", miExport = new JMenuItem());
        
        miExport.setName("miExport");
        miExport.setText(_("isisfish.script.menu.txtExport"));
        miExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miExport"));
    }

    protected void createMiGenerateJavadoc() {
        $objectMap.put("miGenerateJavadoc", miGenerateJavadoc = new JMenuItem());
        
        miGenerateJavadoc.setName("miGenerateJavadoc");
        miGenerateJavadoc.setText(_("isisfish.script.menu.javadocgenerate"));
        miGenerateJavadoc.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miGenerateJavadoc"));
    }

    protected void createMiImport() {
        $objectMap.put("miImport", miImport = new JMenuItem());
        
        miImport.setName("miImport");
        miImport.setEnabled(false);
        miImport.setText(_("isisfish.script.menu.txtImport"));
        miImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miImport"));
    }

    protected void createMiNewEquationModel() {
        $objectMap.put("miNewEquationModel", miNewEquationModel = new JMenuItem());
        
        miNewEquationModel.setName("miNewEquationModel");
        miNewEquationModel.setText(_("isisfish.script.menu.txtNewEquationModel"));
        miNewEquationModel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewEquationModel"));
    }

    protected void createMiNewExport() {
        $objectMap.put("miNewExport", miNewExport = new JMenuItem());
        
        miNewExport.setName("miNewExport");
        miNewExport.setText(_("isisfish.script.menu.txtNewExport"));
        miNewExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewExport"));
    }

    protected void createMiNewRule() {
        $objectMap.put("miNewRule", miNewRule = new JMenuItem());
        
        miNewRule.setName("miNewRule");
        miNewRule.setText(_("isisfish.script.menu.txtNewRule"));
        miNewRule.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewRule"));
    }

    protected void createMiNewSImulationPlan() {
        $objectMap.put("miNewSImulationPlan", miNewSImulationPlan = new JMenuItem());
        
        miNewSImulationPlan.setName("miNewSImulationPlan");
        miNewSImulationPlan.setText(_("isisfish.script.menu.txtNewSimulationPlan"));
        miNewSImulationPlan.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewSImulationPlan"));
    }

    protected void createMiNewScript() {
        $objectMap.put("miNewScript", miNewScript = new JMenuItem());
        
        miNewScript.setName("miNewScript");
        miNewScript.setText(_("isisfish.script.menu.txtNewScript"));
        miNewScript.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewScript"));
    }

    protected void createMiNewSensitivity() {
        $objectMap.put("miNewSensitivity", miNewSensitivity = new JMenuItem());
        
        miNewSensitivity.setName("miNewSensitivity");
        miNewSensitivity.setText(_("isisfish.script.menu.txtNewSensitivity"));
        miNewSensitivity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewSensitivity"));
    }

    protected void createMiNewSensitivityExport() {
        $objectMap.put("miNewSensitivityExport", miNewSensitivityExport = new JMenuItem());
        
        miNewSensitivityExport.setName("miNewSensitivityExport");
        miNewSensitivityExport.setText(_("isisfish.script.menu.txtNewSensitivityExport"));
        miNewSensitivityExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewSensitivityExport"));
    }

    protected void createMiNewSimulator() {
        $objectMap.put("miNewSimulator", miNewSimulator = new JMenuItem());
        
        miNewSimulator.setName("miNewSimulator");
        miNewSimulator.setText(_("isisfish.script.menu.txtNewSimulator"));
        miNewSimulator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miNewSimulator"));
    }

    protected void createMiPaste() {
        $objectMap.put("miPaste", miPaste = new JMenuItem());
        
        miPaste.setName("miPaste");
        miPaste.setText(_("isisfish.script.menu.paste"));
        miPaste.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miPaste"));
    }

    protected void createMiSave() {
        $objectMap.put("miSave", miSave = new JMenuItem());
        
        miSave.setName("miSave");
        miSave.setText(_("isisfish.script.menu.save"));
        miSave.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miSave"));
    }

    protected void createMiShowJavadoc() {
        $objectMap.put("miShowJavadoc", miShowJavadoc = new JMenuItem());
        
        miShowJavadoc.setName("miShowJavadoc");
        miShowJavadoc.setText(_("isisfish.script.menu.javadocshow"));
        miShowJavadoc.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miShowJavadoc"));
    }

    protected void createMiUpdateVCS() {
        $objectMap.put("miUpdateVCS", miUpdateVCS = new JMenuItem());
        
        miUpdateVCS.setName("miUpdateVCS");
        miUpdateVCS.setText(_("isisfish.script.menu.update"));
        miUpdateVCS.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miUpdateVCS"));
    }

    protected void createScriptAction() {
        $objectMap.put("scriptAction", scriptAction = new ScriptAction(this));
    }

    protected void createScriptMenuBar() {
        $objectMap.put("scriptMenuBar", scriptMenuBar = new JMenuBar());
        
        scriptMenuBar.setName("scriptMenuBar");
    }

    protected void createScriptNewMenu() {
        $objectMap.put("scriptNewMenu", scriptNewMenu = new JMenu());
        
        scriptNewMenu.setName("scriptNewMenu");
        scriptNewMenu.setText(_("isisfish.script.menu.new"));
    }

    protected void createScriptTree() {
        $objectMap.put("scriptTree", scriptTree = new ScriptTree(this));
        
        scriptTree.setName("scriptTree");
        scriptTree.setRootVisible(false);
    }

    protected void createScriptTreeModel() {
        $objectMap.put("scriptTreeModel", scriptTreeModel = new ScriptTreeModel());
    }

    protected void createScriptTxtCode() {
        $objectMap.put("scriptTxtCode", scriptTxtCode = new JMenu());
        
        scriptTxtCode.setName("scriptTxtCode");
        scriptTxtCode.setText(_("isisfish.script.menu.code"));
    }

    protected void createScriptTxtEdit() {
        $objectMap.put("scriptTxtEdit", scriptTxtEdit = new JMenu());
        
        scriptTxtEdit.setName("scriptTxtEdit");
        scriptTxtEdit.setText(_("isisfish.script.menu.edit"));
    }

    protected void createScriptTxtFile() {
        $objectMap.put("scriptTxtFile", scriptTxtFile = new JMenu());
        
        scriptTxtFile.setName("scriptTxtFile");
        scriptTxtFile.setText(_("isisfish.script.menu.file"));
    }

    protected void createScriptTxtVCS() {
        $objectMap.put("scriptTxtVCS", scriptTxtVCS = new JMenu());
        
        scriptTxtVCS.setName("scriptTxtVCS");
        scriptTxtVCS.setText(_("isisfish.script.menu.txtVCS"));
    }

    protected void createScriptTypeChoice() {
        $objectMap.put("scriptTypeChoice", scriptTypeChoice = new JComboBox());
        
        scriptTypeChoice.setName("scriptTypeChoice");
    }

    protected void createSingleFileSelected() {
        $objectMap.put("singleFileSelected", singleFileSelected = false);
    }

    protected void createTextSelected() {
        $objectMap.put("textSelected", textSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(scriptMenuBar, BorderLayout.NORTH);
        add($JPanel1, BorderLayout.CENTER);
        addChildrenToScriptMenuBar();
        addChildrenToScriptTxtFile();
        addChildrenToScriptNewMenu();
        addChildrenToScriptTxtEdit();
        addChildrenToScriptTxtVCS();
        addChildrenToScriptTxtCode();
        // inline complete setup of $JPanel1
        $JPanel1.add(buttonBar, BorderLayout.NORTH);
        $JPanel1.add($JSplitPane0, BorderLayout.CENTER);
        addChildrenToButtonBar();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane0.add($JSplitPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(scriptTree);
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add(editor, JSplitPane.LEFT);
        $JSplitPane1.add($JScrollPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(actionLogArea);
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 38 property setters
        scriptNewMenu.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewScript.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewSimulator.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewExport.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewRule.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewSImulationPlan.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewSensitivity.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewSensitivityExport.setIcon(SwingUtil.createImageIcon("script.png"));
        miNewEquationModel.setIcon(SwingUtil.createImageIcon("script.png"));
        miSave.setIcon(SwingUtil.createImageIcon("script_save.png"));
        miImport.setIcon(SwingUtil.createImageIcon("page_white_compressed.png"));
        miExport.setIcon(SwingUtil.createImageIcon("page_white_compressed.png"));
        miDelete.setIcon(SwingUtil.createImageIcon("script_delete.png"));
        miCut.setIcon(SwingUtil.createImageIcon("cut.png"));
        miCopy.setIcon(SwingUtil.createImageIcon("page_copy.png"));
        miPaste.setIcon(SwingUtil.createImageIcon("page_paste.png"));
        miCommitVCS.setIcon(SwingUtil.createImageIcon("database_go.png"));
        miUpdateVCS.setIcon(SwingUtil.createImageIcon("database_refresh.png"));
        miDeleteVCS.setIcon(SwingUtil.createImageIcon("database_delete.png"));
        miCheckSyntax.setIcon(SwingUtil.createImageIcon("script_code_red.png"));
        miCheckAllSyntax.setIcon(SwingUtil.createImageIcon("script_code_red.png"));
        miEvaluate.setIcon(SwingUtil.createImageIcon("script_gear.png"));
        scriptTypeChoice.setModel(new ScriptTypesComboModel());
        buttonScriptNew.setIcon(SwingUtil.createImageIcon("script.png"));
        buttonScriptSave.setIcon(SwingUtil.createImageIcon("script_save.png"));
        buttonScriptExport.setIcon(SwingUtil.createImageIcon("page_white_compressed.png"));
        buttonScriptCommit.setIcon(SwingUtil.createImageIcon("database_go.png"));
        buttonScriptCut.setIcon(SwingUtil.createImageIcon("cut.png"));
        buttonScriptCopy.setIcon(SwingUtil.createImageIcon("page_copy.png"));
        buttonScriptPaste.setIcon(SwingUtil.createImageIcon("page_paste.png"));
        buttonScriptCheck.setIcon(SwingUtil.createImageIcon("script_code_red.png"));
        buttonScriptEval.setIcon(SwingUtil.createImageIcon("script_gear.png"));
        scriptTree.setCellRenderer(new fr.ifremer.isisfish.ui.script.model.ScriptTreeCellRenderer());
        scriptTree.setModel(scriptTreeModel);
        actionLogArea.setFont(new Font("Monospaced", Font.PLAIN, 12));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createScriptAction();
        createFileSelected();
        createSingleFileSelected();
        createTextSelected();
        createJavaFileSelected();
        createScriptMenuBar();
        createScriptTxtFile();
        createScriptNewMenu();
        createMiNewScript();
        createMiNewSimulator();
        createMiNewExport();
        createMiNewRule();
        createMiNewSImulationPlan();
        createMiNewSensitivity();
        createMiNewSensitivityExport();
        createMiNewEquationModel();
        createMiSave();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMiImport();
        createMiExport();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMiDelete();
        createScriptTxtEdit();
        createMiCut();
        createMiCopy();
        createMiPaste();
        createScriptTxtVCS();
        createMiCommitVCS();
        createMiDiffVCS();
        createMiUpdateVCS();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createMiDeleteVCS();
        createScriptTxtCode();
        createMiCheckSyntax();
        createMiCheckAllSyntax();
        createMiEvaluate();
        // inline creation of $JSeparator3
        $objectMap.put("$JSeparator3", $JSeparator3 = new JSeparator());
        
        $JSeparator3.setName("$JSeparator3");
        createMiGenerateJavadoc();
        createMiShowJavadoc();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createButtonBar();
        createScriptTypeChoice();
        createButtonScriptNew();
        createButtonScriptSave();
        createButtonScriptExport();
        createButtonScriptCommit();
        createButtonScriptCut();
        createButtonScriptCopy();
        createButtonScriptPaste();
        createButtonScriptCheck();
        createButtonScriptEval();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(250);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createScriptTreeModel();
        createScriptTree();
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setOrientation(0);
        $JSplitPane1.setResizeWeight(0.75);
        createEditor();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createActionLogArea();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_SAVE_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                miSave.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_EXPORT_ENABLED, true ,"fileSelected") {
        
            @Override
            public void processDataBinding() {
                miExport.setEnabled(isFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_DELETE_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                miDelete.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_CUT_ENABLED, true ,"textSelected") {
        
            @Override
            public void processDataBinding() {
                miCut.setEnabled(isTextSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_COPY_ENABLED, true ,"textSelected") {
        
            @Override
            public void processDataBinding() {
                miCopy.setEnabled(isTextSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_PASTE_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                miPaste.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_COMMIT_VCS_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                miCommitVCS.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_DIFF_VCS_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                miDiffVCS.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_CHECK_SYNTAX_ENABLED, true ,"javaFileSelected") {
        
            @Override
            public void processDataBinding() {
                miCheckSyntax.setEnabled(isJavaFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MI_EVALUATE_ENABLED, true ,"javaFileSelected") {
        
            @Override
            public void processDataBinding() {
                miEvaluate.setEnabled(isJavaFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_SAVE_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptSave.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_COMMIT_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptCommit.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_CUT_ENABLED, true ,"textSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptCut.setEnabled(isTextSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_COPY_ENABLED, true ,"textSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptCopy.setEnabled(isTextSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_PASTE_ENABLED, true ,"singleFileSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptPaste.setEnabled(isSingleFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_CHECK_ENABLED, true ,"javaFileSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptCheck.setEnabled(isJavaFileSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SCRIPT_EVAL_ENABLED, true ,"javaFileSelected") {
        
            @Override
            public void processDataBinding() {
                buttonScriptEval.setEnabled(isJavaFileSelected());
            }
        });
    }

}