/*
 * #%L
 * IsisFish
 * 
 * $Id: ExportListRenderer.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.export;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.Export;

/**
 * Renderer pour la liste des export.
 *
 * @author chatellier
 * @version $Revision: 3445 $
 * 
 * Last update : $Date: 2011-07-15 15:12:45 +0200 (Fri, 15 Jul 2011) $
 * By : $Author: chatellier $
 */
public class ExportListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        Export export = (Export) value;
        c.setText(ExportStorage.getName(export));

        try {
            c.setToolTipText(export.getDescription());
        } catch (Exception e) {
            // can't get exception
        }

        return this;
    }
}
