/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.config;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SSHLauncherConfigUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTION = "action";
    public static final String PROPERTY_CONNECTED = "connected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLEAR_DATABASE_BUTTON_ENABLED = "clearDatabaseButton.enabled";
    public static final String BINDING_CLEAR_TEMP_BUTTON_ENABLED = "clearTempButton.enabled";
    public static final String BINDING_STATUS_FREE_DATABASE_LABEL_ENABLED = "statusFreeDatabaseLabel.enabled";
    public static final String BINDING_STATUS_FREE_TEMP_LABEL_ENABLED = "statusFreeTempLabel.enabled";
    public static final String BINDING_VALID_BUTTON_ENABLED = "validButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJ6Zx6vxoSwxJCwGFEooA1W6oKoRSaPMDk6QuabEDBQvB2Du2p1rvbmZmGycHhLhw4cCfAHcuSNwQB9QDZw5cEP9CVXHginiz6x/ZZHe88HxY2/Pe++z3vZ2ZN/v9IzIuBXnhPu12C8J3FO+wwvbqvXs79fusoTaYbAjuKVeQ8DOWIZkambIG41KRF2tlHV7shRfX3Y7nOsw5Er1SJpNSHdhMthlTijwXjWhIWawMzCtdzxd96kBUHPXbvx5nvrG++C5DSNcDda9CKoujooaZnCqTDLcUmYU7PaBFmzotkCG40wK9M3ps3aZSvkc7bI98TibKJOtRATBFLqZPOWAE8V1PkdzS9ganttu6oshyUxR4U7AOg2/JZZPLdsHnhYbrNHmrUKlslqnvNNpMrAcju1ueF5CyimRpQ3HXUeTaf4SsBnFDUA4cHXjUDArxpM65oOtQWHNdm9EjfhNLVVq3Gcg+H6mw3Id6FQKb9swNAs5I2a4w8YCJMq0zG8qs6d1ewHYwqF1nYyJKnNmgZy4SUWVdFRiiUTO+ZMKBZzQgzic4DIKfiTpMwX1vsYOk+J45KXo6NK/5SunnkY9oDkejAb1KLuu/T0Vrdg5Yu6C27R5P51KsT1RT1GeDKupR1TZx+j4mzhZMqs0Revo+Jk6VdbxRevo+Js421PfOCE7fJ4kzCz536nKNOyZS1CuJNRd63ZV+fcfTa0sm8U56mvTdpt1qWzBqJfKiXkmsefCCpa+Ea285CpYXtZOAMa5J1N4kfj1mEk8qJtVw4r+kL+XhagIot5LNgkmWHD3doE6D2Yn2nqyrMbKmO0xK2jo2jz8Y2E8vhXvSlRjbvFRU+bIkGNNLpk5lIibfgH1T9L2OCT3iNiTqSZ9EOxvQtMdJkiDPRnZi6KKFYRcdtrmxGhkXPgzD1l072XjfB1PYcs8fa7kaGFj/mcv//tOfP5b6fbYE93461vXIMQH6nydcjwnF9a3Phk3WV9wu3qbeSo3kJLOh8QRniIUYYZWeGcTB/cLepMMLm1TPe2984o9fHs599tsTJFMik7ZLrRLV/lskp2BJyLZrW13vxs1A0fT+abie09qgedr0wIV6kjPXLXhQi3XuWLBdv92FIizEFGGgpJ779e985Yeb/UKMgbALie7DYox/TLLcsbnDgiNH7zQRe8SY8iTzLXd4aog7R4zp70mv1515cO3EZZqDOvBDvSRgu7geSlikCg45dV8xSFhH7gWZ6F8yNXhccRV2/O7/h2TrrrCY0HYvnpJPQTml4GBgUDKXgjGl4LxT5V4Vi9LDXxsIF1IRvjIQFtAa8ITn0VksojXgCRfRWSylInxpmOAvozW8gq7DaAI0VuboXcQyYF5DC0lHMBXjMloDnlBEZ7GM1oAnXEVncQ2tAU94A53Fm2gNeMIKOou30BrwhBvoLFbRGvCEdXQW76A14AnvorPYQmvAE26lOR3yRvjalNCAd9CVSEf42aDhbhrC2CUswZgFXkMFrSEVwahhF60hHcF0pPsQTfgozRtL03XU5X3GW23TG0saVL7tCn4IOGqv2rzldJiDRU51uMM7fqfCDxky0azr0T3f9KqZhjLjCdZkQjALLWnUDEpHMO0HNbSGdASThk/QhE/RqzkVwViHdARTFhRNaKDrkIpgrIMm/AtVVtLn7BsAAA==";
    private static final Log log = LogFactory.getLog(SSHLauncherConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SSHLauncherConfigAction action;
    protected JButton cancelButton;
    protected JButton clearDatabaseButton;
    protected JButton clearTempButton;
    protected Boolean connected;
    protected JLabel messageLabel;
    protected JButton resetButton;
    protected JTextField sshControlIntervalField;
    protected JLabel sshControlIntervalLabel;
    protected JTextField sshDatapathField;
    protected JLabel sshDatapathLabel;
    protected JTextField sshIsisHomeField;
    protected JLabel sshIsisHomeLabel;
    protected JTextField sshJavaPathField;
    protected JLabel sshJavaPathLabel;
    protected JButton sshKeyButton;
    protected JTextField sshKeyField;
    protected JLabel sshKeyLabel;
    protected JTextField sshMaxThreadsField;
    protected JLabel sshMaxThreadsLabel;
    protected JTextField sshPbsBinPathField;
    protected JLabel sshPbsBinPathLabel;
    protected JTextField sshPbsQsubOptionsField;
    protected JLabel sshPbsQsubOptionsLabel;
    protected JTextField sshServerField;
    protected JLabel sshServerLabel;
    protected JTextField sshTemppathField;
    protected JLabel sshTemppathLabel;
    protected JTextField sshUserhomeField;
    protected JLabel sshUserhomeLabel;
    protected JLabel statusFreeDatabaseLabel;
    protected JLabel statusFreeTempLabel;
    protected JButton testButton;
    protected JTextField usernameField;
    protected JLabel usernameLabel;
    protected JButton validButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SSHLauncherConfigUI $JDialog0 = this;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SSHLauncherConfigUI(Window param0) {
        super(param0);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI() {
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SSHLauncherConfigUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SSHLauncherConfigUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().cancelSSHConfiguration();
    }

    public void doActionPerformed__on__clearDatabaseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().clearDatabase();
    }

    public void doActionPerformed__on__clearTempButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().clearTempDirectory();
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().resetSSHConfiguration();
    }

    public void doActionPerformed__on__sshKeyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().generateSSHKey();
    }

    public void doActionPerformed__on__testButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().testSSHConfiguration();
    }

    public void doActionPerformed__on__validButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().saveSSHConfiguration();
    }

    public void doKeyReleased__on__sshControlIntervalField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshDatapathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshIsisHomeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshJavaPathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshKeyField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshMaxThreadsField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshPbsBinPathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshPbsQsubOptionsField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshServerField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshTemppathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshUserhomeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    public void doKeyReleased__on__usernameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAction().doCheck();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SSHLauncherConfigAction getAction() {
        return action;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JButton getClearDatabaseButton() {
        return clearDatabaseButton;
    }

    public JButton getClearTempButton() {
        return clearTempButton;
    }

    public Boolean getConnected() {
        return connected;
    }

    public JLabel getMessageLabel() {
        return messageLabel;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public JTextField getSshControlIntervalField() {
        return sshControlIntervalField;
    }

    public JLabel getSshControlIntervalLabel() {
        return sshControlIntervalLabel;
    }

    public JTextField getSshDatapathField() {
        return sshDatapathField;
    }

    public JLabel getSshDatapathLabel() {
        return sshDatapathLabel;
    }

    public JTextField getSshIsisHomeField() {
        return sshIsisHomeField;
    }

    public JLabel getSshIsisHomeLabel() {
        return sshIsisHomeLabel;
    }

    public JTextField getSshJavaPathField() {
        return sshJavaPathField;
    }

    public JLabel getSshJavaPathLabel() {
        return sshJavaPathLabel;
    }

    public JButton getSshKeyButton() {
        return sshKeyButton;
    }

    public JTextField getSshKeyField() {
        return sshKeyField;
    }

    public JLabel getSshKeyLabel() {
        return sshKeyLabel;
    }

    public JTextField getSshMaxThreadsField() {
        return sshMaxThreadsField;
    }

    public JLabel getSshMaxThreadsLabel() {
        return sshMaxThreadsLabel;
    }

    public JTextField getSshPbsBinPathField() {
        return sshPbsBinPathField;
    }

    public JLabel getSshPbsBinPathLabel() {
        return sshPbsBinPathLabel;
    }

    public JTextField getSshPbsQsubOptionsField() {
        return sshPbsQsubOptionsField;
    }

    public JLabel getSshPbsQsubOptionsLabel() {
        return sshPbsQsubOptionsLabel;
    }

    public JTextField getSshServerField() {
        return sshServerField;
    }

    public JLabel getSshServerLabel() {
        return sshServerLabel;
    }

    public JTextField getSshTemppathField() {
        return sshTemppathField;
    }

    public JLabel getSshTemppathLabel() {
        return sshTemppathLabel;
    }

    public JTextField getSshUserhomeField() {
        return sshUserhomeField;
    }

    public JLabel getSshUserhomeLabel() {
        return sshUserhomeLabel;
    }

    public JLabel getStatusFreeDatabaseLabel() {
        return statusFreeDatabaseLabel;
    }

    public JLabel getStatusFreeTempLabel() {
        return statusFreeTempLabel;
    }

    public JButton getTestButton() {
        return testButton;
    }

    public JTextField getUsernameField() {
        return usernameField;
    }

    public JLabel getUsernameLabel() {
        return usernameLabel;
    }

    public JButton getValidButton() {
        return validButton;
    }

    public Boolean isConnected() {
        return connected !=null && connected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAction(SSHLauncherConfigAction action) {
        SSHLauncherConfigAction oldValue = this.action;
        this.action = action;
        firePropertyChange(PROPERTY_ACTION, oldValue, action);
    }

    public void setConnected(Boolean connected) {
        Boolean oldValue = this.connected;
        this.connected = connected;
        firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAction() {
        $objectMap.put("action", action = new SSHLauncherConfigAction(this));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("isisfish.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createClearDatabaseButton() {
        $objectMap.put("clearDatabaseButton", clearDatabaseButton = new JButton());
        
        clearDatabaseButton.setName("clearDatabaseButton");
        clearDatabaseButton.setText(_("isisfish.common.clear"));
        clearDatabaseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearDatabaseButton"));
    }

    protected void createClearTempButton() {
        $objectMap.put("clearTempButton", clearTempButton = new JButton());
        
        clearTempButton.setName("clearTempButton");
        clearTempButton.setText(_("isisfish.common.clear"));
        clearTempButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearTempButton"));
    }

    protected void createConnected() {
        $objectMap.put("connected", connected = false);
    }

    protected void createMessageLabel() {
        $objectMap.put("messageLabel", messageLabel = new JLabel());
        
        messageLabel.setName("messageLabel");
        if (messageLabel.getFont() != null) {
            messageLabel.setFont(messageLabel.getFont().deriveFont(messageLabel.getFont().getStyle() | Font.BOLD));
        }
        messageLabel.setHorizontalAlignment(0);
        messageLabel.setOpaque(true);
        messageLabel.setText(_(""));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setText(_("isisfish.common.reset"));
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createSshControlIntervalField() {
        $objectMap.put("sshControlIntervalField", sshControlIntervalField = new JTextField());
        
        sshControlIntervalField.setName("sshControlIntervalField");
        sshControlIntervalField.setColumns(15);
        sshControlIntervalField.setToolTipText(_("isisfish.config.main.simulation.ssh.control.check.interval.description"));
        sshControlIntervalField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshControlIntervalField"));
    }

    protected void createSshControlIntervalLabel() {
        $objectMap.put("sshControlIntervalLabel", sshControlIntervalLabel = new JLabel());
        
        sshControlIntervalLabel.setName("sshControlIntervalLabel");
        sshControlIntervalLabel.setText(_("isisfish.config.main.simulation.ssh.control.check.interval"));
        sshControlIntervalLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.control.check.interval.description"));
    }

    protected void createSshDatapathField() {
        $objectMap.put("sshDatapathField", sshDatapathField = new JTextField());
        
        sshDatapathField.setName("sshDatapathField");
        sshDatapathField.setColumns(15);
        sshDatapathField.setToolTipText(_("isisfish.config.main.simulation.ssh.datapath.description"));
        sshDatapathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshDatapathField"));
    }

    protected void createSshDatapathLabel() {
        $objectMap.put("sshDatapathLabel", sshDatapathLabel = new JLabel());
        
        sshDatapathLabel.setName("sshDatapathLabel");
        sshDatapathLabel.setText(_("isisfish.config.main.simulation.ssh.datapath"));
        sshDatapathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.datapath.description"));
    }

    protected void createSshIsisHomeField() {
        $objectMap.put("sshIsisHomeField", sshIsisHomeField = new JTextField());
        
        sshIsisHomeField.setName("sshIsisHomeField");
        sshIsisHomeField.setColumns(15);
        sshIsisHomeField.setToolTipText(_("isisfish.config.main.simulation.ssh.isis.home.description"));
        sshIsisHomeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshIsisHomeField"));
    }

    protected void createSshIsisHomeLabel() {
        $objectMap.put("sshIsisHomeLabel", sshIsisHomeLabel = new JLabel());
        
        sshIsisHomeLabel.setName("sshIsisHomeLabel");
        sshIsisHomeLabel.setText(_("isisfish.config.main.simulation.ssh.isis.home"));
        sshIsisHomeLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.isis.home.description"));
    }

    protected void createSshJavaPathField() {
        $objectMap.put("sshJavaPathField", sshJavaPathField = new JTextField());
        
        sshJavaPathField.setName("sshJavaPathField");
        sshJavaPathField.setColumns(15);
        sshJavaPathField.setToolTipText(_("isisfish.config.main.simulation.ssh.javapath.description"));
        sshJavaPathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshJavaPathField"));
    }

    protected void createSshJavaPathLabel() {
        $objectMap.put("sshJavaPathLabel", sshJavaPathLabel = new JLabel());
        
        sshJavaPathLabel.setName("sshJavaPathLabel");
        sshJavaPathLabel.setText(_("isisfish.config.main.simulation.ssh.javapath"));
        sshJavaPathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.javapath.description"));
    }

    protected void createSshKeyButton() {
        $objectMap.put("sshKeyButton", sshKeyButton = new JButton());
        
        sshKeyButton.setName("sshKeyButton");
        sshKeyButton.setText(_("isisfish.simulator.ssh.configuration.keygenerate"));
        sshKeyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sshKeyButton"));
    }

    protected void createSshKeyField() {
        $objectMap.put("sshKeyField", sshKeyField = new JTextField());
        
        sshKeyField.setName("sshKeyField");
        sshKeyField.setColumns(15);
        sshKeyField.setToolTipText(_("isisfish.config.ssh.key.file.description"));
        sshKeyField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshKeyField"));
    }

    protected void createSshKeyLabel() {
        $objectMap.put("sshKeyLabel", sshKeyLabel = new JLabel());
        
        sshKeyLabel.setName("sshKeyLabel");
        sshKeyLabel.setText(_("isisfish.config.ssh.key.file"));
        sshKeyLabel.setToolTipText(_("isisfish.config.ssh.key.file.description"));
    }

    protected void createSshMaxThreadsField() {
        $objectMap.put("sshMaxThreadsField", sshMaxThreadsField = new JTextField());
        
        sshMaxThreadsField.setName("sshMaxThreadsField");
        sshMaxThreadsField.setColumns(15);
        sshMaxThreadsField.setToolTipText(_("isisfish.config.main.simulation.ssh.max.threads.description"));
        sshMaxThreadsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshMaxThreadsField"));
    }

    protected void createSshMaxThreadsLabel() {
        $objectMap.put("sshMaxThreadsLabel", sshMaxThreadsLabel = new JLabel());
        
        sshMaxThreadsLabel.setName("sshMaxThreadsLabel");
        sshMaxThreadsLabel.setText(_("isisfish.config.main.simulation.ssh.max.threads"));
        sshMaxThreadsLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.max.threads.description"));
    }

    protected void createSshPbsBinPathField() {
        $objectMap.put("sshPbsBinPathField", sshPbsBinPathField = new JTextField());
        
        sshPbsBinPathField.setName("sshPbsBinPathField");
        sshPbsBinPathField.setColumns(15);
        sshPbsBinPathField.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsbinpath.description"));
        sshPbsBinPathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshPbsBinPathField"));
    }

    protected void createSshPbsBinPathLabel() {
        $objectMap.put("sshPbsBinPathLabel", sshPbsBinPathLabel = new JLabel());
        
        sshPbsBinPathLabel.setName("sshPbsBinPathLabel");
        sshPbsBinPathLabel.setText(_("isisfish.config.main.simulation.ssh.pbsbinpath"));
        sshPbsBinPathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsbinpath.description"));
    }

    protected void createSshPbsQsubOptionsField() {
        $objectMap.put("sshPbsQsubOptionsField", sshPbsQsubOptionsField = new JTextField());
        
        sshPbsQsubOptionsField.setName("sshPbsQsubOptionsField");
        sshPbsQsubOptionsField.setColumns(15);
        sshPbsQsubOptionsField.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions.description"));
        sshPbsQsubOptionsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshPbsQsubOptionsField"));
    }

    protected void createSshPbsQsubOptionsLabel() {
        $objectMap.put("sshPbsQsubOptionsLabel", sshPbsQsubOptionsLabel = new JLabel());
        
        sshPbsQsubOptionsLabel.setName("sshPbsQsubOptionsLabel");
        sshPbsQsubOptionsLabel.setText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions"));
        sshPbsQsubOptionsLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions.description"));
    }

    protected void createSshServerField() {
        $objectMap.put("sshServerField", sshServerField = new JTextField());
        
        sshServerField.setName("sshServerField");
        sshServerField.setColumns(15);
        sshServerField.setToolTipText(_("isisfish.config.main.simulation.ssh.server.description"));
        sshServerField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshServerField"));
    }

    protected void createSshServerLabel() {
        $objectMap.put("sshServerLabel", sshServerLabel = new JLabel());
        
        sshServerLabel.setName("sshServerLabel");
        sshServerLabel.setText(_("isisfish.config.main.simulation.ssh.server"));
        sshServerLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.server.description"));
    }

    protected void createSshTemppathField() {
        $objectMap.put("sshTemppathField", sshTemppathField = new JTextField());
        
        sshTemppathField.setName("sshTemppathField");
        sshTemppathField.setColumns(15);
        sshTemppathField.setToolTipText(_("isisfish.config.main.simulation.ssh.tmppath.description"));
        sshTemppathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshTemppathField"));
    }

    protected void createSshTemppathLabel() {
        $objectMap.put("sshTemppathLabel", sshTemppathLabel = new JLabel());
        
        sshTemppathLabel.setName("sshTemppathLabel");
        sshTemppathLabel.setText(_("isisfish.config.main.simulation.ssh.tmppath"));
        sshTemppathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.tmppath.description"));
    }

    protected void createSshUserhomeField() {
        $objectMap.put("sshUserhomeField", sshUserhomeField = new JTextField());
        
        sshUserhomeField.setName("sshUserhomeField");
        sshUserhomeField.setColumns(15);
        sshUserhomeField.setEnabled(false);
        sshUserhomeField.setToolTipText(_("isisfish.config.main.simulation.ssh.userhome.description"));
        sshUserhomeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sshUserhomeField"));
    }

    protected void createSshUserhomeLabel() {
        $objectMap.put("sshUserhomeLabel", sshUserhomeLabel = new JLabel());
        
        sshUserhomeLabel.setName("sshUserhomeLabel");
        sshUserhomeLabel.setText(_("isisfish.config.main.simulation.ssh.userhome"));
        sshUserhomeLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.userhome.description"));
    }

    protected void createStatusFreeDatabaseLabel() {
        $objectMap.put("statusFreeDatabaseLabel", statusFreeDatabaseLabel = new JLabel());
        
        statusFreeDatabaseLabel.setName("statusFreeDatabaseLabel");
    }

    protected void createStatusFreeTempLabel() {
        $objectMap.put("statusFreeTempLabel", statusFreeTempLabel = new JLabel());
        
        statusFreeTempLabel.setName("statusFreeTempLabel");
    }

    protected void createTestButton() {
        $objectMap.put("testButton", testButton = new JButton());
        
        testButton.setName("testButton");
        testButton.setText(_("isisfish.simulator.ssh.configuration.test"));
        testButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__testButton"));
    }

    protected void createUsernameField() {
        $objectMap.put("usernameField", usernameField = new JTextField());
        
        usernameField.setName("usernameField");
        usernameField.setColumns(15);
        usernameField.setToolTipText(_("isisfish.config.main.simulation.ssh.username.description"));
        usernameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__usernameField"));
    }

    protected void createUsernameLabel() {
        $objectMap.put("usernameLabel", usernameLabel = new JLabel());
        
        usernameLabel.setName("usernameLabel");
        usernameLabel.setText(_("isisfish.config.main.simulation.ssh.username"));
        usernameLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.username.description"));
    }

    protected void createValidButton() {
        $objectMap.put("validButton", validButton = new JButton());
        
        validButton.setName("validButton");
        validButton.setText(_("isisfish.common.valid"));
        validButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        add($Table1);
        add($Table2);
        add($Table3);
        // inline complete setup of $Table0
        $Table0.add(sshServerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sshServerField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usernameField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sshKeyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sshKeyField, new GridBagConstraints(1, 2, 1, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sshKeyButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(sshUserhomeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshUserhomeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshDatapathLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshDatapathField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshIsisHomeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshIsisHomeField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshTemppathLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshTemppathField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshJavaPathLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshJavaPathField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshPbsBinPathLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshPbsBinPathField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshPbsQsubOptionsLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshPbsQsubOptionsField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshMaxThreadsLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshMaxThreadsField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshControlIntervalLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshControlIntervalField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add(testButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(validButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(resetButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(cancelButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add(messageLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(statusFreeDatabaseLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(clearDatabaseButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(statusFreeTempLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(clearTempButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        $Table0.setBorder(BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.connection")));
        $Table1.setBorder(BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.environment")));
        testButton.setIcon(SwingUtil.createImageIcon("connect.png"));
        validButton.setIcon(SwingUtil.createImageIcon("accept.png"));
        resetButton.setIcon(SwingUtil.createImageIcon("arrow_undo.png"));
        cancelButton.setIcon(SwingUtil.createImageIcon("cancel.png"));
        $Table3.setBorder(BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.status")));
        messageLabel.setBorder(BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED));
        messageLabel.setMinimumSize(new java.awt.Dimension(0, 25));
        messageLabel.setPreferredSize(new java.awt.Dimension(0, 25));
        clearDatabaseButton.setIcon(SwingUtil.createImageIcon("paintbrush.png"));
        clearTempButton.setIcon(SwingUtil.createImageIcon("paintbrush.png"));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createAction();
        createConnected();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSshServerLabel();
        createSshServerField();
        createUsernameLabel();
        createUsernameField();
        createSshKeyLabel();
        createSshKeyField();
        createSshKeyButton();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSshUserhomeLabel();
        createSshUserhomeField();
        createSshDatapathLabel();
        createSshDatapathField();
        createSshIsisHomeLabel();
        createSshIsisHomeField();
        createSshTemppathLabel();
        createSshTemppathField();
        createSshJavaPathLabel();
        createSshJavaPathField();
        createSshPbsBinPathLabel();
        createSshPbsBinPathField();
        createSshPbsQsubOptionsLabel();
        createSshPbsQsubOptionsField();
        createSshMaxThreadsLabel();
        createSshMaxThreadsField();
        createSshControlIntervalLabel();
        createSshControlIntervalField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createTestButton();
        createValidButton();
        createResetButton();
        createCancelButton();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createMessageLabel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.simulator.ssh.configuration.freespace"));
        createStatusFreeDatabaseLabel();
        createClearDatabaseButton();
        createStatusFreeTempLabel();
        createClearTempButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        $JDialog0.getContentPane().setLayout(new javax.swing.BoxLayout(this.getContentPane(), javax.swing.BoxLayout.PAGE_AXIS));
        setResizable(false);
        setTitle(_("isisfish.simulator.ssh.configuration.title"));
        
        // fill default values
            getAction().resetSSHConfiguration();// registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_BUTTON_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                validButton.setEnabled(isConnected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isConnected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATUS_FREE_DATABASE_LABEL_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                statusFreeDatabaseLabel.setEnabled(isConnected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLEAR_DATABASE_BUTTON_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                clearDatabaseButton.setEnabled(isConnected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATUS_FREE_TEMP_LABEL_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                statusFreeTempLabel.setEnabled(isConnected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLEAR_TEMP_BUTTON_ENABLED, true ,"connected") {
        
            @Override
            public void processDataBinding() {
                clearTempButton.setEnabled(isConnected());
            }
        });
    }

}