/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity.domain;

import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixND;

/**
 * Domaine continu portant sur une matrice.
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 24 févr. 2009 $ By : $Author: chatellier $
 */
public class MatrixContinuousDomain extends ContinuousDomain {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2037768174807839046L;

    /**
     * Min/max type constructor.
     */
    public MatrixContinuousDomain() {
        super();
    }
    
    /**
     * Constructor with type.
     * 
     * @param percentageType if {@code true} percentage type
     */
    public MatrixContinuousDomain(boolean percentageType) {
        super(percentageType);
    }

    @Override
    public Object getValueForIdentifier(Object identifier) {
        return getValueForIdentifier((Double)identifier);
    }
    
    /**
     * In matrix continuous domain, return a new matrix.
     * 
     * @param identifier identifier
     * @return a new computed matrix
     */
    public MatrixND getValueForIdentifier(final Double identifier) {
        MatrixND temp = ((MatrixND)getReferenceValue()).copy();
        
        // since 3.4.0.0, operator is always *
        temp.map(new MapFunction() {
            public double apply(double val) {
                return (val + ((val * coefficient) * ((2 * identifier - 1))));
            }
        });
        return temp;
    }

    @Override
    public MatrixContinuousDomain clone() {
        MatrixContinuousDomain cloned = (MatrixContinuousDomain)super.clone();
        return cloned;
    }

    /**
     * {@inheritDoc}
     * 
     * @return the minimum bound
     */
    public Object getMinBound() {

        if (minBound == null) {
            MatrixND temp = ((MatrixND) getReferenceValue()).copy();

            // since 3.4.0.0, operator is always *
            temp.map(new MapFunction() {
                public double apply(double val) {
                    return (val + ((val * coefficient) * ((2 * getCalculatorMinBound() - 1))));
                }
            });
            return temp;
        } else {
            return minBound;
        }
    }

    /**
     * {@inheritDoc}
     * 
     * @return the maximum bound
     */
    public Object getMaxBound() {

        if (maxBound == null) {
            MatrixND temp = ((MatrixND) getReferenceValue()).copy();

            // since 3.4.0.0, operator is always *
            temp.map(new MapFunction() {
                public double apply(double val) {
                    return (val + ((val * coefficient) * ((2 * getCalculatorMaxBound() - 1))));
                }
            });
            return temp;
        } else {
            return maxBound;
        }
    }
}
