/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity.domain;

/**
 * Domaine continu portant sur variable pouvant prendre diférente valeur par
 * rapport à une valeur initiale.
 * 
 * Composé d'un borne min et max et d'un opération.
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 24 févr. 2009 $ By : $Author: chatellier $
 */
public class EquationContinuousDomain extends ContinuousDomain {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2037768174807839046L;

    /** Variable name (must be java valid identifier) */
    protected String variableName;

    /**
     * Min/max type constructor.
     */
    public EquationContinuousDomain() {
        super();
    }
    
    /**
     * Constructor with type.
     * 
     * @param percentageType if {@code true} percentage type
     */
    public EquationContinuousDomain(boolean percentageType) {
        super(percentageType);
    }

    /**
     * Get variable name.
     * 
     * @return the variableName
     */
    public String getVariableName() {
        return variableName;
    }

    /**
     * Set variable name.
     * 
     * @param variableName the variableName to set
     */
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
    
    @Override
    public EquationContinuousDomain clone() {
        EquationContinuousDomain cloned = (EquationContinuousDomain)super.clone();
        cloned.setMaxBound(this.maxBound);
        cloned.setMinBound(this.minBound);
        cloned.setCoefficient(this.coefficient);
        cloned.setReferenceValue(this.referenceValue);
        cloned.setVariableName(this.variableName);
        return cloned;
    }
    
    @Override
    public String toString() {
        String result = "variableName=" + variableName +
                " coefficient=" + coefficient + " referenceValue=" + referenceValue +
                " min=" + minBound + "max=" + maxBound;
        return result;
    }
}
