/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;

/**
 * XML domain visitor for Equation Continous Domain.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 30 mars 2009 $
 * By : $Author: chatellier $
 */
public class EquationContinuousDomainXMLVisitor extends ContinuousDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        xmlBuffer.append("<domain>");
        xmlBuffer.append("<fixed");

        EquationContinuousDomain eDomain = (EquationContinuousDomain)domain;
        // this version add variable name
        xmlBuffer.append(" variable=\"")
                 .append(eDomain.getVariableName())
                 .append("\">");

        appendDomain(eDomain);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void appendDomain(ContinuousDomain domain) {

        EquationContinuousDomain eDomain = (EquationContinuousDomain)domain;

        // facteur continue pourcentage
        if (domain.isPercentageType()) {
            xmlBuffer.append("<reference coefficient=\"")
                     .append(eDomain.getCoefficient())
                     .append( "\">");
            xmlBuffer.append(eDomain.getReferenceValue());
            xmlBuffer.append("</reference>");
        }
        else {
            // facteur continue min/max
            xmlBuffer.append("<range>");
            xmlBuffer.append("<min>")
                     .append(domain.getMinBound())
                     .append("</min>");
            xmlBuffer.append("<max>")
                     .append(domain.getMaxBound())
                     .append("</max>");
            xmlBuffer.append("</range>");
        }
    }
}
