/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;

/**
 * XML continuous domain visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class ContinuousDomainXMLVisitor extends DomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void start(Domain domain) {
        xmlBuffer.append("<domain>");
        xmlBuffer.append("<fixed>");

        ContinuousDomain cDomain = (ContinuousDomain)domain;
        appendDomain(cDomain);
    }

    /**
     * Default ContinuousDomain implementation for double.
     * Maybe overridden by specific continuous domains.
     * 
     * @param domain domain to print
     */
    protected void appendDomain(ContinuousDomain domain) {
        // facteur continue pourcentage
        if (domain.isPercentageType()) {
            xmlBuffer.append("<reference coefficient=\"" + domain.getCoefficient() + "\">");
            xmlBuffer.append(domain.getReferenceValue());
            xmlBuffer.append("</reference>");
        }
        else {
            // facteur continue min/max
            xmlBuffer.append("<range>");
            xmlBuffer.append("<min>" + domain.getMinBound() + "</min>");
            xmlBuffer.append("<max>" + domain.getMaxBound() + "</max>");
            xmlBuffer.append("</range>");
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(Domain domain, Object label, Object value) {

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void end(Domain domain) {
        xmlBuffer.append("</fixed>");
        xmlBuffer.append("</domain>");
    }
}
