/*
 * #%L
 * IsisFish
 * 
 * $Id: VariableEquation.java 3671 2012-04-03 13:31:36Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.2/src/main/java/fr/ifremer/isisfish/equation/VariableEquation.java $
 * %%
 * Copyright (C) 2012 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Args;

/**
 * Generic equation signature used in variable values.
 * 
 * @author chatellier
 * @version $Revision: 3671 $
 * 
 * Last update : $Date: 2012-04-03 15:31:36 +0200 (Tue, 03 Apr 2012) $
 * By : $Author: echatellier $
 */
public interface VariableEquation {

    /**
     * Compute target factor.
     * 
     * @param context simulation context
     * @param entity l'entity sur laquelle la variable a été ajoutée
     * @param step le pas de temps courant
     * @return equation result
     * @throws Exception 
     */
    @Args({"context", "entity", "step"})
    public double compute(SimulationContext context, TopiaEntity entity, TimeStep step) throws Exception;
}
