/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface Zone extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_CELL = "cell";

    void setName(String name);

    String getName();

    void setComment(String comment);

    String getComment();

    void addCell(Cell cell);

    void addAllCell(List<Cell> cell);

    void setCell(List<Cell> cell);

    void removeCell(Cell cell);

    void clearCell();

    List<Cell> getCell();

    Cell getCellByTopiaId(String topiaId);

    int sizeCell();

    boolean isCellEmpty();

    FisheryRegion getFisheryRegion();

} //Zone
