/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SetOfVesselsDAOAbstract<E extends SetOfVessels> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SetOfVessels.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.SetOfVessels;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Strategy> list = getContext()
                                                    .getDAO(Strategy.class)
                                                    .findAllByProperties(Strategy.PROPERTY_SET_OF_VESSELS, entity);
                                            for (Strategy item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSetOfVessels())) {
                                                    item.setSetOfVessels(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_NAME, v);
        return result;
    }

    public E findByNumberOfVessels(int v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_NUMBER_OF_VESSELS, v);
        return result;
    }

    public List<E> findAllByNumberOfVessels(int v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_NUMBER_OF_VESSELS, v);
        return result;
    }

    public E findByFixedCosts(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_FIXED_COSTS, v);
        return result;
    }

    public List<E> findAllByFixedCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_FIXED_COSTS, v);
        return result;
    }

    public E findByVesselCosts(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_VESSEL_COSTS, v);
        return result;
    }

    public List<E> findAllByVesselCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_VESSEL_COSTS, v);
        return result;
    }

    public E findByCapitalDeprecation(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_CAPITAL_DEPRECATION, v);
        return result;
    }

    public List<E> findAllByCapitalDeprecation(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_CAPITAL_DEPRECATION, v);
        return result;
    }

    public E findByInterestCost(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_INTEREST_COST, v);
        return result;
    }

    public List<E> findAllByInterestCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_INTEREST_COST, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, v);
        return result;
    }

    public List<E> findAllByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, v);
        return result;
    }

    public E findByPort(Port v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_PORT, v);
        return result;
    }

    public List<E> findAllByPort(Port v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_PORT, v);
        return result;
    }

    public E findByVesselType(VesselType v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PROPERTY_VESSEL_TYPE, v);
        return result;
    }

    public List<E> findAllByVesselType(VesselType v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PROPERTY_VESSEL_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllBySetOfVessels(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        return result;
    }

} //SetOfVesselsDAOAbstract<E extends SetOfVessels>
