/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import fr.ifremer.echobase.entities.ImportFile;
import fr.ifremer.echobase.io.EchoBaseIOUtil;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.InputStream;
import java.net.URLDecoder;
import java.sql.Blob;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;

public abstract class DownloadFileSupport
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String importFileId;
    protected String filename;
    protected transient InputStream inputStream;
    protected long contentLength;
    protected String contentType;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;

    public void setImportFileId(String importFileId) {
        this.importFileId = importFileId;
    }

    public String getImportFileId() {
        return this.importFileId;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected abstract Blob getFile(ImportFile var1);

    protected abstract String getFilename(ImportFile var1);

    public String execute() throws Exception {
        String id = URLDecoder.decode(this.importFileId, "UTF-8");
        ImportFile importFile = this.userDbPersistenceService.getImportFile(id);
        this.filename = this.getFilename(importFile);
        this.contentType = "text/csv";
        Blob blob = this.getFile(importFile);
        this.contentLength = EchoBaseIOUtil.blobLength((Blob)blob);
        this.inputStream = new GZIPInputStream(blob.getBinaryStream(), 65535);
        return "success";
    }
}

