/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.service.importdata.CommonImportConfiguration;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigureCommonImport
extends AbstractConfigureImport<CommonImportConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureCommonImport.class);
    protected Map<String, String> missions;
    protected Map<String, String> voyages;
    protected Map<String, String> areaOfOperations;
    protected Map<String, String> importTypes;

    public ConfigureCommonImport() {
        super(CommonImportConfiguration.class);
    }

    protected CommonImportConfiguration createModel() {
        return new CommonImportConfiguration(this.getLocale());
    }

    protected void prepareInputAction(CommonImportConfiguration model) {
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
        this.voyages = this.userDbPersistenceService.loadSortAndDecorate(Voyage.class);
        this.areaOfOperations = this.userDbPersistenceService.loadSortAndDecorate(AreaOfOperation.class);
        this.importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.getCommonImportType());
        if (model.getImportType() == null) {
            model.setImportType(ImportType.COMMON_ALL);
        }
    }

    @InputConfig(methodName="input")
    public String modeAll() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeVoyage() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransit() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransect() throws Exception {
        return this.execute();
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return this.areaOfOperations;
    }

    public Map<String, String> getImportTypes() {
        return this.importTypes;
    }

    public CommonImportConfiguration getModelVoyage() {
        return (CommonImportConfiguration)this.getModel();
    }

    public void setModelVoyageVoyageFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setModelVoyageVoyageFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setModelVoyageVoyageFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public CommonImportConfiguration getModelTransit() {
        return (CommonImportConfiguration)this.getModel();
    }

    public void setModelTransitTransitFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setModelTransitTransitFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setModelTransitFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public CommonImportConfiguration getModelTransect() {
        return (CommonImportConfiguration)this.getModel();
    }

    public void setModelTransectTransectFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setModelTransectTransectFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setModelTransectTransectFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }

    public CommonImportConfiguration getModelAll() {
        return (CommonImportConfiguration)this.getModel();
    }

    public void setModelAllVoyageFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setModelAllVoyageFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setModelAllVoyageFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public void setModelAllTransitFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setModelAllTransitFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setModelAllTransitFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public void setModelAllTransectFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setModelAllTransectFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setModelAllTransectFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }
}

