/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportCoser;

import fr.ifremer.echobase.services.service.exportCoser.ExportCoserConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class Download
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected transient InputStream inputStream;
    protected String fileName;
    protected long contentLength;
    protected String contentType;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String execute() throws Exception {
        ExportCoserConfiguration model = (ExportCoserConfiguration)this.getEchoBaseSession().getActionConfiguration(ExportCoserConfiguration.class);
        if (model == null) {
            this.addFlashError(this.t("echobase.error.no.exportCoser.configurationFound", new Object[0]));
            return "error";
        }
        File exportFile = model.getExportFile();
        if (exportFile == null) {
            this.addFlashError(this.t("echobase.error.no.exportCoser.exportFileFound", new Object[0]));
            return "error";
        }
        this.fileName = exportFile.getName();
        this.contentType = "application/zip";
        this.contentLength = exportFile.length();
        this.inputStream = new BufferedInputStream(new FileInputStream(exportFile));
        return "success";
    }
}

