/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import fr.ifremer.echobase.entities.ImportFile;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.InputStream;
import java.net.URLDecoder;
import java.sql.Blob;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

public class DownloadImportFile
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String importFileId;
    protected String filename;
    protected transient InputStream inputStream;
    protected long contentLength;
    protected String contentType;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;

    public void setImportFileId(String importFileId) {
        this.importFileId = importFileId;
    }

    public String getImportFileId() {
        return this.importFileId;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String execute() throws Exception {
        byte[] bytes;
        String id = URLDecoder.decode(this.importFileId, "UTF-8");
        ImportFile importFile = this.userDbPersistenceService.getImportFile(id);
        this.filename = importFile.getName();
        this.contentType = "application/text";
        Blob file = importFile.getFile();
        try (InputStream binaryStream = file.getBinaryStream();){
            bytes = IOUtils.toString((InputStream)new GZIPInputStream(binaryStream)).getBytes();
        }
        this.contentLength = bytes.length;
        this.inputStream = new GZIPInputStream(file.getBinaryStream(), 65535);
        return "success";
    }
}

