/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.user.LoginAction;
import fr.ifremer.echobase.ui.interceptors.AbstractCheckInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckLogguedInterceptor
extends AbstractCheckInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CheckLogguedInterceptor.class);
    protected String loginAction;
    protected static final String URL_PATTERN = "%s?redirectAction=%s";

    public void setLoginAction(String loginAction) {
        this.loginAction = loginAction;
    }

    protected boolean doCheck(ActionInvocation invocation) {
        boolean userLoggued;
        EchoBaseActionSupport action = (EchoBaseActionSupport)invocation.getAction();
        EchoBaseSession echoBaseSession = action.getEchoBaseSession();
        boolean bl = userLoggued = echoBaseSession.getEchoBaseUser() != null;
        if (!userLoggued) {
            boolean autoLogin = EchoBaseActionSupport.getEchoBaseApplicationContext().getConfiguration().getOptionAsBoolean("autoLogin");
            if (autoLogin) {
                block6: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"AutotLogin with admin/admin user");
                    }
                    LoginAction logAction = new LoginAction();
                    logAction.setSession(invocation.getInvocationContext().getSession());
                    logAction.setEmail("admin");
                    logAction.setPassword("admin");
                    try {
                        logAction.doLogin();
                    }
                    catch (Exception eee) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Could not auto-login", (Throwable)eee);
                    }
                }
                return true;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"No user loggued!");
            }
        }
        return userLoggued;
    }

    protected String getRedirectUrl() {
        String url = String.format(URL_PATTERN, this.loginAction, this.redirectAction);
        return url;
    }
}

