/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Delete
extends EchoBaseActionSupport
implements Preparable {
    protected static final Log log = LogFactory.getLog(Delete.class);
    private static final long serialVersionUID = 1L;
    protected transient UserService userService;
    protected EchoBaseUser user;

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    public String execute() throws Exception {
        EchoBaseUser userToDelete = this.getUser();
        String userEmail = userToDelete.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will delete user  " + userEmail));
        }
        this.getUserService().delete(userToDelete);
        this.addActionMessage(this._("echobase.info.user.delete", new Object[]{userEmail}));
        return "success";
    }

    public EchoBaseUser getUser() {
        if (this.user == null) {
            this.user = this.getUserService().newUser();
        }
        return this.user;
    }

    public void prepare() throws Exception {
        String userId = this.getUser().getTopiaId();
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            this.user = (EchoBaseUser)this.getUserService().getEntityById(EchoBaseUser.class, userId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected user " + this.user.getEmail()));
            }
        }
    }
}

