/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Create
extends EchoBaseActionSupport {
    protected static final Log log = LogFactory.getLog(Create.class);
    private static final long serialVersionUID = 1L;
    protected transient UserService userService;
    protected EchoBaseUser user;

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    public String execute() throws Exception {
        EchoBaseUser userToCreate = this.getUser();
        String userEmail = userToCreate.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will create user  " + userEmail));
        }
        this.getUserService().createOrUpdate(userToCreate);
        this.addActionMessage(this._("echobase.info.user.create", new Object[]{userEmail}));
        return "success";
    }

    public void validate() {
        EchoBaseUser userToValidate = this.getUser();
        String userEmail = userToValidate.getEmail();
        if (StringUtils.isEmpty((CharSequence)userEmail)) {
            this.addFieldError("user.email", this._("echobase.error.required.email", new Object[0]));
        } else {
            EchoBaseUser login;
            try {
                login = this.getUserService().getUserByEmail(userEmail);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not obtain user " + userEmail, e);
            }
            if (login != null) {
                this.addFieldError("user.email", this._("echobase.error.email.already.used", new Object[0]));
            }
        }
        String userPassword = userToValidate.getPassword();
        if (StringUtils.isEmpty((CharSequence)userPassword)) {
            this.addFieldError("user.password", this._("echobase.error.required.password", new Object[0]));
        }
    }

    public EchoBaseUser getUser() {
        if (this.user == null) {
            this.user = this.getUserService().newUser();
        }
        return this.user;
    }
}

