/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.embeddedApplication;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.EmbeddedApplicationConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;

public class Configure
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected EmbeddedApplicationConfiguration model;
    protected Map<String, String> voyages;

    public EmbeddedApplicationConfiguration getModel() {
        if (this.model == null) {
            this.model = new EmbeddedApplicationConfiguration();
        }
        return this.model;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public String input() throws Exception {
        this.getEchoBaseSession().setExportDbConfiguration(null);
        EmbeddedApplicationConfiguration actionModel = this.getModel();
        EchoBaseConfiguration configuration = this.getConfiguration();
        Version version = configuration.getApplicationVersion();
        String fileName = "echobase-embedded-" + version.toString();
        actionModel.setFileName(fileName);
        File warLocation = configuration.getWarLocation();
        if (!warLocation.exists()) {
            this.addActionError(this._("echobase.error.warlocation.notFound", new Object[]{warLocation}));
        }
        actionModel.setWarLocation(warLocation);
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        List allVoyages = service.getEntities(Voyage.class);
        if (CollectionUtils.isEmpty((Collection)allVoyages)) {
            this.addActionMessage(this._("echobase.info.no.voyagee.found", new Object[0]));
        }
        this.voyages = this.sortAndDecorate((Collection)allVoyages, null);
        return "input";
    }

    public String execute() throws Exception {
        EmbeddedApplicationConfiguration configuration = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-embeddedApplication-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        configuration.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        File warLocation = this.getConfiguration().getWarLocation();
        configuration.setWarLocation(warLocation);
        this.getEchoBaseSession().setEmbeddedApplicationConfiguration(configuration);
        return "success";
    }
}

