/*
 * #%L
 * $Id: PerformLoginAction.java 931 2011-12-23 15:13:08Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/admin/PerformLoginAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.admin;

import java.util.Map;

import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.SessionAware;
import org.nuiton.util.StringUtil;

import fr.ifremer.coser.web.CoserWebConfig;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Perform login action.
 * 
 * @author chatellier
 * @version $Revision: 931 $
 * 
 * Last update : $Date: 2011-12-23 16:13:08 +0100 (Fri, 23 Dec 2011) $
 * By : $Author: echatellier $
 */
@Result(name="success", type="redirect", location="index")
public class PerformLoginAction extends CoserAction implements SessionAware {  

    /** serialVersionUID. */
    private static final long serialVersionUID = -1576602720835497842L;

    protected String login;

    protected String password;

    private Map<String, Object> session;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * @see org.apache.struts2.interceptor.SessionAware#setSession(java.util.Map)
     */
    @Override
    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    @Override
    public String execute() throws Exception {   
        CoserWebConfig config = ServiceFactory.getCoserConfig();
        if (config.getAdminLogin().equals(login) && equalsSHA1Password(config, password)) {
            session.put("login", login);
            return SUCCESS;
        } else {
            addActionError("Invalid login/password");
            return INPUT;
        }
    }

    /**
     * Check if sha1 password equals to config password.
     * 
     * Config password can be plain or sha1 encoded.
     * 
     * @param config config
     * @param password password to check
     * @return equality
     */
    protected boolean equalsSHA1Password(CoserWebConfig config, String password) {
        
        // first test sha1 equality
        String configSha1Password = config.getAdminPassword();
        String sha1Password = StringUtil.encodeSHA1(password);
        boolean result = configSha1Password.equals(sha1Password);
        
        // second test to encode sha1 of plain password
        if (!result) {
            configSha1Password = StringUtil.encodeSHA1(configSha1Password);
            result = configSha1Password.equals(sha1Password);
        }
        
        return result;
    }
    
}  
