/*
 * #%L
 * $Id: ListProjectsAction.java 931 2011-12-23 15:13:08Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/admin/ListProjectsAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.admin;

import java.util.List;
import java.util.Map;

import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.ParentPackage;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Project list action.
 * 
 * @author chatellier
 * @version $Revision: 931 $
 * 
 * Last update : $Date: 2011-12-23 16:13:08 +0100 (Fri, 23 Dec 2011) $
 * By : $Author: echatellier $
 */
@ParentPackage("admin")
@InterceptorRefs({
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("defaultStack")
})
public class ListProjectsAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6024588562104111883L;

    protected Map<String, String> facades;
    protected Map<String, List<String>> zonesByFacades;

    protected Map<String, String> indicatorsResults;
    protected Map<String, String> mapsResults;

    public Map<String, String> getFacades() {
        return facades;
    }

    public Map<String, List<String>> getZonesByFacades() {
        return zonesByFacades;
    }

    public Map<String, String> getIndicatorsResults() {
        return indicatorsResults;
    }

    public Map<String, String> getMapsResults() {
        return mapsResults;
    }

    public String getZoneDisplayName(String zoneId) {
        WebService webService = ServiceFactory.getWebService();
        String zoneDisplayName = null;
        try {
            zoneDisplayName = webService.getZoneFullName(zoneId);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone name", ex);
        }
        return zoneDisplayName;
    }

    public String execute() {
        WebService webService = ServiceFactory.getWebService();

        try {
            facades = webService.getFacades();
            zonesByFacades = webService.getZoneByFacade();
            indicatorsResults = webService.getIndicatorsResultsPerZone();
            mapsResults = webService.getMapsResultsPerZone();
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get data from web service", ex);
        }

        return SUCCESS;
    }
}
