/*
 * #%L
 * $Id: SourceAction.java 797 2011-03-24 15:45:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/source/SourceAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.source;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Affiche les liens de téléchargement du zip pour le projet choisit.
 * 
 * @author chatellier
 * @version $Revision: 797 $
 * 
 * Last update : $Date: 2011-03-24 16:45:33 +0100 (Thu, 24 Mar 2011) $
 * By : $Author: chatellier $
 */
public class SourceAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected String facade;

    protected String zone;

    protected String zonePicture;

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getZonePicture() {
        return zonePicture;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getZoneForFacade(facade, false, false).get(zone);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        try {
            zonePicture = webService.getZonePictures().get(zone);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone picture", ex);
        }

        return SUCCESS;
    }
}
