/*
 * #%L
 * $Id: SpeciesAction.java 668 2011-02-04 10:47:43Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/pop/SpeciesAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.pop;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Action index, recupere la liste des resultats.
 * 
 * @author chatellier
 * @version $Revision: 668 $
 * 
 * Last update : $Date: 2011-02-04 11:47:43 +0100 (ven., 04 févr. 2011) $
 * By : $Author: chatellier $
 */
public class SpeciesAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    private static final Log log = LogFactory.getLog(SpeciesAction.class);

    protected String facade;

    protected String zone;

    protected Map<String, String> species;

    protected String zonePicture;

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Map<String, String> getSpecies() {
        return species;
    }

    public String getZonePicture() {
        return zonePicture;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getZoneForFacade(facade, false).get(zone);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {

        if (log.isInfoEnabled()) {
            log.info("Looking for species for zone " + zone);
        }

        WebService webService = ServiceFactory.getWebService();

        try {
            species = webService.getSpecies(zone);

            zonePicture = webService.getZonePictures().get(zone);

            if (log.isDebugEnabled()) {
                log.debug("Species are : " + species);
            }
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone species", ex);
        }

        return SUCCESS;
    }
}
