/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.util.io;

import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.bean.EchoBaseProject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class OneEchobaseFileFilter
implements FileFilter {
    protected final String basedir;
    protected final boolean publishData;
    protected final String rawDataBasedir;

    public OneEchobaseFileFilter(EchoBaseProject project, boolean publishData) {
        this.publishData = publishData;
        try {
            this.basedir = project.getBasedir().getCanonicalPath();
            this.rawDataBasedir = project.getRawDataDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not get canonical path", e);
        }
    }

    @Override
    public boolean accept(File pathname) {
        try {
            String currentPathName = pathname.getCanonicalPath();
            boolean result = currentPathName.startsWith(this.basedir);
            if (result && !this.publishData) {
                result = !currentPathName.startsWith(this.rawDataBasedir);
            }
            return result;
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not get canonical path", e);
        }
    }
}

