/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserApplicationContext;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.result.CoserMainRepositoryProvider;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.CoserRequestBuilder;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.CoserRequestExecutor;
import fr.ifremer.coser.result.DefaultCoserRequestContext;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.ResultRepositoryProvider;
import fr.ifremer.coser.result.repository.ResultRepositoryType;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepositoryProvider;
import fr.ifremer.coser.result.repository.legacy.LegacyResultRepositoryProvider;
import fr.ifremer.coser.result.request.CopyRepositoryRequest;
import fr.ifremer.coser.result.request.DeleteResultsRequest;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.request.GetResultNameRequest;
import fr.ifremer.coser.result.result.ExtractRawDataAndResultsResult;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.util.Extracts;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.util.DataType;
import fr.ifremer.coser.util.io.MultipleFileFilter;
import fr.ifremer.coser.util.io.OneRSufiResultFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class WebResultService {
    private static final Log log = LogFactory.getLog(WebResultService.class);
    protected final CoserApplicationContext applicationContext;

    public WebResultService(CoserApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public CoserRequestContext newRequestContext(Locale locale) {
        return new DefaultCoserRequestContext(this.applicationContext, locale);
    }

    public CoserRequestExecutor executeUnique(CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = this.executeUnique(this.getInternalRepositoryProvider(), context, request);
        return executor;
    }

    public CoserRequestExecutor executeFirst(CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = this.executeFirst(this.getInternalRepositoryProvider(), context, request);
        return executor;
    }

    public CoserRequestExecutor executeAll(CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = this.executeAll(this.getInternalRepositoryProvider(), context, request);
        return executor;
    }

    public FileResult extractRawDataAndResults(CoserRequestContext context, ExtractRawDataAndResultsRequest request) {
        File extractDirectory = new File(context.getTemporaryDirectory(), "Indicateurs_Ifremer");
        request.setExtractDirectory(extractDirectory);
        try {
            FileUtils.forceMkdir((File)extractDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not create directory: " + extractDirectory, e);
        }
        List<ExtractRawDataAndResultsResult> multipleResults = this.executeAll(this.getInternalRepositoryProvider(), context, request).toMultipleResult(ExtractRawDataAndResultsResult.class);
        File file = this.getExtracts().assemblyExtractResult(context, extractDirectory, request.getZoneList(), multipleResults);
        FileResult result = new FileResult("ALL", file);
        return result;
    }

    public void deleteResults(CoserRequestContext context, DeleteResultsRequest request) {
        this.executeAll(this.getInternalRepositoryProvider(), context, request);
        this.getInternalRepositoryProvider().resetRepositories();
    }

    public void resetRepositories() {
        this.applicationContext.getRepositoryProvider().resetRepositories();
    }

    public Map<String, ResultRepositoryType> getRepositoryTypes() {
        HashMap result = Maps.newHashMap();
        for (ResultRepositoryType resultRepositoryType : this.applicationContext.getRepositoryTypes()) {
            result.put(resultRepositoryType.getId(), resultRepositoryType);
        }
        return result;
    }

    public void registerNewUploadedResults(CoserRequestContext context, String login, File archiveFile) {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"coser-upload-", (String)"-tmp");
            ZipUtil.uncompress((File)archiveFile, (File)tempDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't uncompress archive", e);
        }
        NewUploadContext uploadContext = new NewUploadContext(context);
        GetResultNameRequest indicatorsRequest = this.requestBuilder(context, GetResultNameRequest.class).addExtractTypeList(Lists.newArrayList((Object[])new DataType[]{DataType.COMMUNITY, DataType.POPULATION})).toRequest();
        GetResultNameRequest mapsRequest = this.requestBuilder(context, GetResultNameRequest.class).addExtractTypeList(Lists.newArrayList((Object[])new DataType[]{DataType.MAP})).toRequest();
        GetResultNameRequest rawDataRequest = this.requestBuilder(context, GetResultNameRequest.class).addExtractTypeList(Lists.newArrayList((Object[])new DataType[]{DataType.SOURCE})).toRequest();
        Map<String, String> indicatorResults = this.executeAll(this.getInternalRepositoryProvider(), context, indicatorsRequest).toMap();
        Map<String, String> mapsResults = this.executeAll(this.getInternalRepositoryProvider(), context, mapsRequest).toMap();
        Map<String, String> dataResults = this.executeAll(this.getInternalRepositoryProvider(), context, rawDataRequest).toMap();
        uploadContext.indicatorResults.putAll(indicatorResults);
        uploadContext.mapsResults.putAll(mapsResults);
        uploadContext.dataResults.putAll(dataResults);
        File rsufiDirectory = new File(tempDirectory, "rsufi");
        try {
            this.registerNewUploadedResultsForRSufi(uploadContext, rsufiDirectory, indicatorsRequest, mapsRequest, rawDataRequest);
        }
        catch (CoserBusinessException e) {
            throw new CoserTechnicalException("Could not merge rsufi results", e);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not merge rsufi results", e);
        }
        File echobaseDirectory = new File(tempDirectory, "echobase");
        this.registerNewUploadedResultsForEchoBase(uploadContext, echobaseDirectory, indicatorsRequest, mapsRequest, rawDataRequest);
        this.getConfig().updateDataProperties();
        this.applicationContext.getRepositoryProvider().resetRepositories();
        this.generatedAndSendNewResultNotifications(login, uploadContext);
        try {
            FileUtils.deleteDirectory((File)tempDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't delete directory", e);
        }
    }

    protected void registerNewUploadedResultsForEchoBase(NewUploadContext uploadContext, File basedir, GetResultNameRequest indicatorsRequest, GetResultNameRequest mapsRequest, GetResultNameRequest rawDataRequest) {
        EchoBaseResultRepositoryProvider provider = new EchoBaseResultRepositoryProvider(basedir);
        CoserMainRepositoryProvider mainRepositoryProvider = new CoserMainRepositoryProvider(Sets.newHashSet((Object[])new ResultRepositoryProvider[]{provider}));
        if (CollectionUtils.isEmpty(mainRepositoryProvider.getResultRepositories())) {
            return;
        }
        CoserRequestContext context = uploadContext.context;
        Map<String, String> indicatorsResultZoneIds = this.executeAll(mainRepositoryProvider, context, indicatorsRequest).toMap();
        Map<String, String> mapsResultZoneIds = this.executeAll(mainRepositoryProvider, context, mapsRequest).toMap();
        Map<String, String> dataResultZoneIds = this.executeAll(mainRepositoryProvider, context, rawDataRequest).toMap();
        HashSet existingZones = Sets.newHashSet();
        existingZones.addAll(uploadContext.indicatorResults.keySet());
        existingZones.addAll(uploadContext.mapsResults.keySet());
        existingZones.addAll(uploadContext.dataResults.keySet());
        HashSet zonesToImport = Sets.newHashSet();
        zonesToImport.addAll(indicatorsResultZoneIds.keySet());
        zonesToImport.addAll(mapsResultZoneIds.keySet());
        zonesToImport.addAll(dataResultZoneIds.keySet());
        ArrayList zonesToDelete = Lists.newArrayList((Iterable)zonesToImport);
        zonesToDelete.retainAll(existingZones);
        if (CollectionUtils.isNotEmpty((Collection)zonesToDelete)) {
            DeleteResultsRequest deleteRequest = this.requestBuilder(context, DeleteResultsRequest.class).addZoneList(zonesToDelete).addResultType(ResultType.MAP_AND_INDICATOR).addRepositoryType("echobase").toRequest();
            this.executeAll(mainRepositoryProvider, context, deleteRequest);
        }
        if (CollectionUtils.isNotEmpty((Collection)zonesToImport)) {
            CopyRepositoryRequest addRequest = this.requestBuilder(context, CopyRepositoryRequest.class).addZoneList(Lists.newArrayList((Iterable)zonesToImport)).addTargetDirectory(this.getConfig().getWebEchobaseProjectsDirectory()).toRequest();
            this.executeAll(mainRepositoryProvider, context, addRequest);
        }
        uploadContext.indicatorsResultZoneIds.putAll(indicatorsResultZoneIds);
        uploadContext.mapsResultZoneIds.putAll(mapsResultZoneIds);
        uploadContext.dataResultZoneIds.putAll(dataResultZoneIds);
    }

    protected void registerNewUploadedResultsForRSufi(NewUploadContext uploadContext, File tempDirectory, GetResultNameRequest indicatorsRequest, GetResultNameRequest mapsRequest, GetResultNameRequest rawDataRequest) throws CoserBusinessException, IOException {
        LegacyResultRepositoryProvider provider = new LegacyResultRepositoryProvider(this.getConfig(), tempDirectory, null);
        CoserMainRepositoryProvider mainRepositoryProvider = new CoserMainRepositoryProvider(Sets.newHashSet((Object[])new ResultRepositoryProvider[]{provider}));
        if (CollectionUtils.isEmpty(mainRepositoryProvider.getResultRepositories())) {
            return;
        }
        ProjectService projectService = new ProjectService(this.getConfig());
        File projectsDirectory = this.getConfig().getWebIndicatorsProjectsDirectory();
        File mapsDirectory = this.getConfig().getWebMapsProjectsDirectory();
        CoserRequestContext context = uploadContext.context;
        Map<String, String> noIndicatorsResultZoneIds = this.getZonesIds(projectService, tempDirectory, false, null, null);
        this.cleanCurrentProjectDirectory(projectService, projectsDirectory, noIndicatorsResultZoneIds.keySet());
        Map<String, String> noMapsResultZoneIds = this.getZonesIds(projectService, tempDirectory, null, false, null);
        this.cleanCurrentProjectDirectory(projectService, mapsDirectory, noMapsResultZoneIds.keySet());
        Map<String, String> noDataResultZoneIds = this.getZonesIds(projectService, tempDirectory, null, null, false);
        Map<String, String> indicatorsResultZoneIds = this.executeAll(mainRepositoryProvider, context, indicatorsRequest).toMap();
        Map<String, String> mapsResultZoneIds = this.executeAll(mainRepositoryProvider, context, mapsRequest).toMap();
        Map<String, String> dataResultZoneIds = this.executeAll(mainRepositoryProvider, context, rawDataRequest).toMap();
        this.cleanCurrentProjectDirectory(projectService, projectsDirectory, indicatorsResultZoneIds.keySet());
        this.cleanCurrentProjectDirectory(projectService, mapsDirectory, mapsResultZoneIds.keySet());
        FileFilter indicatorsFileFilter = this.getCopyFileFilter(projectService, tempDirectory, false);
        CoserUtils.customCopyDirectory(tempDirectory, projectsDirectory, indicatorsFileFilter);
        FileFilter mapsFileFilter = this.getCopyFileFilter(projectService, tempDirectory, true);
        CoserUtils.customCopyDirectory(tempDirectory, mapsDirectory, mapsFileFilter);
        uploadContext.noIndicatorsResultZoneIds.putAll(noIndicatorsResultZoneIds);
        uploadContext.noMapsResultZoneIds.putAll(noMapsResultZoneIds);
        uploadContext.noDataResultZoneIds.putAll(noDataResultZoneIds);
        uploadContext.indicatorsResultZoneIds.putAll(indicatorsResultZoneIds);
        uploadContext.mapsResultZoneIds.putAll(mapsResultZoneIds);
        uploadContext.dataResultZoneIds.putAll(dataResultZoneIds);
    }

    protected void generatedAndSendNewResultNotifications(String login, NewUploadContext uploadContext) {
        StringBuilder content = new StringBuilder();
        ZoneMap zoneMap = this.getZoneMap();
        int count = 0;
        String endOfLine = "\n";
        content.append(I18n.t((String)"coser.business.notificationmail.mapsresults", (Object[])new Object[0])).append(endOfLine);
        for (Map.Entry<String, String> noMapsResultZoneId : uploadContext.noMapsResultZoneIds.entrySet()) {
            if (!uploadContext.mapsResults.containsValue(noMapsResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{zoneMap.getZoneFullName(noMapsResultZoneId.getKey()), noMapsResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        for (Map.Entry<String, String> mapsResultZoneId : uploadContext.mapsResultZoneIds.entrySet()) {
            if (uploadContext.mapsResults.containsValue(mapsResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{zoneMap.getZoneFullName(mapsResultZoneId.getKey()), mapsResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        content.append(endOfLine);
        content.append(I18n.t((String)"coser.business.notificationmail.indicatorsresults", (Object[])new Object[0])).append(endOfLine);
        for (Map.Entry<String, String> noIndicatorsResultZoneId : uploadContext.noIndicatorsResultZoneIds.entrySet()) {
            if (!uploadContext.indicatorResults.containsValue(noIndicatorsResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{zoneMap.getZoneFullName(noIndicatorsResultZoneId.getKey()), noIndicatorsResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        for (Map.Entry<String, String> indicatorsResultZoneId : uploadContext.indicatorsResultZoneIds.entrySet()) {
            if (uploadContext.indicatorResults.containsValue(indicatorsResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{zoneMap.getZoneFullName(indicatorsResultZoneId.getKey()), indicatorsResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        content.append(endOfLine);
        content.append(I18n.t((String)"coser.business.notificationmail.dataresults", (Object[])new Object[0])).append(endOfLine);
        for (Map.Entry<String, String> noDataResultZoneId : uploadContext.noDataResultZoneIds.entrySet()) {
            if (!uploadContext.dataResults.containsValue(noDataResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{zoneMap.getZoneFullName(noDataResultZoneId.getKey()), noDataResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        for (Map.Entry<String, String> dataResultZoneId : uploadContext.dataResultZoneIds.entrySet()) {
            if (uploadContext.dataResults.containsValue(dataResultZoneId.getValue())) continue;
            content.append(" - ").append(I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{zoneMap.getZoneFullName(dataResultZoneId.getKey()), dataResultZoneId.getValue()})).append(endOfLine);
            ++count;
        }
        content.append(endOfLine);
        this.sendNewResultNotifications(login, count, content.toString());
    }

    protected CoserRequestExecutor executeUnique(CoserMainRepositoryProvider repositoryProvider, CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = new CoserRequestExecutor(this.applicationContext, repositoryProvider);
        executor.executeUnique(context, request);
        return executor;
    }

    protected CoserRequestExecutor executeFirst(CoserMainRepositoryProvider repositoryProvider, CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = new CoserRequestExecutor(this.applicationContext, repositoryProvider);
        executor.executeFirst(context, request);
        List<ResultRepository> matchingRepositories = executor.getMatchingRepositories();
        if (matchingRepositories.size() > 1) {
            String message = "Found more than one matching repository: ";
            for (ResultRepository matchingRepository : matchingRepositories) {
                message = message + "\n\t" + matchingRepository.getProjectName();
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
        }
        return executor;
    }

    protected CoserRequestExecutor executeAll(CoserMainRepositoryProvider repositoryProvider, CoserRequestContext context, CoserRequest request) {
        CoserRequestExecutor executor = new CoserRequestExecutor(this.applicationContext, repositoryProvider);
        executor.executeAll(context, request);
        return executor;
    }

    protected <R extends CoserRequest> CoserRequestBuilder<R> requestBuilder(CoserRequestContext context, Class<R> requestType) {
        return CoserRequestBuilder.newBuilder(context.getLocale(), requestType);
    }

    protected CoserBusinessConfig getConfig() {
        return this.applicationContext.getConfig();
    }

    protected ZoneMap getZoneMap() {
        return this.applicationContext.getZoneMap();
    }

    protected Extracts getExtracts() {
        return this.applicationContext.getExtracts();
    }

    protected CoserMainRepositoryProvider getInternalRepositoryProvider() {
        return this.applicationContext.getRepositoryProvider();
    }

    protected void sendNewResultNotifications(String login, int count, String detail) {
        List<String> emails = this.getConfig().getNewResultNotificationList();
        for (String email : emails) {
            try {
                MultiPartEmail emailPart = new MultiPartEmail();
                emailPart.setHostName(this.getConfig().getSmtpHost());
                emailPart.addTo(email);
                emailPart.setFrom("noreply-coser@ifremer.fr", "Coser");
                emailPart.setSubject(I18n.t((String)"coser.business.notificationmail.subject", (Object[])new Object[]{count}));
                emailPart.setContent((Object)I18n.t((String)"coser.business.notificationmail.body", (Object[])new Object[]{login, detail}), "text/plain; charset=ISO-8859-9");
                emailPart.send();
            }
            catch (EmailException ex) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't send mail", (Throwable)ex);
            }
        }
    }

    protected void cleanCurrentProjectDirectory(ProjectService projectService, File projectsDirectory, Collection<String> newResultIds) throws CoserBusinessException {
        try {
            File[] projectFiles = projectsDirectory.listFiles();
            if (projectFiles != null) {
                for (File projectFile : projectFiles) {
                    if (!projectFile.isDirectory()) continue;
                    int projectSelectionCount = 0;
                    File selectionsDirectory = new File(projectFile, "selections");
                    File[] selectionFiles = selectionsDirectory.listFiles();
                    if (selectionFiles != null) {
                        for (File selectionFile : selectionFiles) {
                            if (!selectionFile.isDirectory()) continue;
                            int selectionResultCount = 0;
                            File resultsDirectory = new File(selectionFile, "results");
                            File[] resultFiles = resultsDirectory.listFiles();
                            if (resultFiles != null) {
                                for (File resultFile : resultFiles) {
                                    if (!resultFile.isDirectory()) continue;
                                    RSufiResult rsufiResult = projectService.getRSufiResult(resultFile);
                                    String resultResultId = rsufiResult.getZone();
                                    if (newResultIds.contains(resultResultId)) {
                                        FileUtils.deleteDirectory((File)resultFile);
                                        continue;
                                    }
                                    ++selectionResultCount;
                                }
                            }
                            if (selectionResultCount == 0) {
                                FileUtils.deleteDirectory((File)selectionFile);
                                continue;
                            }
                            ++projectSelectionCount;
                        }
                    }
                    if (projectSelectionCount != 0) continue;
                    FileUtils.deleteDirectory((File)projectFile);
                }
            }
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't delete directory", ex);
        }
    }

    protected FileFilter getCopyFileFilter(ProjectService projectService, File scanDirectory, boolean mapResults) throws CoserBusinessException {
        MultipleFileFilter aggregateFileFilter = new MultipleFileFilter();
        File[] projectFiles = scanDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = projectService.getRSufiResult(resultFile);
                        if ((!mapResults || !rsufiResult.isMapsResult()) && (mapResults || !rsufiResult.isIndicatorsResult())) continue;
                        Project p = new Project(projectFile.getName());
                        Selection s = new Selection(selectionFile.getName());
                        OneRSufiResultFileFilter resultFileFilter = new OneRSufiResultFileFilter(scanDirectory, p, s, rsufiResult, true);
                        aggregateFileFilter.add(resultFileFilter);
                    }
                }
            }
        }
        return aggregateFileFilter;
    }

    protected Map<String, String> getZonesIds(ProjectService projectService, File scanDirectory, Boolean indicatorResults, Boolean mapResults, Boolean dataResults) throws CoserBusinessException {
        HashMap<String, String> resultIds = new HashMap<String, String>();
        File[] projectFiles = scanDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        String resultResultId;
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = projectService.getRSufiResult(resultFile);
                        if (indicatorResults != null && rsufiResult.isIndicatorsResult() != indicatorResults.booleanValue() || mapResults != null && rsufiResult.isMapsResult() != mapResults.booleanValue() || dataResults != null && rsufiResult.isDataAllowed() != dataResults.booleanValue() || !StringUtils.isNotBlank((CharSequence)(resultResultId = rsufiResult.getZone()))) continue;
                        String resultPath = projectFile.getName() + "/" + selectionFile.getName() + "/" + resultFile.getName();
                        resultIds.put(resultResultId, resultPath);
                    }
                }
            }
        }
        return resultIds;
    }

    class NewUploadContext {
        final CoserRequestContext context;
        Map<String, String> indicatorResults = Maps.newHashMap();
        Map<String, String> mapsResults = Maps.newHashMap();
        Map<String, String> dataResults = Maps.newHashMap();
        Map<String, String> noIndicatorsResultZoneIds = Maps.newHashMap();
        Map<String, String> noMapsResultZoneIds = Maps.newHashMap();
        Map<String, String> noDataResultZoneIds = Maps.newHashMap();
        Map<String, String> indicatorsResultZoneIds = Maps.newHashMap();
        Map<String, String> mapsResultZoneIds = Maps.newHashMap();
        Map<String, String> dataResultZoneIds = Maps.newHashMap();

        NewUploadContext(CoserRequestContext context) {
            this.context = context;
        }
    }
}

