/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.data.AbstractDataEntity;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.MemoryDataStorage;
import fr.ifremer.coser.util.ProgressMonitor;
import fr.ifremer.coser.util.ProgressReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ArrayUtil;

public class CommonService {
    protected CoserBusinessConfig config;

    CommonService(CoserBusinessConfig config) {
        this.config = config;
    }

    public DataStorage loadCSVFile(Project project, CoserConstants.Category category, File file) throws CoserBusinessException {
        return this.loadCSVFile(project, category, file, null);
    }

    public DataStorage loadCSVFile(Project project, CoserConstants.Category category, File file, ProgressMonitor progress) throws CoserBusinessException {
        return this.loadCSVFile(project, category, file, null, false);
    }

    public DataStorage loadCSVFile(Project project, CoserConstants.Category category, File file, ProgressMonitor progress, boolean originalLoading) throws CoserBusinessException {
        MemoryDataStorage content = new MemoryDataStorage();
        CSVReader csvReader = null;
        try {
            String[] line;
            FileInputStream stream = new FileInputStream(file);
            Reader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            if (progress != null) {
                reader = new ProgressReader(reader, progress);
            }
            if ((line = (csvReader = new CSVReader(reader, ';')).readNext()) == null || line.length <= 1) {
                throw new CoserBusinessException(I18n.t((String)"Can't read file '%s'. Check CSV file separator", (Object[])new Object[]{file.getAbsolutePath()}));
            }
            if (originalLoading) {
                this.checkFileHeader(file, category, line);
                if (category.isDataCategory()) {
                    line = (String[])ArrayUtil.concat((Object[][])new Object[][]{{AbstractDataEntity.PROPERTY_LINE}, line});
                }
            }
            content.add(line);
            int lineIndex = 1;
            while ((line = csvReader.readNext()) != null) {
                if (line.length <= 1) continue;
                if (originalLoading && category.isDataCategory()) {
                    line = (String[])ArrayUtil.concat((Object[][])new Object[][]{{String.valueOf(lineIndex)}, line});
                    ++lineIndex;
                }
                content.add(line);
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvReader);
        return content;
    }

    protected void checkFileHeader(File file, CoserConstants.Category category, String[] line) throws CoserBusinessException {
        Object[] enHeaders = null;
        Object[] frHeaders = null;
        switch (category) {
            case CATCH: {
                enHeaders = Catch.EN_HEADERS;
                frHeaders = Catch.FR_HEADERS;
                break;
            }
            case HAUL: {
                enHeaders = Haul.EN_HEADERS;
                frHeaders = Haul.FR_HEADERS;
                break;
            }
            case LENGTH: {
                enHeaders = Length.EN_HEADERS;
                frHeaders = Length.FR_HEADERS;
                break;
            }
            case STRATA: {
                enHeaders = Strata.EN_HEADERS;
                frHeaders = Strata.FR_HEADERS;
                break;
            }
            case REFTAX_SPECIES: {
                enHeaders = Project.REFTAX_SPECIES_HEADER;
                break;
            }
            case TYPE_ESPECES: {
                enHeaders = Project.TYPE_ESPECE_HEADER;
            }
        }
        if (frHeaders != null) {
            if (!Arrays.equals(line, enHeaders) && !Arrays.equals(line, frHeaders)) {
                throw new CoserBusinessException(I18n.t((String)"Wrong header detected in file %s. Found : %s, expected %s or %s", (Object[])new Object[]{file.getName(), StringUtils.join((Object[])line, (String)", "), StringUtils.join((Object[])frHeaders, (String)", "), StringUtils.join((Object[])enHeaders, (String)", ")}));
            }
        } else if (!Arrays.equals(line, enHeaders)) {
            throw new CoserBusinessException(I18n.t((String)"Wrong header detected in file %s. Found : %s, expected %s", (Object[])new Object[]{file.getName(), StringUtils.join((Object[])line, (String)", "), StringUtils.join((Object[])enHeaders, (String)", ")}));
        }
    }

    public DataStorage getEmptyStorage(Project project, CoserConstants.Category category) {
        MemoryDataStorage dataStorage = new MemoryDataStorage();
        switch (category) {
            case CATCH: {
                dataStorage.add(Catch.EN_HEADERS);
                break;
            }
            case HAUL: {
                dataStorage.add(Haul.EN_HEADERS);
                break;
            }
            case LENGTH: {
                dataStorage.add(Length.EN_HEADERS);
                break;
            }
            case STRATA: {
                dataStorage.add(Strata.EN_HEADERS);
            }
        }
        return dataStorage;
    }

    public void storeData(DataStorage content, File file) throws CoserBusinessException {
        CSVWriter csvWriter = null;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            csvWriter = new CSVWriter((Writer)writer, ';');
            Iterator itContent = content.iterator();
            while (itContent.hasNext()) {
                csvWriter.writeNext((String[])itContent.next());
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save data", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvWriter);
    }

    public void storeDataWhithoutQuote(DataStorage content, File file, Map<String, String> refTaxSpecies, CoserConstants.Category category) throws CoserBusinessException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.storeDataWhithoutQuote(content, writer, refTaxSpecies, category);
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save data", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void storeDataWhithoutQuote(DataStorage content, Writer writer, Map<String, String> refTaxSpecies, CoserConstants.Category category) throws CoserBusinessException {
        try {
            for (String[] contentDatas : content) {
                for (int i = 1; i < contentDatas.length; ++i) {
                    if (i != 1) {
                        writer.write(59);
                    }
                    String contentData = contentDatas[i];
                    if ((category == CoserConstants.Category.CATCH && i == 4 || category == CoserConstants.Category.LENGTH && i == 4) && refTaxSpecies.containsKey(contentData)) {
                        contentData = refTaxSpecies.get(contentData);
                    }
                    if (contentData.indexOf(59) > -1) {
                        writer.write("\"" + contentData + "\"");
                        continue;
                    }
                    writer.write(contentData);
                }
                writer.write("\n");
            }
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't save data", ex);
        }
    }

    public Map<String, String[]> getOriginalFileContent(File file, Collection<String> lines) throws CoserBusinessException {
        HashMap<String, String[]> content = new HashMap<String, String[]>();
        CSVReader csvReader = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            csvReader = new CSVReader((Reader)reader, ';');
            String[] line = csvReader.readNext();
            int lineIndex = 1;
            while ((line = csvReader.readNext()) != null) {
                String stringLine = String.valueOf(lineIndex);
                if (lines.contains(stringLine)) {
                    content.put(stringLine, line);
                }
                ++lineIndex;
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvReader);
        return content;
    }

    public DataStorage loadCSVFile(File file) throws CoserBusinessException {
        return this.loadCSVFile(file, ';');
    }

    public DataStorage loadCSVFile(File file, char separator) throws CoserBusinessException {
        MemoryDataStorage content = new MemoryDataStorage();
        CSVReader csvReader = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            csvReader = new CSVReader((Reader)reader, separator);
            String[] line = csvReader.readNext();
            if (line == null || line.length <= 1) {
                throw new CoserBusinessException(I18n.t((String)"Can't read file '%s'. Check CSV file separator", (Object[])new Object[]{file.getAbsolutePath()}));
            }
            content.add(line);
            while ((line = csvReader.readNext()) != null) {
                if (line.length <= 1) continue;
                content.add(line);
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvReader);
        return content;
    }

    @Deprecated
    protected String getDataStorageFileName(Project project, CoserConstants.Category category, String suffix) {
        String result = project.getDataStorageFileName(category, suffix);
        return result;
    }

    public Map<String, String[]> getOriginalContent(Project project, CoserConstants.Category category, Collection<String> lines) throws CoserBusinessException {
        if (CollectionUtils.isEmpty(lines)) {
            return new HashMap<String, String[]>();
        }
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File originalDirectory = new File(projectDirectory, "original");
        String storageFileName = this.getDataStorageFileName(project, category, null);
        File dataFile = new File(originalDirectory, storageFileName);
        Map<String, String[]> contents = this.getOriginalFileContent(dataFile, lines);
        return contents;
    }

    public String getReportDisplayName(Project project, String species) {
        String displayName = null;
        Iterator<String[]> reftax = project.getRefTaxSpecies().iterator(true);
        while (reftax.hasNext()) {
            String[] tuple = reftax.next();
            String speciesCode = tuple[3];
            if (!speciesCode.equals(species)) continue;
            displayName = tuple[4] + " " + tuple[5];
            break;
        }
        return displayName;
    }
}

