/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.base.Preconditions;
import fr.ifremer.coser.bean.EchoBaseProject;
import fr.ifremer.coser.bean.RSufiResultPath;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class GlobalResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final RSufiResultPath rsufiProject;
    protected final EchoBaseProject echobaseProject;

    public GlobalResult(RSufiResultPath result) {
        Preconditions.checkNotNull((Object)result);
        this.rsufiProject = result;
        this.echobaseProject = null;
    }

    public GlobalResult(EchoBaseProject echoBaseProject) {
        Preconditions.checkNotNull((Object)echoBaseProject);
        this.echobaseProject = echoBaseProject;
        this.rsufiProject = null;
    }

    public static boolean isRsufiProject(File projectDirectory) {
        boolean result = projectDirectory.isDirectory();
        if (result) {
            File file = new File(projectDirectory, "project.echobase");
            result = file.exists() && file.isFile();
        }
        return result;
    }

    public static boolean isEchobaseProject(File projectDirectory) {
        boolean result = projectDirectory.isDirectory();
        if (result) {
            File file = new File(projectDirectory, "project.echobase");
            result = file.exists() && file.isFile();
        }
        return result;
    }

    public boolean isRsufi() {
        return this.rsufiProject != null;
    }

    public boolean isEchoBase() {
        return this.echobaseProject != null;
    }

    public Date getCreationDate() {
        Date result = this.isRsufi() ? this.rsufiProject.getRsufiResult().getCreationDate() : this.echobaseProject.getCreationDate();
        return result;
    }

    public String getZone() {
        String result = this.isRsufi() ? this.rsufiProject.getRsufiResult().getZone() : this.echobaseProject.getZoneName();
        return result;
    }

    public RSufiResultPath getRsufiProject() {
        return this.rsufiProject;
    }

    public EchoBaseProject getEchobaseProject() {
        return this.echobaseProject;
    }

    public boolean isPubliableResult() {
        return this.isRsufi() ? this.rsufiProject.getRsufiResult().isPubliableResult() : this.echobaseProject.isPubliableResult();
    }

    public boolean isIndicatorsResult() {
        return !this.isRsufi() || this.rsufiProject.getRsufiResult().isPubliableResult();
    }

    public void setIndicatorsResult(boolean indicatorsResult) {
        if (this.isRsufi()) {
            this.rsufiProject.getRsufiResult().setIndicatorsResult(indicatorsResult);
        }
    }

    public boolean isMapsResult() {
        return !this.isRsufi() || this.rsufiProject.getRsufiResult().isMapsResult();
    }

    public void setMapsResult(boolean mapsResult) {
        if (this.isRsufi()) {
            this.rsufiProject.getRsufiResult().setMapsResult(mapsResult);
        }
    }

    public boolean isDataAllowed() {
        return !this.isRsufi() || this.rsufiProject.getRsufiResult().isDataAllowed();
    }

    public void setDataAllowed(boolean dataAllowed) {
        if (this.isRsufi()) {
            this.rsufiProject.getRsufiResult().setDataAllowed(dataAllowed);
        }
    }

    public int hashCode() {
        return this.isRsufi() ? this.rsufiProject.hashCode() : this.echobaseProject.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof GlobalResult && (this.isRsufi() ? this.rsufiProject.equals(obj) : this.echobaseProject.equals(obj));
        return result;
    }

    public String getName() {
        return this.isRsufi() ? String.format("%s/%s/%s", this.rsufiProject.getProject().getName(), this.rsufiProject.getSelection().getName(), this.rsufiProject.getRsufiResult().getName()) : this.echobaseProject.getName();
    }
}

