/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import fr.ifremer.coser.CoserTechnicalException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public class CoserBusinessConfig
extends ApplicationConfig {
    public CoserBusinessConfig() {
        this.loadDefaultOptions(CoserBusinessOption.values());
    }

    public void setOption(String key, String value) {
        String defaultValue = this.line.getProperty(key);
        if ((defaultValue = this.replaceRecursiveOptions(defaultValue)) != null && defaultValue.equals(value)) {
            this.options.remove(key);
        } else {
            super.setOption(key, value);
        }
    }

    public void setDatabaseDirectory(String value) {
        this.setOption(CoserBusinessOption.DATABASE_DIRECTORY.key, value);
    }

    public File getDatabaseDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.DATABASE_DIRECTORY.key);
        return result;
    }

    public File getProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.PROJECTS_DIRECTORY.key);
        return result;
    }

    public void setProjectsDirectory(String projectDirectory) {
        this.setOption(CoserBusinessOption.PROJECTS_DIRECTORY.key, projectDirectory);
    }

    public File getRSufiProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.RSUFI_PROJECTS_DIRECTORY.key);
        return result;
    }

    public void setRSufiProjectsDirectory(String projectDirectory) {
        this.setOption(CoserBusinessOption.RSUFI_PROJECTS_DIRECTORY.key, projectDirectory);
    }

    public File getEchoBaseProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.ECHOBASE_PROJECTS_DIRECTORY.key);
        return result;
    }

    public void setEchoBaseProjectsDirectory(String projectDirectory) {
        this.setOption(CoserBusinessOption.ECHOBASE_PROJECTS_DIRECTORY.key, projectDirectory);
    }

    public File getValidatorsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.VALIDATOR_DIRECTORY.key);
        return result;
    }

    public void setValidatorsDirectory(String validatorDirectory) {
        this.setOption(CoserBusinessOption.VALIDATOR_DIRECTORY.key, validatorDirectory);
    }

    public void setSmtpHost(String smtpHost) {
        this.setOption(CoserBusinessOption.SMTP_HOST.key, smtpHost);
    }

    public String getSmtpHost() {
        String result = this.getOption(CoserBusinessOption.SMTP_HOST.key);
        return result;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, CoserBusinessOption.LOCALE.key);
        return result;
    }

    public void setLocale(Locale locale) {
        this.setOption(CoserBusinessOption.LOCALE.key, locale.toString());
    }

    public String getReferenceSpeciesPath() {
        String result = this.getOption(CoserBusinessOption.REFERENCE_SPECIES.key);
        return result;
    }

    public void setReferenceSpeciesPath(String referenceSpeciesPath) {
        this.setOption(CoserBusinessOption.REFERENCE_SPECIES.key, referenceSpeciesPath);
    }

    public String getReferenceTypeEspecesPath() {
        String result = this.getOption(CoserBusinessOption.REFERENCE_TYPE_ESPECES.key);
        return result;
    }

    public void setReferenceTypeEspecesPath(String referenceTypeEspecesPath) {
        this.setOption(CoserBusinessOption.REFERENCE_TYPE_ESPECES.key, referenceTypeEspecesPath);
    }

    public double getControlNobsmin() {
        double result = this.getOptionAsDouble(CoserBusinessOption.CONTROL_NOBSMIN.key);
        return result;
    }

    public void setControlNobsmin(double controlNobsmin) {
        this.setOption(CoserBusinessOption.CONTROL_NOBSMIN.key, String.valueOf(controlNobsmin));
    }

    public double getControlDiffCatchLength() {
        double result = this.getOptionAsDouble(CoserBusinessOption.CONTROL_DIFF_CATCH_LENGTH.key);
        return result;
    }

    public void setControlDiffCatchLength(double controlDiffCatchLength) {
        this.setOption(CoserBusinessOption.CONTROL_DIFF_CATCH_LENGTH.key, String.valueOf(controlDiffCatchLength));
    }

    public String getControlTypeFish() {
        String result = this.getOption(CoserBusinessOption.CONTROL_TYPE_FISH.key);
        return result;
    }

    public void setControlTypeFish(String controlTypeFish) {
        this.setOption(CoserBusinessOption.CONTROL_TYPE_FISH.key, controlTypeFish);
    }

    public void setStandardDeviationToAverage(int deviationToAverage) {
        this.setOption(CoserBusinessOption.CONTROL_STANDARD_DEVIATION_TO_AVERAGE.key, String.valueOf(deviationToAverage));
    }

    public int getStandardDeviationToAverage() {
        return this.getOptionAsInt(CoserBusinessOption.CONTROL_STANDARD_DEVIATION_TO_AVERAGE.key);
    }

    public double getSelectionOccurrenceFilter() {
        double result = this.getOptionAsDouble(CoserBusinessOption.SELECTION_FILTER_OCCURRENCE.key);
        return result;
    }

    public void setSelectionOccurrenceFilter(double selectionOccurrenceFilter) {
        this.setOption(CoserBusinessOption.SELECTION_FILTER_OCCURRENCE.key, String.valueOf(selectionOccurrenceFilter));
    }

    public double getSelectionDensityFilter() {
        double result = this.getOptionAsDouble(CoserBusinessOption.SELECTION_FILTER_DENSITY.key);
        return result;
    }

    public void setSelectionDensityFilter(double selectionDensityFilter) {
        this.setOption(CoserBusinessOption.SELECTION_FILTER_DENSITY.key, String.valueOf(selectionDensityFilter));
    }

    public String getWebFrontEnd() {
        String result = this.getOption(CoserBusinessOption.WEB_FRONT_END.key);
        return result;
    }

    public void setWebFrontEnd(String webFrontEnd) {
        this.setOption(CoserBusinessOption.WEB_FRONT_END.key, webFrontEnd);
    }

    public String getWebUploadURL() {
        String result = this.getOption(CoserBusinessOption.WEB_UPLOAD_URL.key);
        return result;
    }

    public File getWebPropertiesFile() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_PROPERTIES_FILE.key);
        return result;
    }

    public File getWebIndicatorsProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_INDICATORS_PROJECTS_DIRECTORY.key);
        return result;
    }

    public File getWebMapsProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_MAPS_PROJECTS_DIRECTORY.key);
        return result;
    }

    public File getWebEchobaseProjectsDirectory() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_ECHOBASE_PROJECTS_DIRECTORY.key);
        return result;
    }

    public File getWebIndicatorsFile() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_INDICATORS.key);
        return result;
    }

    public void setWebIndicatorsFile(String indicatorsFile) {
        this.setOption(CoserBusinessOption.WEB_INDICATORS.key, indicatorsFile);
    }

    public File getWebZonesFile() {
        File result = this.getOptionAsFile(CoserBusinessOption.WEB_ZONES.key);
        return result;
    }

    public void setWebZonesFile(String zoneFile) {
        this.setOption(CoserBusinessOption.WEB_ZONES.key, zoneFile);
    }

    public List<String> getNewResultNotificationList() {
        List emails = this.getOptionAsList(CoserBusinessOption.WEB_PUBLICATION_EMAIL.key).getOption();
        return emails;
    }

    public Date getLastDataUpdateDate() {
        Date dataUpdateDate = null;
        File webProperties = this.getWebPropertiesFile();
        if (webProperties.isFile()) {
            Properties props = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(webProperties);
                props.load(stream);
                if (props.containsKey("updateDate")) {
                    String date = props.getProperty("updateDate");
                    long time = Long.parseLong(date);
                    dataUpdateDate = new Date(time);
                }
                ((InputStream)stream).close();
            }
            catch (IOException ex) {
                try {
                    throw new CoserTechnicalException("Can't read properties file", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (dataUpdateDate == null) {
            dataUpdateDate = new Date(0L);
        }
        return dataUpdateDate;
    }

    public void updateDataProperties() {
        File webProperties = this.getWebPropertiesFile();
        Properties props = new Properties();
        FileInputStream iStream = null;
        FileOutputStream oStream = null;
        try {
            if (webProperties.isFile()) {
                iStream = new FileInputStream(webProperties);
                props.load(iStream);
            }
            props.setProperty("updateDate", String.valueOf(new Date().getTime()));
            oStream = new FileOutputStream(webProperties);
            props.store(oStream, "Update data");
        }
        catch (IOException ex) {
            try {
                throw new CoserTechnicalException("Can't save properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iStream);
                IOUtils.closeQuietly(oStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)iStream);
        IOUtils.closeQuietly((OutputStream)oStream);
    }

    public static enum CoserBusinessOption implements ConfigOptionDef
    {
        DATABASE_DIRECTORY("coser.database.directory", I18n.n((String)"coser.config.database.directory.description", (Object[])new Object[0]), File.class, "${user.home}" + File.separator + "coser"),
        PROJECTS_DIRECTORY("coser.projects.directory", I18n.n((String)"coser.config.projects.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "projects"),
        RSUFI_PROJECTS_DIRECTORY("coser.projects.rsufi.directory", I18n.n((String)"coser.config.projects.rsufi.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.PROJECTS_DIRECTORY.key + "}" + File.separator + "rsufi"),
        ECHOBASE_PROJECTS_DIRECTORY("coser.projects.echobase.directory", I18n.n((String)"coser.config.projects.echobase.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.PROJECTS_DIRECTORY.key + "}" + File.separator + "echobase"),
        VALIDATOR_DIRECTORY("coser.validator.directory", I18n.n((String)"coser.config.validator.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "validators"),
        SMTP_HOST("coser.smtp.host", I18n.n((String)"coser.config.smtp.host.description", (Object[])new Object[0]), String.class, "smtp"),
        LOCALE("coser.locale", I18n.n((String)"coser.config.locale.description", (Object[])new Object[0]), Locale.class, Locale.FRANCE.toString()),
        REFERENCE_SPECIES("coser.reference.species", I18n.n((String)"coser.config.reference.species.description", (Object[])new Object[0]), String.class, ""),
        REFERENCE_TYPE_ESPECES("coser.reference.typeSpecies", I18n.n((String)"coser.config.reference.typeSpecies.description", (Object[])new Object[0]), String.class, ""),
        CONTROL_NOBSMIN("coser.control.nobsmin", I18n.n((String)"coser.config.control.nobsmin.description", (Object[])new Object[0]), Float.class, "1.0"),
        CONTROL_DIFF_CATCH_LENGTH("coser.control.diffcatchlength", I18n.n((String)"coser.config.control.diffcatchlength.description", (Object[])new Object[0]), Float.class, "5.0"),
        CONTROL_TYPE_FISH("coser.control.typeFish", I18n.n((String)"coser.config.control.typeFish.description", (Object[])new Object[0]), String.class, "Pisces + Agnatha"),
        CONTROL_STANDARD_DEVIATION_TO_AVERAGE("coser.control.standarddeviationtoaverage", I18n.n((String)"coser.config.control.standarddeviationtoaverage.description", (Object[])new Object[0]), Integer.class, "3"),
        SELECTION_FILTER_OCCURRENCE("coser.selection.occurrenceFilter", I18n.n((String)"coser.config.selection.occurrenceFilter.description", (Object[])new Object[0]), Float.class, "5.0"),
        SELECTION_FILTER_DENSITY("coser.selection.densityFilter", I18n.n((String)"coser.config.selection.densityFilter.description", (Object[])new Object[0]), Float.class, "5.0"),
        WEB_FRONT_END("coser.web.frontend", I18n.n((String)"coser.config.web.frontend.description", (Object[])new Object[0]), URL.class, "http://www.ifremer.fr/SIH-indices-campagnes"),
        WEB_UPLOAD_URL("coser.web.uploadurl", I18n.n((String)"coser.config.web.uploadurl.description", (Object[])new Object[0]), URL.class, "${" + CoserBusinessOption.WEB_FRONT_END.key + "}/upload-result.action"),
        WEB_PROPERTIES_FILE("coser.web.properties.file", I18n.n((String)"coser.config.web.properties.file.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "web.properties"),
        WEB_INDICATORS_PROJECTS_DIRECTORY("coser.web.indicators.projects.directory", I18n.n((String)"coser.config.web.indicators.projects.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "webindicatorsprojects"),
        WEB_MAPS_PROJECTS_DIRECTORY("coser.web.maps.projects.directory", I18n.n((String)"coser.config.web.maps.projects.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "webmapsprojects"),
        WEB_ECHOBASE_PROJECTS_DIRECTORY("coser.web.echobase.projects.directory", I18n.n((String)"coser.config.web.echobase.projects.directory.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "webechobaseprojects"),
        WEB_INDICATORS("coser.web.indicators.file", I18n.n((String)"coser.config.web.indicators.file.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "webindicators.csv"),
        WEB_ZONES("coser.web.zones.file", I18n.n((String)"coser.config.web.zones.file.description", (Object[])new Object[0]), File.class, "${" + CoserBusinessOption.DATABASE_DIRECTORY.key + "}" + File.separator + "webzones.csv"),
        WEB_PUBLICATION_EMAIL("coser.web.newresult.emails", I18n.n((String)"coser.config.web.newresult.emails.description", (Object[])new Object[0]), String.class, null);

        private final String key;
        private final String description;
        private final String defaultValue;
        private final Class<?> type;

        private CoserBusinessOption(String key, String description, Class<?> type, String defaultValue) {
            this.key = key;
            this.description = description;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean isFinal() {
            return false;
        }

        public void setDefaultValue(String defaultValue) {
        }

        public void setTransient(boolean isTransient) {
        }

        public void setFinal(boolean isFinal) {
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

