/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.EmailAbstract;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EmailImpl
extends EmailAbstract {
    protected History firstOpeningHistory;
    protected History lastModificationHistory;
    protected History lastAttachmentOpeningInFolderHistory;

    public void findFirstOpeningHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (!HistoryType.OPENING.equals(history.getType()) || date != null && !date.after(history.getModificationDate())) continue;
                date = history.getModificationDate();
                result = history;
            }
        }
        this.firstOpeningHistory = result;
    }

    public void findLastModificationHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (!history.getType().isConsideredAsModification() || date != null && !date.before(history.getModificationDate())) continue;
                date = history.getModificationDate();
                result = history;
            }
        }
        this.lastModificationHistory = result;
    }

    public void findLastAttachmentOpeningInFolderHistory() {
        History result = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            History transmissionHistory = null;
            for (History history : histories) {
                Date modificationDate = history.getModificationDate();
                if (HistoryType.ATTACHMENT_OPENING.equals(history.getType())) {
                    if (transmissionHistory != null && !transmissionHistory.getModificationDate().before(modificationDate) || result != null && !result.getModificationDate().before(modificationDate)) continue;
                    result = history;
                    continue;
                }
                if (!HistoryType.TRANSMISSION.equals(history.getType()) || transmissionHistory != null && !transmissionHistory.getModificationDate().before(modificationDate)) continue;
                transmissionHistory = history;
                if (result == null || !result.getModificationDate().before(transmissionHistory.getModificationDate())) continue;
                result = null;
            }
        }
        this.lastAttachmentOpeningInFolderHistory = result;
    }

    protected History getFirstOpeningHistory() {
        if (this.firstOpeningHistory == null) {
            this.findFirstOpeningHistory();
        }
        return this.firstOpeningHistory;
    }

    @Override
    public FaxToMailUser getFirstOpeningUser() {
        History history = this.getFirstOpeningHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    @Override
    public Date getFirstOpeningDate() {
        History history = this.getFirstOpeningHistory();
        return history != null ? history.getModificationDate() : null;
    }

    protected History getLastModificationHistory() {
        if (this.lastModificationHistory == null) {
            this.findLastModificationHistory();
        }
        return this.lastModificationHistory;
    }

    @Override
    public FaxToMailUser getLastModificationUser() {
        History history = this.getLastModificationHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    @Override
    public Date getLastModificationDate() {
        History history = this.getLastModificationHistory();
        return history != null ? history.getModificationDate() : null;
    }

    protected History getLastAttachmentOpeningInThisFolderHistory() {
        if (this.lastAttachmentOpeningInFolderHistory == null) {
            this.findLastAttachmentOpeningInFolderHistory();
        }
        return this.lastAttachmentOpeningInFolderHistory;
    }

    @Override
    public FaxToMailUser getLastAttachmentOpeningInFolderUser() {
        History history = this.getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    @Override
    public Date getLastAttachmentOpeningInFolderDate() {
        History history = this.getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getModificationDate() : null;
    }

    @Override
    public void setHistory(Collection<History> history) {
        this.firstOpeningHistory = null;
        this.lastModificationHistory = null;
        this.lastAttachmentOpeningInFolderHistory = null;
        super.setHistory(history);
    }

    @Override
    public String getReference() {
        List<RangeRow> rangeRow;
        ArrayList<String> reference = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getCompanyReference())) {
            reference.add(this.getCompanyReference());
        }
        if ((rangeRow = this.getRangeRow()) != null) {
            Collection commandNumbers = Collections2.transform(rangeRow, (Function)new Function<RangeRow, String>(){

                public String apply(RangeRow input) {
                    return input != null ? input.getCommandNumber() : "";
                }
            });
            Collections2.filter((Collection)commandNumbers, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return StringUtils.isNotBlank((CharSequence)input);
                }
            });
            reference.addAll(commandNumbers);
        }
        return StringUtils.join(reference, (String)", ");
    }

    @Override
    public String getTitle() {
        String result = this.getObject();
        String ref = this.getReference();
        if (!ref.isEmpty()) {
            result = ref + " - " + result;
        }
        return Strings.nullToEmpty((String)result);
    }
}

