/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentListArgument
extends Argument {
    private static final long serialVersionUID = 1926330851837348378L;
    private final ArgumentParser parser;
    private final List<ArgumentParser> values;
    private final List<String> valueStrings;

    public ArgumentListArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, ArgumentParser parser) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        this.parser = parser.getCleanCopy();
        this.values = new ArrayList<ArgumentParser>();
        this.valueStrings = new ArrayList<String>();
    }

    private ArgumentListArgument(ArgumentListArgument source) {
        super(source);
        this.parser = source.parser;
        this.values = new ArrayList<ArgumentParser>();
        this.valueStrings = new ArrayList<String>();
    }

    public ArgumentParser getCleanParser() {
        return this.parser.getCleanCopy();
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        List<String> argList;
        try {
            argList = StaticUtils.toArgumentList(valueString);
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new ArgumentException(ArgsMessages.ERR_ARG_LIST_MALFORMED_VALUE.get(valueString, this.getIdentifierString(), pe.getMessage()), pe);
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        ArgumentParser p = this.parser.getCleanCopy();
        try {
            p.parse(args);
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            throw new ArgumentException(ArgsMessages.ERR_ARG_LIST_INVALID_VALUE.get(valueString, this.getIdentifierString(), ae.getMessage()), ae);
        }
        this.values.add(p);
        this.valueStrings.add(valueString);
    }

    public List<ArgumentParser> getValueParsers() {
        return Collections.unmodifiableList(this.values);
    }

    public List<String> getValueStrings() {
        return Collections.unmodifiableList(this.valueStrings);
    }

    @Override
    protected boolean hasDefaultValue() {
        return false;
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_ARG_LIST_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_ARG_LIST_CONSTRAINTS.get();
    }

    @Override
    public ArgumentListArgument getCleanCopy() {
        return new ArgumentListArgument(this);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ArgumentListArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(", parser=");
        this.parser.toString(buffer);
        buffer.append(')');
    }
}

