/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.franciaflex.faxtomail.ui.swing.util.CheckBoxComboBoxModel;
import com.franciaflex.faxtomail.ui.swing.util.CheckBoxListCellRenderer;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.UIMessageNotifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationDataUtil;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractFaxToMailUIHandler<M, UI extends FaxToMailUI<M, ?>>
extends AbstractApplicationUIHandler<M, UI>
implements UIMessageNotifier {
    private static final Log log = LogFactory.getLog(AbstractFaxToMailUIHandler.class);
    protected final PropertyChangeListener listModelListener = new PropertyChangeListener(){
        final Set<String> excludeProperties;
        {
            this.excludeProperties = AbstractFaxToMailUIHandler.this.getPropertiesToIgnore();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if (!this.excludeProperties.contains(evt.getPropertyName()) && newValue != oldValue) {
                ((AbstractFaxToMailBeanUIModel)((Object)evt.getSource())).setModify(true);
            }
        }
    };

    @Override
    public void showInformationMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    public FaxToMailUIContext getContext() {
        return (FaxToMailUIContext)super.getContext();
    }

    public FaxToMailConfiguration getConfig() {
        return this.getContext().getConfig();
    }

    public Component getTopestUI() {
        return this.getContext().getMainUI();
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.getContext().newServiceContext().getDecoratorService();
        Preconditions.checkNotNull(type);
        Decorator decorator = decoratorService.getDecoratorByType(type, name);
        return decorator;
    }

    public String decorate(Serializable s) {
        return super.decorate(s);
    }

    public String decorateUser(FaxToMailUser user, boolean systemIfNull) {
        if (user == null && systemIfNull) {
            return I18n.t((String)"faxtomail.systemUser", (Object[])new Object[0]);
        }
        return this.decorate((Serializable)((Object)user));
    }

    public void setText(ItemEvent e, String property) {
        String value = JAXXUtil.getStringValue((Object)e.getItem());
        ApplicationDataUtil.setProperty((Object)this.getModel(), (String)property, (Object)value);
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        if (field.isEditable()) {
            super.setText(event, property);
        }
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, final AbstractFaxToMailBeanUIModel model) {
        validator.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    protected void listModelIsModify(AbstractFaxToMailBeanUIModel model) {
        model.addPropertyChangeListener(this.listModelListener);
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet((Object[])new String[]{"modify", "valid"});
    }

    public JFrame openFrame(ApplicationUI dialogContent, String title, Dimension dim) {
        final JFrame result = new JFrame();
        result.setResizable(true);
        this.getContext().setSecondaryFrame(result);
        result.setName(dialogContent.getClass().getName());
        result.setTitle(title);
        result.setContentPane((Container)dialogContent);
        final AbstractApplicationUIHandler handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getContext().getConfiguration().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)handler).cancel();
                }
            });
        }
        result.setSize(dim);
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)result);
        result.setDefaultCloseOperation(0);
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractFaxToMailUIHandler.this.closeFrame(result, handler);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroy ui " + ui));
                }
                AbstractFaxToMailUIHandler.this.getContext().getSwingSession().updateState();
                JAXXUtil.destroy((Component)ui);
            }
        });
        result.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                log.warn((Object)"openframe : focus gained");
                AbstractFaxToMailUIHandler.this.getContext().setActionUI(new ApplicationActionUI(result, (ApplicationUIContext)AbstractFaxToMailUIHandler.this.getContext()));
            }
        });
        this.getContext().getSwingSession().add((Component)result, true);
        result.setVisible(true);
        return result;
    }

    public JFrame openModalFrame(ApplicationUI dialogContent, String title, Dimension dim) {
        final JFrame result = new JFrame();
        result.setResizable(true);
        this.getContext().setSecondaryFrame(result);
        final Frame parentContainer = (Frame)this.getParentContainer(Frame.class);
        parentContainer.setEnabled(false);
        parentContainer.setFocusableWindowState(false);
        result.setName(dialogContent.getClass().getName());
        result.setTitle(title);
        result.setContentPane((Container)dialogContent);
        final AbstractApplicationUIHandler handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getContext().getConfiguration().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)handler).cancel();
                }
            });
        }
        result.setSize(dim);
        SwingUtil.center((Component)parentContainer, (Component)result);
        result.setDefaultCloseOperation(0);
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractFaxToMailUIHandler.this.closeFrame(result, handler);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                parentContainer.setEnabled(true);
                parentContainer.setFocusableWindowState(true);
                parentContainer.toFront();
                AbstractFaxToMailUIHandler.this.getContext().getSwingSession().updateState();
                Component ui = (Component)e.getSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        result.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                log.warn((Object)"openmodalframe : focus gained");
                AbstractFaxToMailUIHandler.this.getContext().setActionUI(new ApplicationActionUI(result, (ApplicationUIContext)AbstractFaxToMailUIHandler.this.getContext()));
            }
        });
        this.getContext().getSwingSession().add((Component)result, true);
        result.setVisible(true);
        return result;
    }

    protected boolean quitScreen2(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, AbstractApplicationAction saveAction) {
        boolean result;
        if (!modelIsValid) {
            result = this.askCancelEditBeforeLeaving(askGiveUpMessage);
        } else if (modelIsModify) {
            int answer = this.askSaveBeforeLeaving(askSaveMessage);
            switch (answer) {
                case 0: {
                    if (this.getContext().isActionInProgress(null)) {
                        this.getContext().getActionEngine().runInternalAction(saveAction);
                    } else {
                        this.getContext().getActionEngine().runActionAndWait(saveAction);
                    }
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public void closeFrame() {
        JFrame frame = (JFrame)this.getParentContainer(JFrame.class);
        this.closeFrame(frame, this);
    }

    protected void closeFrame(JFrame frame, AbstractApplicationUIHandler handler) {
        handler.onCloseUI();
        if (frame != null) {
            boolean canClose = true;
            if (handler instanceof CloseableUI) {
                canClose = ((CloseableUI)handler).quitUI();
            }
            if (canClose) {
                frame.dispose();
            }
        }
    }

    protected <HL extends HasLabel> void initCheckBoxComboBox(final JComboBox<HL> comboBox, List<HL> values, List<HL> selection, String property, boolean addNull) {
        ArrayList<HL> universe = new ArrayList<HL>();
        if (addNull) {
            universe.add(null);
        }
        if (values != null) {
            universe.addAll(values);
        }
        final CheckBoxComboBoxModel comboModel = new CheckBoxComboBoxModel(universe, selection);
        comboBox.setModel(comboModel);
        comboBox.setRenderer(new CheckBoxListCellRenderer<HL>(){

            @Override
            protected boolean isCheckBoxSelected(Object value) {
                return ((List)comboModel.getSelectedItem()).contains(value);
            }
        });
        final Method mutator = BeanUtil.getMutator((Object)this.getModel(), (String)property);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        comboBox.showPopup();
                    }
                });
                if (e.getStateChange() == 1) {
                    BeanUIUtil.invokeMethod((Method)mutator, (Object)AbstractFaxToMailUIHandler.this.getModel(), (Object[])new Object[]{e.getItem()});
                }
            }
        });
    }

    public boolean isActionEnabled(DemandeUIModel model, MailAction action, Configuration config) {
        WaitingState waitingState = model.getWaitingState();
        boolean valid = model.isValid();
        boolean enabled = waitingState == null && (valid || !FaxToMailServiceUtils.contains(config.getInvalidFormDisabledActions(), (Enum)action)) || waitingState != null && (valid && !FaxToMailServiceUtils.contains(waitingState.getValidFormDisabledActions(), (Enum)action) || !valid && !FaxToMailServiceUtils.contains(waitingState.getInvalidFormDisabledActions(), (Enum)action));
        return enabled;
    }

    protected <R, B> TableColumnExt addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        JComboBox comboBox = new JComboBox();
        comboBox.setMaximumRowCount(20);
        comboBox.setRenderer(this.newListCellRender(decorator));
        ArrayList dataToList = Lists.newArrayList(data);
        if (!dataToList.isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox(comboBox, (Collection)dataToList, null);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        return this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), identifier);
    }
}

