/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;

public class PDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(PDFParser.class);
    private String password = "";
    private InputStream keyStoreInputStream = null;
    private String keyAlias = null;
    private AccessPermission accessPermission;

    public PDFParser(RandomAccessRead source) throws IOException {
        this(source, "", false);
    }

    public PDFParser(RandomAccessRead source, boolean useScratchFiles) throws IOException {
        this(source, "", useScratchFiles);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword) throws IOException {
        this(source, decryptionPassword, false);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, boolean useScratchFiles) throws IOException {
        this(source, decryptionPassword, null, null, useScratchFiles);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(source, decryptionPassword, keyStore, alias, false);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias, boolean useScratchFiles) throws IOException {
        super(source);
        this.fileLen = source.length();
        this.password = decryptionPassword;
        this.keyStoreInputStream = keyStore;
        this.keyAlias = alias;
        this.init(useScratchFiles);
    }

    public PDFParser(RandomAccessRead source, String decryptionPassword, InputStream keyStore, String alias, ScratchFile scratchFile) throws IOException {
        super(source);
        this.fileLen = source.length();
        this.password = decryptionPassword;
        this.keyStoreInputStream = keyStore;
        this.keyAlias = alias;
        this.init(scratchFile);
    }

    private void init(ScratchFile scratchFile) throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(scratchFile);
    }

    private void init(boolean useScratchFiles) throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(useScratchFiles);
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument(), this.source, this.accessPermission);
    }

    protected void initialParse() throws IOException {
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        if (startXRefOffset > -1L) {
            trailer = this.parseXref(startXRefOffset);
        } else if (this.isLenient()) {
            trailer = this.rebuildTrailer();
        }
        this.prepareDecryption();
        this.parseTrailerValuesDynamically(trailer);
        COSObject catalogObj = this.document.getCatalog();
        if (catalogObj != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            this.document.setDecrypted();
        }
        this.initialParseDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parsePDFHeader() && !this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            if (!this.initialParseDone) {
                this.initialParse();
            }
            exceptionOccurred = false;
        }
        finally {
            IOUtils.closeQuietly(this.keyStoreInputStream);
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }

    private void prepareDecryption() throws IOException {
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem != null && !(trailerEncryptItem instanceof COSNull)) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseDictionaryRecursive(trailerEncryptObj);
            }
            try {
                DecryptionMaterial decryptionMaterial;
                PDEncryption encryption = new PDEncryption(this.document.getEncryptionDictionary());
                if (this.keyStoreInputStream != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(this.keyStoreInputStream, this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.keyAlias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = encryption.getSecurityHandler();
                this.securityHandler.prepareForDecryption(encryption, this.document.getDocumentID(), decryptionMaterial);
                this.accessPermission = this.securityHandler.getCurrentAccessPermission();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption", e);
            }
        }
    }

    private void parseDictionaryRecursive(COSObject dictionaryObject) throws IOException {
        this.parseObjectDynamically(dictionaryObject, true);
        COSDictionary dictionary = (COSDictionary)dictionaryObject.getObject();
        for (COSBase value : dictionary.getValues()) {
            COSObject object;
            if (!(value instanceof COSObject) || (object = (COSObject)value).getObject() != null) continue;
            this.parseDictionaryRecursive(object);
        }
    }
}

