/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import com.google.common.io.Files;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.lang3.StringUtils;

public class FileEditorHandler {
    public static final String SEPARATOR_REGEX = "\\s*,\\s*";
    public static File lastSelectedPath;
    protected FileEditor view;
    protected JDialog dialogOwner;

    public FileEditorHandler(FileEditor view) {
        this.view = view;
        if (lastSelectedPath == null) {
            lastSelectedPath = new File(System.getProperty("user.home"));
        }
    }

    public void openLocation() {
        boolean hackDialog;
        boolean fileEnabled;
        File startFile = this.view.getSelectedFile();
        String startPath = this.view.getStartPath();
        if (startFile == null && StringUtils.isNotEmpty((CharSequence)startPath)) {
            startFile = new File(startPath);
        } else if (startFile == null) {
            startFile = lastSelectedPath;
        }
        JFileChooser fc = new JFileChooser(startFile);
        fc.setDialogTitle(this.view.getTitle());
        fc.setAcceptAllFileFilterUsed(this.view.getAcceptAllFileFilterUsed());
        boolean directoryEnabled = this.view.isDirectoryEnabled();
        if (directoryEnabled) {
            fc.setFileSelectionMode(1);
        }
        if (fileEnabled = this.view.isFileEnabled().booleanValue()) {
            if (directoryEnabled) {
                fc.setFileSelectionMode(2);
            } else {
                fc.setFileSelectionMode(0);
            }
            String extsAsString = this.view.getExts();
            if (extsAsString != null) {
                String[] exts = extsAsString.split(SEPARATOR_REGEX);
                String extsDescription = this.view.getExtsDescription();
                String[] descs = new String[]{};
                if (extsDescription != null) {
                    descs = extsDescription.split(SEPARATOR_REGEX);
                }
                for (int i = 0; i < exts.length; ++i) {
                    String ext;
                    String desc = ext = exts[i];
                    if (descs.length > i) {
                        desc = descs[i];
                    }
                    fc.addChoosableFileFilter(new ExtentionFileFiler(ext, desc));
                }
            }
        }
        if (!directoryEnabled && !fileEnabled) {
            throw new IllegalArgumentException("You must enable at least file or directory to open dialog");
        }
        boolean bl = hackDialog = this.dialogOwner != null && this.dialogOwner.isAlwaysOnTop();
        if (hackDialog) {
            this.dialogOwner.setAlwaysOnTop(false);
        }
        int returnVal = fc.showOpenDialog(this.view);
        if (hackDialog) {
            this.dialogOwner.setAlwaysOnTop(true);
        }
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.setSelectedFile(file);
        }
    }

    public void setSelectedFile(String path) {
        this.setSelectedFile(new File(path));
    }

    public void setSelectedFile(File file) {
        this.view.setSelectedFile(file);
        this.view.setStartPath(file.getPath());
        File dir = file;
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            lastSelectedPath = dir;
        }
    }

    protected void setDialogOwner(JDialog dialogOwner) {
        this.dialogOwner = dialogOwner;
    }

    public static class ExtentionFileFiler
    extends FileFilter {
        protected String ext;
        protected String desciption;

        public ExtentionFileFiler(String ext, String desciption) {
            this.ext = ext;
            this.desciption = desciption;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileExtension = Files.getFileExtension((String)file.getName());
            return this.ext.equals(fileExtension);
        }

        @Override
        public String getDescription() {
            return this.desciption;
        }
    }
}

