/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDFTemplateBuilder;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDFTemplateStructure;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PDVisibleSigBuilder
implements PDFTemplateBuilder {
    private final PDFTemplateStructure pdfStructure = new PDFTemplateStructure();
    private static final Log log = LogFactory.getLog(PDVisibleSigBuilder.class);

    @Override
    public void createPage(PDVisibleSignDesigner properties) {
        PDPage page = new PDPage(new PDRectangle(properties.getPageWidth(), properties.getPageHeight()));
        this.pdfStructure.setPage(page);
        log.info((Object)"PDF page has been created");
    }

    @Override
    public void createTemplate(PDPage page) throws IOException {
        PDDocument template = new PDDocument();
        template.addPage(page);
        this.pdfStructure.setTemplate(template);
    }

    public PDVisibleSigBuilder() {
        log.info((Object)"PDF Strucure has been Created");
    }

    @Override
    public void createAcroForm(PDDocument template) {
        PDAcroForm theAcroForm = new PDAcroForm(template);
        template.getDocumentCatalog().setAcroForm(theAcroForm);
        this.pdfStructure.setAcroForm(theAcroForm);
        log.info((Object)"Acro form page has been created");
    }

    @Override
    public PDFTemplateStructure getStructure() {
        return this.pdfStructure;
    }

    @Override
    public void createSignatureField(PDAcroForm acroForm) throws IOException {
        PDSignatureField sf = new PDSignatureField(acroForm);
        this.pdfStructure.setSignatureField(sf);
        log.info((Object)"Signature field has been created");
    }

    @Override
    public void createSignature(PDSignatureField pdSignatureField, PDPage page, String signatureName) throws IOException {
        PDSignature pdSignature = new PDSignature();
        pdSignatureField.setSignature(pdSignature);
        pdSignatureField.getWidget().setPage(page);
        page.getAnnotations().add(pdSignatureField.getWidget());
        pdSignature.setName(signatureName);
        pdSignature.setByteRange(new int[]{0, 0, 0, 0});
        pdSignature.setContents(new byte[4096]);
        this.pdfStructure.setPdSignature(pdSignature);
        log.info((Object)"PDSignature has been created");
    }

    @Override
    public void createAcroFormDictionary(PDAcroForm acroForm, PDSignatureField signatureField) throws IOException {
        List<PDFieldTreeNode> acroFormFields = acroForm.getFields();
        COSDictionary acroFormDict = acroForm.getDictionary();
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        acroFormDict.setDirect(true);
        acroFormFields.add(signatureField);
        acroForm.setDefaultAppearance("/sylfaen 0 Tf 0 g");
        this.pdfStructure.setAcroFormFields(acroFormFields);
        this.pdfStructure.setAcroFormDictionary(acroFormDict);
        log.info((Object)"AcroForm dictionary has been created");
    }

    @Override
    public void createSignatureRectangle(PDSignatureField signatureField, PDVisibleSignDesigner properties) throws IOException {
        PDRectangle rect = new PDRectangle();
        rect.setUpperRightX(properties.getxAxis() + properties.getWidth());
        rect.setUpperRightY(properties.getTemplateHeight() - properties.getyAxis());
        rect.setLowerLeftY(properties.getTemplateHeight() - properties.getyAxis() - properties.getHeight());
        rect.setLowerLeftX(properties.getxAxis());
        signatureField.getWidget().setRectangle(rect);
        this.pdfStructure.setSignatureRectangle(rect);
        log.info((Object)"rectangle of signature has been created");
    }

    @Override
    public void createAffineTransform(byte[] params) {
        AffineTransform transform = new AffineTransform(params[0], params[1], params[2], params[3], params[4], params[5]);
        this.pdfStructure.setAffineTransform(transform);
        log.info((Object)"Matrix has been added");
    }

    @Override
    public void createProcSetArray() {
        COSArray procSetArr = new COSArray();
        procSetArr.add(COSName.getPDFName("PDF"));
        procSetArr.add(COSName.getPDFName("Text"));
        procSetArr.add(COSName.getPDFName("ImageB"));
        procSetArr.add(COSName.getPDFName("ImageC"));
        procSetArr.add(COSName.getPDFName("ImageI"));
        this.pdfStructure.setProcSet(procSetArr);
        log.info((Object)"ProcSet array has been created");
    }

    @Override
    public void createSignatureImage(PDDocument template, BufferedImage image) throws IOException {
        this.pdfStructure.setImage(JPEGFactory.createFromImage(template, image));
        log.info((Object)"Visible Signature Image has been created");
    }

    @Override
    public void createFormaterRectangle(byte[] params) {
        PDRectangle formrect = new PDRectangle();
        formrect.setUpperRightX(params[0]);
        formrect.setUpperRightY(params[1]);
        formrect.setLowerLeftX(params[2]);
        formrect.setLowerLeftY(params[3]);
        this.pdfStructure.setFormaterRectangle(formrect);
        log.info((Object)"Formater rectangle has been created");
    }

    @Override
    public void createHolderFormStream(PDDocument template) {
        PDStream holderForm = new PDStream(template);
        this.pdfStructure.setHolderFormStream(holderForm);
        log.info((Object)"Holder form Stream has been created");
    }

    @Override
    public void createHolderFormResources() {
        PDResources holderFormResources = new PDResources();
        this.pdfStructure.setHolderFormResources(holderFormResources);
        log.info((Object)"Holder form resources have been created");
    }

    @Override
    public void createHolderForm(PDResources holderFormResources, PDStream holderFormStream, PDRectangle formrect) {
        PDFormXObject holderForm = new PDFormXObject(holderFormStream);
        holderForm.setResources(holderFormResources);
        holderForm.setBBox(formrect);
        holderForm.setFormType(1);
        this.pdfStructure.setHolderForm(holderForm);
        log.info((Object)"Holder form has been created");
    }

    @Override
    public void createAppearanceDictionary(PDFormXObject holderForml, PDSignatureField signatureField) throws IOException {
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(holderForml.getCOSStream());
        appearance.setNormalAppearance(appearanceStream);
        signatureField.getWidget().setAppearance(appearance);
        this.pdfStructure.setAppearanceDictionary(appearance);
        log.info((Object)"PDF appereance Dictionary has been created");
    }

    @Override
    public void createInnerFormStream(PDDocument template) {
        PDStream innterFormStream = new PDStream(template);
        this.pdfStructure.setInnterFormStream(innterFormStream);
        log.info((Object)"Stream of another form (inner form - it would be inside holder form) has been created");
    }

    @Override
    public void createInnerFormResource() {
        PDResources innerFormResources = new PDResources();
        this.pdfStructure.setInnerFormResources(innerFormResources);
        log.info((Object)"Resources of another form (inner form - it would be inside holder form)have been created");
    }

    @Override
    public void createInnerForm(PDResources innerFormResources, PDStream innerFormStream, PDRectangle formrect) {
        PDFormXObject innerForm = new PDFormXObject(innerFormStream);
        innerForm.setResources(innerFormResources);
        innerForm.setBBox(formrect);
        innerForm.setFormType(1);
        this.pdfStructure.setInnerForm(innerForm);
        log.info((Object)"Another form (inner form - it would be inside holder form) have been created");
    }

    @Override
    public void insertInnerFormToHolerResources(PDFormXObject innerForm, PDResources holderFormResources) {
        COSName name = holderFormResources.add(innerForm, "FRM");
        this.pdfStructure.setInnerFormName(name);
        log.info((Object)"Alerady inserted inner form  inside holder form");
    }

    @Override
    public void createImageFormStream(PDDocument template) {
        PDStream imageFormStream = new PDStream(template);
        this.pdfStructure.setImageFormStream(imageFormStream);
        log.info((Object)"Created image form Stream");
    }

    @Override
    public void createImageFormResources() {
        PDResources imageFormResources = new PDResources();
        this.pdfStructure.setImageFormResources(imageFormResources);
        log.info((Object)"Created image form Resources");
    }

    @Override
    public void createImageForm(PDResources imageFormResources, PDResources innerFormResource, PDStream imageFormStream, PDRectangle formrect, AffineTransform at, PDImageXObject img) throws IOException {
        PDFormXObject imageForm = new PDFormXObject(imageFormStream);
        imageForm.setBBox(formrect);
        imageForm.setMatrix(at);
        imageForm.setResources(imageFormResources);
        imageForm.setFormType(1);
        imageFormResources.getCOSObject().setDirect(true);
        COSName imageFormName = innerFormResource.add(imageForm, "n");
        COSName imageName = imageFormResources.add(img, "img");
        this.pdfStructure.setImageForm(imageForm);
        this.pdfStructure.setImageFormName(imageFormName);
        this.pdfStructure.setImageName(imageName);
        log.info((Object)"Created image form");
    }

    @Override
    public void injectProcSetArray(PDFormXObject innerForm, PDPage page, PDResources innerFormResources, PDResources imageFormResources, PDResources holderFormResources, COSArray procSet) {
        innerForm.getResources().getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        page.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        innerFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        imageFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        holderFormResources.getCOSObject().setItem(COSName.PROC_SET, (COSBase)procSet);
        log.info((Object)"inserted ProcSet to PDF");
    }

    @Override
    public void injectAppearanceStreams(PDStream holderFormStream, PDStream innterFormStream, PDStream imageFormStream, COSName imageObjectName, COSName imageName, COSName innerFormName, PDVisibleSignDesigner properties) throws IOException {
        String imgFormComment = "q 100 0 0 50 0 0 cm /" + imageName.getName() + " Do Q\n";
        String holderFormComment = "q 1 0 0 1 0 0 cm /" + innerFormName.getName() + " Do Q \n";
        String innerFormComment = "q 1 0 0 1 0 0 cm /" + imageObjectName.getName() + " Do Q\n";
        this.appendRawCommands(this.pdfStructure.getHolderFormStream().createOutputStream(), holderFormComment);
        this.appendRawCommands(this.pdfStructure.getInnterFormStream().createOutputStream(), innerFormComment);
        this.appendRawCommands(this.pdfStructure.getImageFormStream().createOutputStream(), imgFormComment);
        log.info((Object)"Injected apereance stream to pdf");
    }

    public void appendRawCommands(OutputStream os, String commands) throws IOException {
        os.write(commands.getBytes("UTF-8"));
        os.close();
    }

    @Override
    public void createVisualSignature(PDDocument template) {
        this.pdfStructure.setVisualSignature(template.getDocument());
        log.info((Object)"Visible signature has been created");
    }

    @Override
    public void createWidgetDictionary(PDSignatureField signatureField, PDResources holderFormResources) throws IOException {
        COSDictionary widgetDict = signatureField.getWidget().getCOSObject();
        widgetDict.setNeedToBeUpdated(true);
        widgetDict.setItem(COSName.DR, (COSBase)holderFormResources.getCOSObject());
        this.pdfStructure.setWidgetDictionary(widgetDict);
        log.info((Object)"WidgetDictionary has been crated");
    }

    @Override
    public void closeTemplate(PDDocument template) throws IOException {
        template.close();
        this.pdfStructure.getTemplate().close();
    }
}

