/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.New;

public class AlterTableAlterColumn
extends SchemaCommand {
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private String addBefore;
    private String addAfter;
    private boolean ifNotExists;
    private ArrayList<Column> columnsToAdd;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    public void setAddAfter(String string) {
        this.addAfter = string;
    }

    @Override
    public int update() {
        Sequence sequence;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence2 = sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        if (this.newColumn != null) {
            this.checkDefaultReferencesTable(this.newColumn.getDefaultExpression());
        }
        if (this.columnsToAdd != null) {
            for (Column column : this.columnsToAdd) {
                this.checkDefaultReferencesTable(column.getDefaultExpression());
            }
        }
        switch (this.type) {
            case 8: {
                if (!this.oldColumn.isNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                database.update(this.session, this.table);
                break;
            }
            case 9: {
                if (this.oldColumn.isNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                database.update(this.session, this.table);
                break;
            }
            case 10: {
                this.checkDefaultReferencesTable(this.defaultExpression);
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(sequence);
                database.update(this.session, this.table);
                break;
            }
            case 11: {
                if (this.oldColumn.isWideningConversion(this.newColumn)) {
                    this.convertAutoIncrementColumn(this.newColumn);
                    this.oldColumn.copy(this.newColumn);
                    database.update(this.session, this.table);
                    break;
                }
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                    this.checkNullable();
                }
                this.convertAutoIncrementColumn(this.newColumn);
                this.copyData();
                break;
            }
            case 7: {
                if (this.ifNotExists && this.columnsToAdd.size() == 1 && this.table.doesColumnExist(this.columnsToAdd.get(0).getName())) break;
                for (Column column : this.columnsToAdd) {
                    this.convertAutoIncrementColumn(column);
                }
                this.copyData();
                break;
            }
            case 12: {
                if (this.table.getColumns().length == 1) {
                    throw DbException.get(90084, this.oldColumn.getSQL());
                }
                this.table.dropSingleColumnConstraintsAndIndexes(this.session, this.oldColumn);
                this.copyData();
                break;
            }
            case 13: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.update(this.session, this.table);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void checkDefaultReferencesTable(Expression expression) {
        if (expression == null) {
            return;
        }
        HashSet<DbObject> hashSet = New.hashSet();
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        expression.isEverything(expressionVisitor);
        if (hashSet.contains(this.table)) {
            throw DbException.get(90083, expression.getSQL());
        }
    }

    private void convertAutoIncrementColumn(Column column) {
        if (column.isAutoIncrement()) {
            if (column.isPrimaryKey()) {
                column.setOriginalSQL("IDENTITY");
            } else {
                int n = this.getObjectId();
                column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, this.table.isTemporary());
            }
        }
    }

    private void removeSequence(Sequence sequence) {
        if (sequence != null) {
            this.table.removeSequence(sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void copyData() {
        String string;
        if (this.table.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database database = this.session.getDatabase();
        String string2 = this.table.getName();
        String string3 = database.getTempTableName(string2, this.session);
        Column[] columnArray = this.table.getColumns();
        ArrayList<Column> arrayList = New.arrayList();
        Table table = this.cloneTableStructure(columnArray, database, string3, arrayList);
        try {
            this.checkViews(this.table, table);
        }
        catch (DbException dbException) {
            this.execute("DROP TABLE " + table.getName(), true);
            throw DbException.get(90109, dbException, this.getSQL(), dbException.getMessage());
        }
        String string4 = this.table.getName();
        ArrayList<TableView> arrayList2 = this.table.getViews();
        if (arrayList2 != null) {
            arrayList2 = New.arrayList(arrayList2);
            for (TableView dbObject : arrayList2) {
                this.table.removeView(dbObject);
            }
        }
        this.execute("DROP TABLE " + this.table.getSQL() + " IGNORE", true);
        database.renameSchemaObject(this.session, table, string4);
        for (DbObject dbObject : table.getChildren()) {
            if (dbObject instanceof Sequence || (string = dbObject.getName()) == null || dbObject.getCreateSQL() == null || !string.startsWith(string3 + "_")) continue;
            string = string.substring(string3.length() + 1);
            SchemaObject schemaObject = (SchemaObject)dbObject;
            if (schemaObject instanceof Constraint) {
                if (schemaObject.getSchema().findConstraint(this.session, string) != null) {
                    string = schemaObject.getSchema().getUniqueConstraintName(this.session, table);
                }
            } else if (schemaObject instanceof Index && schemaObject.getSchema().findIndex(this.session, string) != null) {
                string = schemaObject.getSchema().getUniqueIndexName(this.session, table, string);
            }
            database.renameSchemaObject(this.session, schemaObject, string);
        }
        if (arrayList2 != null) {
            for (TableView tableView : arrayList2) {
                string = tableView.getCreateSQL(true, true);
                this.execute(string, true);
            }
        }
    }

    private Table cloneTableStructure(Column[] columnArray, Database database, String string, ArrayList<Column> arrayList) {
        Object object;
        Object object2;
        for (Column object42 : columnArray) {
            arrayList.add(object42.getClone());
        }
        if (this.type == 12) {
            int n = this.oldColumn.getColumnId();
            arrayList.remove(n);
        } else if (this.type == 7) {
            int n = this.addBefore != null ? this.table.getColumn(this.addBefore).getColumnId() : (this.addAfter != null ? this.table.getColumn(this.addAfter).getColumnId() + 1 : columnArray.length);
            for (Column column : this.columnsToAdd) {
                arrayList.add(n++, column);
            }
        } else if (this.type == 11) {
            int n = this.oldColumn.getColumnId();
            arrayList.remove(n);
            arrayList.add(n, this.newColumn);
        }
        int n = database.allocateObjectId();
        CreateTableData createTableData = new CreateTableData();
        createTableData.tableName = string;
        createTableData.id = n;
        createTableData.columns = arrayList;
        createTableData.temporary = this.table.isTemporary();
        createTableData.persistData = this.table.isPersistData();
        createTableData.persistIndexes = this.table.isPersistIndexes();
        createTableData.isHidden = this.table.isHidden();
        createTableData.create = true;
        createTableData.session = this.session;
        Table table = this.getSchema().createTable(createTableData);
        table.setComment(this.table.getComment());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(table.getCreateSQL());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Column column : arrayList) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            if (this.type == 7 && this.columnsToAdd.contains(column)) {
                object2 = column.getDefaultExpression();
                stringBuilder2.append(object2 == null ? "NULL" : ((Expression)object2).getSQL());
                continue;
            }
            stringBuilder2.append(column.getSQL());
        }
        stringBuilder.append(" AS SELECT ");
        if (stringBuilder2.length() == 0) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append(" FROM ").append(this.table.getSQL());
        String string2 = stringBuilder.toString();
        String string3 = table.getName();
        object2 = table.getSchema();
        table.removeChildrenAndResources(this.session);
        this.execute(string2, true);
        table = ((Schema)object2).getTableOrView(this.session, string3);
        ArrayList<Object> arrayList2 = New.arrayList();
        for (DbObject dbObject : this.table.getChildren()) {
            ConstraintReferential constraintReferential;
            if (dbObject instanceof Sequence || dbObject instanceof Index && (object = (Index)dbObject).getIndexType().getBelongsToConstraint() || (object = dbObject.getCreateSQL()) == null || dbObject instanceof TableView) continue;
            if (dbObject.getType() == 0) {
                DbException.throwInternalError();
            }
            String string4 = Parser.quoteIdentifier(string + "_" + dbObject.getName());
            String string5 = null;
            if (dbObject instanceof ConstraintReferential && (constraintReferential = (ConstraintReferential)dbObject).getTable() != this.table) {
                string5 = constraintReferential.getCreateSQLForCopy(constraintReferential.getTable(), table, string4, false);
            }
            if (string5 == null) {
                string5 = dbObject.getCreateSQLForCopy(table, string4);
            }
            if (string5 == null) continue;
            if (dbObject instanceof TriggerObject) {
                arrayList2.add(string5);
                continue;
            }
            this.execute(string5, true);
        }
        this.table.setModified();
        for (Column column : arrayList) {
            object = column.getSequence();
            if (object == null) continue;
            this.table.removeSequence((Sequence)object);
            column.setSequence(null);
        }
        for (String string6 : arrayList2) {
            this.execute(string6, true);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkViews(SchemaObject schemaObject, SchemaObject schemaObject2) {
        String string = schemaObject.getName();
        String string2 = schemaObject2.getName();
        Database database = schemaObject.getDatabase();
        String string3 = database.getTempTableName(string, this.session);
        database.renameSchemaObject(this.session, schemaObject, string3);
        try {
            database.renameSchemaObject(this.session, schemaObject2, string);
            this.checkViewsAreValid(schemaObject);
        }
        finally {
            try {
                database.renameSchemaObject(this.session, schemaObject2, string2);
            }
            finally {
                database.renameSchemaObject(this.session, schemaObject, string);
            }
        }
    }

    private void checkViewsAreValid(DbObject dbObject) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            String string = ((TableView)dbObject2).getQuery();
            this.session.prepare(string);
            this.checkViewsAreValid(dbObject2);
        }
    }

    private void execute(String string, boolean bl) {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    private void checkNullable() {
        for (Index index : this.table.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw DbException.get(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() {
        String string = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        if (resultInterface.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setNewColumns(ArrayList<Column> arrayList) {
        this.columnsToAdd = arrayList;
    }
}

