/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.ExternalFonts;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFontEmbedder;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.MacOSRomanEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Type1Encoding;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Log LOG = LogFactory.getLog(PDTrueTypeFont.class);
    private static final int START_RANGE_F000 = 61440;
    private static final int START_RANGE_F100 = 61696;
    private static final int START_RANGE_F200 = 61952;
    private static final Map<String, Integer> INVERTED_MACOS_ROMAN = new HashMap<String, Integer>();
    private CmapSubtable cmapWinUnicode = null;
    private CmapSubtable cmapWinSymbol = null;
    private CmapSubtable cmapMacRoman = null;
    private boolean cmapInitialized = false;
    private final TrueTypeFont ttf;
    private final boolean isEmbedded;
    private final boolean isDamaged;

    @Deprecated
    public static PDTrueTypeFont loadTTF(PDDocument doc, File file) throws IOException {
        return new PDTrueTypeFont(doc, new FileInputStream(file));
    }

    @Deprecated
    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream input) throws IOException {
        return new PDTrueTypeFont(doc, input);
    }

    public PDTrueTypeFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        PDFontDescriptor fd;
        PDStream ff2Stream;
        TrueTypeFont ttfFont = null;
        boolean fontIsDamaged = false;
        if (this.getFontDescriptor() != null && (ff2Stream = (fd = super.getFontDescriptor()).getFontFile2()) != null) {
            try {
                TTFParser ttfParser = new TTFParser(true);
                ttfFont = ttfParser.parse(ff2Stream.createInputStream());
            }
            catch (NullPointerException e) {
                LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                fontIsDamaged = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                fontIsDamaged = true;
            }
        }
        this.isEmbedded = ttfFont != null;
        this.isDamaged = fontIsDamaged;
        if (ttfFont == null && (ttfFont = ExternalFonts.getTrueTypeFont(this.getBaseFont())) == null) {
            ttfFont = ExternalFonts.getTrueTypeFallbackFont(this.getFontDescriptor());
            LOG.warn((Object)("Using fallback font '" + ttfFont + "' for '" + this.getBaseFont() + "'"));
        }
        this.ttf = ttfFont;
        this.readEncoding();
    }

    public String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        if (this.getStandard14AFM() != null) {
            return new Type1Encoding(this.getStandard14AFM());
        }
        return null;
    }

    private PDTrueTypeFont(PDDocument document, InputStream ttfStream) throws IOException {
        PDTrueTypeFontEmbedder embedder = new PDTrueTypeFontEmbedder(document, this.dict, ttfStream);
        this.encoding = embedder.getFontEncoding();
        this.ttf = embedder.getTrueTypeFont();
        this.setFontDescriptor(embedder.getFontDescriptor());
        this.isEmbedded = true;
        this.isDamaged = false;
        this.glyphList = GlyphList.getAdobeGlyphList();
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public String getName() {
        return this.getBaseFont();
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        return this.ttf.getFontBBox();
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        float width = this.ttf.getAdvanceWidth(gid);
        float unitsPerEM = this.ttf.getUnitsPerEm();
        if (unitsPerEM != 1000.0f) {
            width *= 1000.0f / unitsPerEM;
        }
        return width;
    }

    @Override
    public float getHeight(int code) throws IOException {
        int gid = this.codeToGID(code);
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getBoundingBox().getHeight();
        }
        return 0.0f;
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        if (!this.getEncoding().contains(this.getGlyphList().codePointToName(unicode))) {
            throw new IllegalArgumentException(String.format("U+%04X is not available in this font's Encoding", unicode));
        }
        String name = this.getGlyphList().codePointToName(unicode);
        Map<String, Integer> inverted = this.getInvertedEncoding();
        int gid = this.ttf.getUnicodeCmap().getGlyphId(unicode);
        if (gid == 0) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X in font %s", unicode, this.getName()));
        }
        int code = inverted.get(name);
        return new byte[]{(byte)code};
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public int codeToGID(int code) throws IOException {
        this.extractCmapTable();
        int gid = 0;
        if (!this.isSymbolic()) {
            Integer macCode;
            String unicode;
            String name = this.encoding.getName(code);
            if (name.equals(".notdef")) {
                return 0;
            }
            if (this.cmapWinUnicode != null && (unicode = GlyphList.getAdobeGlyphList().toUnicode(name)) != null) {
                int uni = unicode.codePointAt(0);
                gid = this.cmapWinUnicode.getGlyphId(uni);
            }
            if (gid == 0 && this.cmapMacRoman != null && (macCode = INVERTED_MACOS_ROMAN.get(name)) != null) {
                gid = this.cmapMacRoman.getGlyphId(macCode.intValue());
            }
            if (gid == 0) {
                gid = this.ttf.nameToGID(name);
            }
        } else {
            if (this.cmapWinSymbol != null) {
                gid = this.cmapWinSymbol.getGlyphId(code);
                if (code >= 0 && code <= 255) {
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61440);
                    }
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61696);
                    }
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61952);
                    }
                }
            }
            if (gid == 0 && this.cmapMacRoman != null) {
                gid = this.cmapMacRoman.getGlyphId(code);
            }
        }
        if (gid == 0) {
            LOG.warn((Object)("Can't map code " + code + " in font " + this.getBaseFont()));
        }
        return gid;
    }

    private void extractCmapTable() throws IOException {
        if (this.cmapInitialized) {
            return;
        }
        CmapTable cmapTable = this.ttf.getCmap();
        if (cmapTable != null) {
            CmapSubtable[] cmaps;
            for (CmapSubtable cmap : cmaps = cmapTable.getCmaps()) {
                if (3 == cmap.getPlatformId()) {
                    if (1 == cmap.getPlatformEncodingId()) {
                        this.cmapWinUnicode = cmap;
                        continue;
                    }
                    if (0 != cmap.getPlatformEncodingId()) continue;
                    this.cmapWinSymbol = cmap;
                    continue;
                }
                if (1 != cmap.getPlatformId() || 0 != cmap.getPlatformEncodingId()) continue;
                this.cmapMacRoman = cmap;
            }
        }
        this.cmapInitialized = true;
    }

    static {
        Map<Integer, String> codeToName = MacOSRomanEncoding.INSTANCE.getCodeToNameMap();
        for (Map.Entry<Integer, String> entry : codeToName.entrySet()) {
            if (INVERTED_MACOS_ROMAN.containsKey(entry.getValue())) continue;
            INVERTED_MACOS_ROMAN.put(entry.getValue(), entry.getKey());
        }
    }
}

