/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font.encoding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GlyphList {
    private static final Log LOG = LogFactory.getLog(GlyphList.class);
    private static final GlyphList DEFAULT = GlyphList.load("glyphlist.txt");
    private static final GlyphList ZAPF_DINGBATS = GlyphList.load("zapfdingbats.txt");
    private final Map<String, String> nameToUnicode;
    private final Map<String, String> unicodeToName;
    private final Map<String, String> uniNameToUnicodeCache = new HashMap<String, String>();

    private static GlyphList load(String filename) {
        ClassLoader loader = GlyphList.class.getClassLoader();
        String path = "org/apache/pdfbox/resources/glyphlist/";
        try {
            return new GlyphList(loader.getResourceAsStream(path + filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GlyphList getAdobeGlyphList() {
        return DEFAULT;
    }

    public static GlyphList getZapfDingbats() {
        return ZAPF_DINGBATS;
    }

    public GlyphList(InputStream input) throws IOException {
        this.nameToUnicode = new HashMap<String, String>();
        this.unicodeToName = new HashMap<String, String>();
        this.loadList(input);
    }

    public GlyphList(GlyphList glyphList, InputStream input) throws IOException {
        this.nameToUnicode = new HashMap<String, String>(glyphList.nameToUnicode);
        this.unicodeToName = new HashMap<String, String>(glyphList.unicodeToName);
        this.loadList(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(InputStream input) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input, "ISO-8859-1"));
        try {
            while (in.ready()) {
                String line = in.readLine();
                if (line == null || line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length < 2) {
                    throw new IOException("Invalid glyph list entry: " + line);
                }
                String name = parts[0];
                String[] unicodeList = parts[1].split(" ");
                if (this.nameToUnicode.containsKey(name)) {
                    LOG.warn((Object)("duplicate value for " + name + " -> " + parts[1] + " " + this.nameToUnicode.get(name)));
                }
                int[] codePoints = new int[unicodeList.length];
                int index = 0;
                for (String hex : unicodeList) {
                    codePoints[index++] = Integer.parseInt(hex, 16);
                }
                String string = new String(codePoints, 0, codePoints.length);
                this.nameToUnicode.put(name, string);
                if (this.unicodeToName.containsKey(string)) continue;
                this.unicodeToName.put(string, name);
            }
        }
        finally {
            in.close();
        }
    }

    public String codePointToName(int codePoint) {
        String name = this.unicodeToName.get(new String(new int[]{codePoint}, 0, 1));
        if (name == null) {
            return ".notdef";
        }
        return name;
    }

    public String sequenceToName(String unicodeSequence) {
        String name = this.unicodeToName.get(unicodeSequence);
        if (name == null) {
            return ".notdef";
        }
        return name;
    }

    public String toUnicode(String name) {
        if (name == null) {
            return null;
        }
        String unicode = this.nameToUnicode.get(name);
        if (unicode != null) {
            return unicode;
        }
        unicode = this.uniNameToUnicodeCache.get(name);
        if (unicode == null) {
            if (name.indexOf(46) > 0) {
                unicode = this.toUnicode(name.substring(0, name.indexOf(46)));
            } else if (name.startsWith("uni") && name.length() == 7) {
                int nameLength = name.length();
                StringBuilder uniStr = new StringBuilder();
                try {
                    int chPos = 3;
                    while (chPos + 4 <= nameLength) {
                        int codePoint = Integer.parseInt(name.substring(chPos, chPos + 4), 16);
                        if (codePoint > 55295 && codePoint < 57344) {
                            LOG.warn((Object)("Unicode character name with disallowed code area: " + name));
                        } else {
                            uniStr.append((char)codePoint);
                        }
                        chPos += 4;
                    }
                    unicode = uniStr.toString();
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)("Not a number in Unicode character name: " + name));
                }
            } else if (name.startsWith("u") && name.length() == 5) {
                try {
                    int codePoint = Integer.parseInt(name.substring(1), 16);
                    if (codePoint > 55295 && codePoint < 57344) {
                        LOG.warn((Object)("Unicode character name with disallowed code area: " + name));
                    } else {
                        unicode = String.valueOf((char)codePoint);
                    }
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)("Not a number in Unicode character name: " + name));
                }
            }
            this.uniNameToUnicodeCache.put(name, unicode);
        }
        return unicode;
    }

    static {
        try {
            String location = System.getProperty("glyphlist_ext");
            if (location != null) {
                throw new UnsupportedOperationException("glyphlist_ext is no longer supported, use GlyphList.DEFAULT.addGlyphs(Properties) instead");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

